/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.base.protos.SystemServicePb;
import com.google.apphosting.runtime.SystemService;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class SystemServiceTest {
    @Mock
    private ApiProxy.Delegate<ApiProxy.Environment> delegate;
    @Mock
    private ApiProxy.Environment environment;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        ApiProxy.setDelegate(this.delegate);
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)this.environment);
    }

    @Test
    public void testStartBackgroundRequest() throws Exception {
        String expectedRequestId = "abcd";
        SystemServicePb.StartBackgroundRequestRequest requestProto = SystemServicePb.StartBackgroundRequestRequest.getDefaultInstance();
        SystemServicePb.StartBackgroundRequestResponse responseProto = SystemServicePb.StartBackgroundRequestResponse.newBuilder().setRequestId(expectedRequestId).build();
        Mockito.when((Object)this.delegate.makeSyncCall(ApiProxy.getCurrentEnvironment(), "system", "StartBackgroundRequest", requestProto.toByteArray())).thenReturn((Object)responseProto.toByteArray());
        String requestId = new SystemService().startBackgroundRequest();
        Truth.assertThat((String)requestId).isEqualTo((Object)expectedRequestId);
    }

    @Test
    public void testStartBackgroundRequest_InternalError() throws Exception {
        SystemServicePb.StartBackgroundRequestRequest requestProto = SystemServicePb.StartBackgroundRequestRequest.getDefaultInstance();
        Mockito.when((Object)this.delegate.makeSyncCall(ApiProxy.getCurrentEnvironment(), "system", "StartBackgroundRequest", requestProto.toByteArray())).thenThrow(new Throwable[]{new ApiProxy.ApplicationException(1)});
        IllegalStateException ex = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new SystemService().startBackgroundRequest());
        Truth.assertThat((Throwable)ex).hasMessageThat().startsWith("An internal error occurred");
    }

    @Test
    public void testStartBackgroundRequest_BackendRequired() throws Exception {
        SystemServicePb.StartBackgroundRequestRequest requestProto = SystemServicePb.StartBackgroundRequestRequest.getDefaultInstance();
        Mockito.when((Object)this.delegate.makeSyncCall(ApiProxy.getCurrentEnvironment(), "system", "StartBackgroundRequest", requestProto.toByteArray())).thenThrow(new Throwable[]{new ApiProxy.ApplicationException(2)});
        IllegalStateException ex = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new SystemService().startBackgroundRequest());
        Truth.assertThat((Throwable)ex).hasMessageThat().isEqualTo((Object)"This feature is only available to backend instances.");
    }

    @Test
    public void testStartBackgroundRequest_LimitReached() throws Exception {
        SystemServicePb.StartBackgroundRequestRequest requestProto = SystemServicePb.StartBackgroundRequestRequest.getDefaultInstance();
        Mockito.when((Object)this.delegate.makeSyncCall(ApiProxy.getCurrentEnvironment(), "system", "StartBackgroundRequest", requestProto.toByteArray())).thenThrow(new Throwable[]{new ApiProxy.ApplicationException(3)});
        IllegalStateException ex = (IllegalStateException)Assert.assertThrows(IllegalStateException.class, () -> new SystemService().startBackgroundRequest());
        Truth.assertThat((Throwable)ex).hasMessageThat().isEqualTo((Object)"Limit on the number of active background requests was reached for this app version.");
    }
}

