/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.runtime.ThreadGroupPool;
import com.google.common.base.Throwables;
import com.google.common.truth.Truth;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ThreadGroupPoolTest {
    private ThreadGroup root;
    private ThreadGroupPool threadGroupPool;
    private BlockingQueue<Throwable> caughtException;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;

    @Before
    public void setUp() {
        this.root = new ThreadGroup("root");
        this.caughtException = new ArrayBlockingQueue<Throwable>(100);
        this.uncaughtExceptionHandler = (thread, throwable) -> {
            throwable.printStackTrace();
            this.caughtException.offer(throwable);
        };
        this.threadGroupPool = ThreadGroupPool.builder().setParentThreadGroup(this.root).setThreadGroupNamePrefix("subgroup-").setUncaughtExceptionHandler(this.uncaughtExceptionHandler).setIgnoreDaemonThreads(false).build();
    }

    @After
    public void checkNoExceptionFromThreads() {
        Throwable caught = (Throwable)this.caughtException.poll();
        if (caught != null) {
            Truth.assertWithMessage((String)Throwables.getStackTraceAsString((Throwable)caught)).that(caught).isNull();
        }
    }

    @Test
    public void testStartOne() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.threadGroupPool.start("newThread", () -> {
            Thread thread = Thread.currentThread();
            Truth.assertThat((String)thread.getThreadGroup().getName()).isEqualTo((Object)"subgroup-0");
            Truth.assertThat((String)thread.getThreadGroup().getParent().getName()).isEqualTo((Object)"root");
            Truth.assertThat((String)thread.getName()).isEqualTo((Object)"newThread");
            latch.countDown();
        });
        this.await(latch);
    }

    @Test
    public void testStartOneReuseThread() throws Exception {
        CountDownLatch latch1 = new CountDownLatch(1);
        Truth.assertThat((Integer)this.threadGroupPool.waitingThreadCount()).isEqualTo((Object)0);
        this.threadGroupPool.start("newThread1", () -> {
            Thread thread = Thread.currentThread();
            Truth.assertThat((String)thread.getThreadGroup().getName()).isEqualTo((Object)"subgroup-0");
            Truth.assertThat((String)thread.getThreadGroup().getParent().getName()).isEqualTo((Object)"root");
            Truth.assertThat((String)thread.getName()).isEqualTo((Object)"newThread1");
            latch1.countDown();
        });
        this.await(latch1);
        for (int i = 0; i < 100 && this.threadGroupPool.waitingThreadCount() <= 0; ++i) {
            Thread.sleep(10L);
        }
        Truth.assertWithMessage((String)"Thread was never returned to the pool").that(Integer.valueOf(this.threadGroupPool.waitingThreadCount())).isGreaterThan((Comparable)Integer.valueOf(0));
        CountDownLatch latch2 = new CountDownLatch(1);
        this.threadGroupPool.start("newThread2", () -> {
            Thread thread = Thread.currentThread();
            Truth.assertThat((String)thread.getThreadGroup().getName()).isEqualTo((Object)"subgroup-0");
            Truth.assertThat((String)thread.getThreadGroup().getParent().getName()).isEqualTo((Object)"root");
            Truth.assertThat((String)thread.getName()).isEqualTo((Object)"newThread2");
            latch2.countDown();
        });
        this.await(latch2);
    }

    @Test
    public void testStartTwoInParallel() throws Exception {
        CyclicBarrier barrier = new CyclicBarrier(2);
        CountDownLatch latch = new CountDownLatch(2);
        this.threadGroupPool.start("newThread1", () -> {
            Thread thread = Thread.currentThread();
            Truth.assertThat((String)thread.getThreadGroup().getName()).isEqualTo((Object)"subgroup-0");
            Truth.assertThat((String)thread.getThreadGroup().getParent().getName()).isEqualTo((Object)"root");
            Truth.assertThat((String)thread.getName()).isEqualTo((Object)"newThread1");
            try {
                barrier.await();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            latch.countDown();
        });
        this.threadGroupPool.start("newThread2", () -> {
            Thread thread = Thread.currentThread();
            Truth.assertThat((String)thread.getThreadGroup().getName()).isEqualTo((Object)"subgroup-1");
            Truth.assertThat((String)thread.getThreadGroup().getParent().getName()).isEqualTo((Object)"root");
            Truth.assertThat((String)thread.getName()).isEqualTo((Object)"newThread2");
            try {
                barrier.await();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            latch.countDown();
        });
        this.await(latch);
    }

    @Test
    public void testUncaughtException() throws Exception {
        this.threadGroupPool.start("newThread", () -> {
            throw new RuntimeException("intentional");
        });
        Throwable caught = this.caughtException.poll(10L, TimeUnit.SECONDS);
        Truth.assertWithMessage((String)"Timed out while waiting for expected exception").that(caught).isNotNull();
        Truth.assertThat((Throwable)caught).hasMessageThat().isEqualTo((Object)"intentional");
    }

    private void await(CountDownLatch latch) throws InterruptedException {
        boolean ok = latch.await(10L, TimeUnit.SECONDS);
        this.checkNoExceptionFromThreads();
        Truth.assertWithMessage((String)"Timeout while waiting for latch").that(Boolean.valueOf(ok)).isTrue();
    }
}

