/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.protos.TraceId;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.runtime.TraceContextHelper;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TraceContextHelperTest {
    @Test
    public void testBasic() {
        TracePb.TraceContextProto contextProto = TracePb.TraceContextProto.newBuilder().setTraceId(TraceId.TraceIdProto.newBuilder().setHi(-1L).setLo(1383505804687056944L).build().toByteString()).setSpanId(1L).setTraceMask(3).build();
        CloudTraceContext contextFromProto = TraceContextHelper.toObject((TracePb.TraceContextProto)contextProto);
        Truth.assertThat((byte[])contextFromProto.getTraceId()).isEqualTo((Object)contextProto.getTraceId().toByteArray());
        Truth.assertThat((Long)contextFromProto.getSpanId()).isEqualTo((Object)1L);
        Truth.assertThat((Long)contextFromProto.getTraceMask()).isEqualTo((Object)3L);
        Truth.assertThat((Boolean)contextFromProto.isTraceEnabled()).isTrue();
        Truth.assertThat((Boolean)TraceContextHelper.isStackTraceEnabled((CloudTraceContext)contextFromProto)).isTrue();
        TracePb.TraceContextProto protoFromContext = TraceContextHelper.toProto2((CloudTraceContext)contextFromProto);
        Truth.assertThat((byte[])protoFromContext.getTraceId().toByteArray()).isEqualTo((Object)contextFromProto.getTraceId());
        Truth.assertThat((Long)protoFromContext.getSpanId()).isEqualTo((Object)1L);
        Truth.assertThat((Integer)protoFromContext.getTraceMask()).isEqualTo((Object)3L);
    }

    @Test
    public void testParseContextHeader() throws InvalidProtocolBufferException {
        TracePb.TraceContextProto contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/789;o=1");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Long)contextProto.getSpanId()).isEqualTo((Object)789L);
        Truth.assertThat((Integer)contextProto.getTraceMask()).isEqualTo((Object)1L);
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/789;o=");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Long)contextProto.getSpanId()).isEqualTo((Object)789L);
        Truth.assertThat((Boolean)contextProto.hasTraceMask()).isFalse();
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/789");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Long)contextProto.getSpanId()).isEqualTo((Object)789L);
        Truth.assertThat((Boolean)contextProto.hasTraceMask()).isFalse();
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/;o=1");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Boolean)contextProto.hasSpanId()).isFalse();
        Truth.assertThat((Integer)contextProto.getTraceMask()).isEqualTo((Object)1L);
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/;o=");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Boolean)contextProto.hasSpanId()).isFalse();
        Truth.assertThat((Boolean)contextProto.hasTraceMask()).isFalse();
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Boolean)contextProto.hasSpanId()).isFalse();
        Truth.assertThat((Boolean)contextProto.hasTraceMask()).isFalse();
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8;o=1");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Boolean)contextProto.hasSpanId()).isFalse();
        Truth.assertThat((Integer)contextProto.getTraceMask()).isEqualTo((Object)1L);
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8;o=");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Boolean)contextProto.hasSpanId()).isFalse();
        Truth.assertThat((Boolean)contextProto.hasTraceMask()).isFalse();
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Boolean)contextProto.hasSpanId()).isFalse();
        Truth.assertThat((Boolean)contextProto.hasTraceMask()).isFalse();
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/18446744073709551615;o=");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((String)Long.toUnsignedString(contextProto.getSpanId())).isEqualTo((Object)"18446744073709551615");
        Truth.assertThat((Boolean)contextProto.hasTraceMask()).isFalse();
        contextProto = TraceContextHelper.parseTraceContextHeader((String)"FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF/18446744073709551615;o=4294967295");
        Truth.assertThat((String)TraceContextHelperTest.getTraceId(contextProto)).isEqualTo((Object)"ffffffffffffffffffffffffffffffff");
        Truth.assertThat((String)Long.toUnsignedString(contextProto.getSpanId())).isEqualTo((Object)"18446744073709551615");
        Truth.assertThat((String)Integer.toUnsignedString(contextProto.getTraceMask())).isEqualTo((Object)"4294967295");
        NumberFormatException noTraceIdExpected = (NumberFormatException)Assert.assertThrows(NumberFormatException.class, () -> TraceContextHelper.parseTraceContextHeader((String)""));
        Truth.assertThat((Throwable)noTraceIdExpected).hasMessageThat().contains((CharSequence)"length too short");
        NumberFormatException badTraceIdExpected = (NumberFormatException)Assert.assertThrows(NumberFormatException.class, () -> TraceContextHelper.parseTraceContextHeader((String)"000000007b0000001c8"));
        Truth.assertThat((Throwable)badTraceIdExpected).hasMessageThat().contains((CharSequence)"length too short");
        NumberFormatException badSpanIdExpected = (NumberFormatException)Assert.assertThrows(NumberFormatException.class, () -> TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/ab;o=1"));
        Truth.assertThat((Throwable)badSpanIdExpected).hasMessageThat().contains((CharSequence)"For input string: \"ab\"");
        NumberFormatException badTraceMaskIdExpected = (NumberFormatException)Assert.assertThrows(NumberFormatException.class, () -> TraceContextHelper.parseTraceContextHeader((String)"000000000000007b00000000000001c8/123;o=4294967296"));
        Truth.assertThat((Throwable)badTraceMaskIdExpected).hasMessageThat().contains((CharSequence)"String value 4294967296 exceeds range of unsigned int");
    }

    private static String getTraceId(TracePb.TraceContextProto proto) throws InvalidProtocolBufferException {
        TraceId.TraceIdProto traceIdProto = TraceId.TraceIdProto.parseFrom((ByteString)proto.getTraceId(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        return String.format("%016x%016x", traceIdProto.getHi(), traceIdProto.getLo());
    }
}

