/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.TraceWriter;
import com.google.common.testing.GcFinalization;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import java.util.Random;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class TraceWriterMemoryTest {
    @Test
    public void traceWriterDoesNotLeak() throws Exception {
        TraceWriter writer = this.createTraceWriter();
        Runtime runtime = Runtime.getRuntime();
        this.createManyApiSpans(writer);
        GcFinalization.awaitFullGc();
        this.createManyApiSpans(writer);
        GcFinalization.awaitFullGc();
        long freeAfterSecond = runtime.freeMemory();
        this.createManyApiSpans(writer);
        GcFinalization.awaitFullGc();
        long freeAfterThird = runtime.freeMemory();
        Truth.assertThat((Long)(freeAfterThird - freeAfterSecond)).isLessThan((Comparable)Long.valueOf(400000000L));
    }

    private TraceWriter createTraceWriter() {
        RuntimePb.UPRequest.Builder upRequest = RuntimePb.UPRequest.newBuilder();
        upRequest.setRequestType(RuntimePb.UPRequest.RequestType.BACKGROUND);
        TracePb.TraceContextProto.Builder contextProto = upRequest.getTraceContextBuilder();
        contextProto.setTraceId(ByteString.copyFromUtf8((String)"trace id"));
        contextProto.setSpanId(1L);
        contextProto.setTraceMask(1);
        MutableUpResponse upResponse = new MutableUpResponse();
        return TraceWriter.getTraceWriterForRequest((RuntimePb.UPRequest)upRequest.buildPartial(), (MutableUpResponse)upResponse);
    }

    private void createManyApiSpans(TraceWriter writer) {
        Random random = new Random();
        writer.startRequestSpan("request " + random.nextInt(1000000));
        for (int i = 0; i < 1000000; ++i) {
            CloudTraceContext apiContext = writer.startApiSpan(null, "package", "method");
            CloudTraceContext childContext = writer.startChildSpan(apiContext, "child " + random.nextInt(1000000));
            writer.endSpan(childContext);
            writer.endApiSpan(apiContext);
        }
        writer.endRequestSpan();
    }
}

