/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime;

import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.SpanDetails;
import com.google.apphosting.base.protos.SpanKindOuterClass;
import com.google.apphosting.base.protos.TraceEvents;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.TraceWriter;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class TraceWriterTest {
    private MutableUpResponse upResponse;
    private TraceWriter writer;

    @Before
    public void setUp() throws Exception {
        RuntimePb.UPRequest.Builder upRequest = RuntimePb.UPRequest.newBuilder();
        TracePb.TraceContextProto.Builder contextProto = upRequest.getTraceContextBuilder();
        contextProto.setTraceId(ByteString.copyFromUtf8((String)"trace id"));
        contextProto.setSpanId(1L);
        contextProto.setTraceMask(1);
        this.upResponse = new MutableUpResponse();
        this.writer = TraceWriter.getTraceWriterForRequest((RuntimePb.UPRequest)upRequest.buildPartial(), (MutableUpResponse)this.upResponse);
    }

    @Test
    public void testOneChild() throws InvalidProtocolBufferException {
        this.writer.startRequestSpan("http://foo.com/request");
        CloudTraceContext childContext = this.writer.startApiSpan(null, "package", "method");
        StackTraceElement[] stackTrace = new StackTraceElement[140];
        stackTrace[0] = new StackTraceElement("class0", "method0", "file0", 1);
        stackTrace[1] = new StackTraceElement("class1", "method1", null, 1);
        stackTrace[2] = new StackTraceElement("class1", "method2", "file2", 0);
        stackTrace[3] = new StackTraceElement("class1", "method3", "file3", -1);
        stackTrace[4] = new StackTraceElement("class1", "method4", null, 0);
        for (int i = 5; i < 140; ++i) {
            stackTrace[i] = new StackTraceElement("class", "method", "file", i);
        }
        this.writer.addStackTrace(childContext, stackTrace);
        this.writer.endApiSpan(childContext);
        this.writer.endRequestSpan();
        this.writer.flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Iterable)traceEvents.getSpanEventsList()).hasSize(2);
        Truth.assertThat((Iterable)traceEvents.getDictionaryEntriesList()).hasSize(1);
        SpanDetails.StackTraceDetails stackTraceDetails = traceEvents.getDictionaryEntries(0).getStackTraceValue();
        Truth.assertThat((Iterable)stackTraceDetails.getStackFrameList()).hasSize(128);
        SpanDetails.StackTraceDetails.StackFrame stackFrame = stackTraceDetails.getStackFrame(0);
        Truth.assertThat((String)stackFrame.getClassName()).isEqualTo((Object)"class0");
        Truth.assertThat((String)stackFrame.getMethodName()).isEqualTo((Object)"method0");
        Truth.assertThat((String)stackFrame.getFileName()).isEqualTo((Object)"file0");
        Truth.assertThat((Long)stackFrame.getLineNumber()).isEqualTo((Object)1);
        for (int i = 1; i < 128; ++i) {
            SpanDetails.StackTraceDetails.StackFrame frame = stackTraceDetails.getStackFrame(i);
            Truth.assertThat((String)frame.getClassName()).isEqualTo((Object)"class");
            Truth.assertThat((String)frame.getMethodName()).isEqualTo((Object)"method");
            Truth.assertThat((String)frame.getFileName()).isEqualTo((Object)"file");
            Truth.assertThat((Long)frame.getLineNumber()).isEqualTo((Object)(i + 4));
        }
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        long requestSpanId = spanEvents.getSpanId().getId();
        Truth.assertThat((Iterable)spanEvents.getEventList()).hasSize(2);
        TraceEvents.SpanEventProto startSpanEvent = spanEvents.getEvent(0);
        TraceEvents.StartSpanProto startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_SERVER);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"http://foo.com/request");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)1L);
        TraceEvents.SpanEventProto endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        Truth.assertThat((Boolean)spanEvents.getFullSpan()).isTrue();
        spanEvents = traceEvents.getSpanEvents(1);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)3);
        startSpanEvent = spanEvents.getEvent(0);
        startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/package.method");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        TraceEvents.SpanEventProto annotateSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)annotateSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        Truth.assertThat((Boolean)annotateSpanEvent.getAnnotateSpan().getSpanDetails().hasStackTraceDetails()).isFalse();
        Truth.assertThat((Long)annotateSpanEvent.getAnnotateSpan().getSpanDetails().getStackTraceHashId()).isEqualTo((Object)traceEvents.getDictionaryEntries(0).getKey());
        endSpanEvent = spanEvents.getEvent(2);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(annotateSpanEvent.getTimestamp()));
        Truth.assertThat((Boolean)spanEvents.getFullSpan()).isTrue();
    }

    @Test
    public void testTwoChildren() throws InvalidProtocolBufferException {
        this.writer.startRequestSpan("http://foo.com/request");
        CloudTraceContext childContext1 = this.writer.startApiSpan(null, "package", "method1");
        CloudTraceContext childContext2 = this.writer.startApiSpan(null, "package", "method2");
        this.writer.endApiSpan(childContext1);
        this.writer.endApiSpan(childContext2);
        this.writer.endRequestSpan();
        this.writer.flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Integer)traceEvents.getSpanEventsCount()).isEqualTo((Object)3);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        long requestSpanId = spanEvents.getSpanId().getId();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        TraceEvents.SpanEventProto startSpanEvent = spanEvents.getEvent(0);
        TraceEvents.StartSpanProto startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_SERVER);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"http://foo.com/request");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)1L);
        TraceEvents.SpanEventProto endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        Truth.assertThat((Boolean)spanEvents.getFullSpan()).isTrue();
        spanEvents = traceEvents.getSpanEvents(1);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        startSpanEvent = spanEvents.getEvent(0);
        startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/package.method1");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        Truth.assertThat((Boolean)spanEvents.getFullSpan()).isTrue();
        spanEvents = traceEvents.getSpanEvents(2);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        startSpanEvent = spanEvents.getEvent(0);
        startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.RPC_CLIENT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/package.method2");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        Truth.assertThat((Boolean)spanEvents.getFullSpan()).isTrue();
    }

    @Test
    public void testTooManyStackTraces() throws InvalidProtocolBufferException {
        this.writer.startRequestSpan("http://foo.com/request");
        CloudTraceContext childContext1 = this.writer.startApiSpan(null, "package", "method1");
        StackTraceElement[] stackTrace1 = new StackTraceElement[]{new StackTraceElement("class1", "method1", "file1", 1)};
        this.writer.addStackTrace(childContext1, stackTrace1);
        this.writer.endApiSpan(childContext1);
        CloudTraceContext childContext2 = this.writer.startApiSpan(null, "package", "method2");
        this.writer.addStackTrace(childContext2, stackTrace1);
        this.writer.endApiSpan(childContext2);
        for (int i = 3; i < 1027; ++i) {
            CloudTraceContext childContext = this.writer.startApiSpan(null, "package", "method" + i);
            StackTraceElement[] stackTrace = new StackTraceElement[]{new StackTraceElement("class" + i, "method" + i, "file" + i, i)};
            this.writer.addStackTrace(childContext, stackTrace);
            this.writer.endApiSpan(childContext);
        }
        CloudTraceContext childContextLast = this.writer.startApiSpan(null, "package", "methodLast");
        this.writer.addStackTrace(childContextLast, stackTrace1);
        this.writer.endApiSpan(childContextLast);
        this.writer.endRequestSpan();
        this.writer.flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Iterable)traceEvents.getSpanEventsList()).hasSize(1028);
        Truth.assertThat((Iterable)traceEvents.getDictionaryEntriesList()).hasSize(1024);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Iterable)spanEvents.getEventList()).hasSize(2);
        spanEvents = traceEvents.getSpanEvents(1);
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)3);
        long id1 = spanEvents.getEvent(1).getAnnotateSpan().getSpanDetails().getStackTraceHashId();
        spanEvents = traceEvents.getSpanEvents(2);
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)3);
        long id2 = spanEvents.getEvent(1).getAnnotateSpan().getSpanDetails().getStackTraceHashId();
        Truth.assertThat((Long)id1).isNotEqualTo((Object)0);
        Truth.assertThat((Long)id2).isEqualTo((Object)id1);
        for (int i = 3; i < 1026; ++i) {
            spanEvents = traceEvents.getSpanEvents(i);
            Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)3);
            Truth.assertThat((Boolean)spanEvents.getEvent(1).getAnnotateSpan().getSpanDetails().hasStackTraceHashId()).isTrue();
        }
        spanEvents = traceEvents.getSpanEvents(1026);
        Truth.assertThat((Iterable)spanEvents.getEventList()).hasSize(2);
        spanEvents = traceEvents.getSpanEvents(1027);
        Truth.assertThat((Iterable)spanEvents.getEventList()).hasSize(3);
        long idLast = spanEvents.getEvent(1).getAnnotateSpan().getSpanDetails().getStackTraceHashId();
        Truth.assertThat((Long)idLast).isEqualTo((Object)id1);
    }

    @Test
    public void testChildSpan() throws InvalidProtocolBufferException {
        this.writer.startRequestSpan("http://foo.com/request");
        CloudTraceContext childContext = this.writer.startChildSpan(this.writer.getTraceContext(), "/child");
        CloudTraceContext apiContext = this.writer.startApiSpan(childContext, "package", "method");
        this.writer.endApiSpan(apiContext);
        this.writer.endSpan(childContext);
        this.writer.endRequestSpan();
        this.writer.flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Integer)traceEvents.getSpanEventsCount()).isEqualTo((Object)3);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        long requestSpanId = spanEvents.getSpanId().getId();
        spanEvents = traceEvents.getSpanEvents(1);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        long childSpanId = spanEvents.getSpanId().getId();
        Truth.assertThat((Integer)spanEvents.getEventCount()).isEqualTo((Object)2);
        TraceEvents.SpanEventProto startSpanEvent = spanEvents.getEvent(0);
        TraceEvents.StartSpanProto startSpan = startSpanEvent.getStartSpan();
        Truth.assertThat((Comparable)startSpan.getKind()).isEqualTo((Object)SpanKindOuterClass.SpanKind.SPAN_DEFAULT);
        Truth.assertThat((String)startSpan.getName()).isEqualTo((Object)"/child");
        Truth.assertThat((Long)startSpan.getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        TraceEvents.SpanEventProto endSpanEvent = spanEvents.getEvent(1);
        Truth.assertThat((Long)endSpanEvent.getTimestamp()).isAtLeast((Comparable)Long.valueOf(startSpanEvent.getTimestamp()));
        spanEvents = traceEvents.getSpanEvents(2);
        Truth.assertThat((Long)spanEvents.getEvent(0).getStartSpan().getParentSpanId().getId()).isEqualTo((Object)childSpanId);
    }

    @Test
    public void testTwoChildSpans() throws InvalidProtocolBufferException {
        this.writer.startRequestSpan("http://foo.com/request");
        CloudTraceContext childContext1 = this.writer.startChildSpan(this.writer.getTraceContext(), "/child1");
        CloudTraceContext childContext2 = this.writer.startChildSpan(childContext1, "/child2");
        this.writer.endSpan(childContext2);
        this.writer.endSpan(childContext1);
        this.writer.endRequestSpan();
        this.writer.flushTrace();
        TraceEvents.TraceEventsProto traceEvents = TraceEvents.TraceEventsProto.parseFrom((ByteString)this.upResponse.getSerializedTrace());
        Truth.assertThat((Integer)traceEvents.getSpanEventsCount()).isEqualTo((Object)3);
        TraceEvents.SpanEventsProto spanEvents = traceEvents.getSpanEvents(0);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        long requestSpanId = spanEvents.getSpanId().getId();
        spanEvents = traceEvents.getSpanEvents(1);
        Truth.assertThat((Boolean)spanEvents.getSpanId().hasId()).isTrue();
        long childSpanId1 = spanEvents.getSpanId().getId();
        Truth.assertThat((Long)spanEvents.getEvent(0).getStartSpan().getParentSpanId().getId()).isEqualTo((Object)requestSpanId);
        spanEvents = traceEvents.getSpanEvents(2);
        Truth.assertThat((Long)spanEvents.getEvent(0).getStartSpan().getParentSpanId().getId()).isEqualTo((Object)childSpanId1);
    }
}

