/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.anyrpc;

import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.ClonePb;
import com.google.apphosting.base.protos.EmptyMessage;
import com.google.apphosting.base.protos.ModelClonePb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.Status;
import com.google.apphosting.runtime.anyrpc.AnyRpcCallback;
import com.google.apphosting.runtime.anyrpc.AnyRpcClientContext;
import com.google.apphosting.runtime.anyrpc.AnyRpcClientContextFactory;
import com.google.apphosting.runtime.anyrpc.AnyRpcPlugin;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.anyrpc.ClientInterfaces;
import com.google.apphosting.runtime.anyrpc.CloneControllerServerInterface;
import com.google.apphosting.runtime.anyrpc.EvaluationRuntimeServerInterface;
import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableList;
import com.google.common.flogger.GoogleLogger;
import com.google.common.reflect.Reflection;
import com.google.common.testing.TestLogHandler;
import com.google.common.truth.OptionalSubject;
import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public abstract class AbstractRpcCompatibilityTest {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    private static final int RPC_SERVER_ERROR = 3;
    private static final int RPC_DEADLINE_EXCEEDED = 4;
    private static final int RPC_CANCELLED = 6;
    ClockHandler clockHandler;
    private AnyRpcClientContextFactory rpcClientContextFactory;
    private TestLogHandler testLogHandler;
    private final List<String> asynchronousFailures = Collections.synchronizedList(new ArrayList());
    private boolean checkLogMessages = true;
    private final List<String> expectedLogMessages = new ArrayList<String>();
    @Rule
    public TestRule logCheckerRule = new TestWatcher(){

        protected void succeeded(Description description) {
            if (AbstractRpcCompatibilityTest.this.checkLogMessages) {
                ArrayList<String> messages = new ArrayList<String>();
                for (LogRecord logRecord : AbstractRpcCompatibilityTest.this.testLogHandler.getStoredLogRecords()) {
                    if (logRecord.getLevel().intValue() < Level.WARNING.intValue()) continue;
                    messages.add(new SimpleFormatter().formatMessage(logRecord));
                }
                Truth.assertThat(messages).isEqualTo((Object)AbstractRpcCompatibilityTest.this.expectedLogMessages);
            }
        }
    };
    private static final ImmutableClassToInstanceMap<Message> FAKE_MESSAGES = ImmutableClassToInstanceMap.builder().put(EmptyMessage.class, (Object)EmptyMessage.getDefaultInstance()).put(RuntimePb.UPRequest.class, (Object)AbstractRpcCompatibilityTest.makeUPRequest("blim")).put(RuntimePb.UPResponse.class, (Object)RuntimePb.UPResponse.newBuilder().setError(23).build()).put(AppinfoPb.AppInfo.class, (Object)AbstractRpcCompatibilityTest.makeAppInfo()).put(ClonePb.CloneSettings.class, (Object)ClonePb.CloneSettings.newBuilder().setCloneKey(ByteString.copyFrom((String)"blam", (Charset)StandardCharsets.UTF_8)).build()).put(ClonePb.PerformanceData.class, (Object)AbstractRpcCompatibilityTest.makePerformanceData()).put(ModelClonePb.PerformanceDataRequest.class, (Object)ModelClonePb.PerformanceDataRequest.newBuilder().setType(ClonePb.PerformanceData.Type.PERIODIC_SAMPLE).build()).put(ModelClonePb.DeadlineInfo.class, (Object)ModelClonePb.DeadlineInfo.newBuilder().setSecurityTicket("tickety boo").setHard(true).build()).put(ClonePb.CloudDebuggerBreakpoints.class, (Object)AbstractRpcCompatibilityTest.makeCloudDebuggerBreakpoints()).put(ClonePb.DebuggeeInfoRequest.class, (Object)ClonePb.DebuggeeInfoRequest.newBuilder().setAppVersionId("app/1.1").build()).put(ClonePb.DebuggeeInfoResponse.class, (Object)ClonePb.DebuggeeInfoResponse.getDefaultInstance()).build();

    abstract AnyRpcClientContextFactory newRpcClientContextFactory();

    abstract ClientInterfaces.EvaluationRuntimeClient newEvaluationRuntimeClient();

    abstract ClientInterfaces.CloneControllerClient newCloneControllerClient();

    abstract ClockHandler getClockHandler();

    abstract AnyRpcPlugin getClientPlugin();

    abstract AnyRpcPlugin getServerPlugin();

    abstract int getPacketSize();

    @Before
    public void setUpAbstractRpcCompatibilityTest() throws IOException {
        this.clockHandler = this.getClockHandler();
        this.rpcClientContextFactory = this.newRpcClientContextFactory();
        this.testLogHandler = new TestLogHandler();
        Logger.getLogger("").addHandler((Handler)this.testLogHandler);
    }

    @After
    public void tearDown() {
        AnyRpcPlugin clientRpcPlugin = this.getClientPlugin();
        AnyRpcPlugin serverRpcPlugin = this.getServerPlugin();
        if (serverRpcPlugin != null && serverRpcPlugin.serverStarted()) {
            serverRpcPlugin.stopServer();
        }
        if (clientRpcPlugin != null) {
            clientRpcPlugin.shutdown();
        }
        if (serverRpcPlugin != null) {
            serverRpcPlugin.shutdown();
        }
        Truth.assertThat(this.asynchronousFailures).isEmpty();
    }

    void dontCheckLogMessages() {
        this.checkLogMessages = false;
    }

    void addExpectedLogMessage(String message) {
        this.expectedLogMessages.add(message);
    }

    @Test
    public void testRpc() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<RuntimePb.UPResponse> callback = new TestCallback<RuntimePb.UPResponse>();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest("hello");
        evaluationRuntimeClient.handleRequest(clientContext, request, callback);
        Optional<RuntimePb.UPResponse> result = callback.result();
        ((OptionalSubject)Truth.assertWithMessage((String)"RPC should succeed").about(OptionalSubject.optionals()).that(result)).isPresent();
        Truth.assertThat((String)result.get().getErrorMessage()).startsWith("hello/");
    }

    @Test
    public void testStartTime() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<RuntimePb.UPResponse> callback = new TestCallback<RuntimePb.UPResponse>();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest("hello");
        long rpcStartTime = this.clockHandler.getMillis();
        evaluationRuntimeClient.handleRequest(clientContext, request, callback);
        this.clockHandler.advanceClock();
        long reportedStartTime = clientContext.getStartTimeMillis();
        this.clockHandler.assertStartTime(rpcStartTime, reportedStartTime);
        callback.result();
        Truth.assertThat((Long)clientContext.getStartTimeMillis()).isEqualTo((Object)reportedStartTime);
    }

    @Test
    public void testRepeatedRpcs() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<RuntimePb.UPResponse> callback = new TestCallback<RuntimePb.UPResponse>();
        HashSet<Long> globalIds = new HashSet<Long>();
        for (int i = 0; i < 10; ++i) {
            AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
            String testString = this.createRandomString(10);
            RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest(testString);
            evaluationRuntimeClient.handleRequest(clientContext, request, callback);
            Optional<RuntimePb.UPResponse> result = callback.result();
            ((OptionalSubject)Truth.assertWithMessage((String)"RPC should succeed").about(OptionalSubject.optionals()).that(result)).isPresent();
            long globalId = runtimeServer.getLatestGlobalId();
            Truth.assertThat(globalIds).doesNotContain((Object)globalId);
            globalIds.add(globalId);
        }
    }

    ImmutableList<String> expectedLogMessagesForUnimplemented() {
        return ImmutableList.of();
    }

    @Test
    public void testUnimplemented() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.CloneControllerClient cloneControllerClient = this.newCloneControllerClient();
        TestCallback<EmptyMessage> callback = new TestCallback<EmptyMessage>();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        ClonePb.CloneSettings request = ClonePb.CloneSettings.getDefaultInstance();
        cloneControllerClient.applyCloneSettings(clientContext, request, callback);
        Optional<EmptyMessage> result = callback.result();
        ((OptionalSubject)Truth.assertWithMessage((String)"RPC should not succeed").about(OptionalSubject.optionals()).that(result)).isEmpty();
        Status.StatusProto status = clientContext.getStatus();
        Truth.assertThat((Integer)status.getCode()).isNotEqualTo((Object)0);
        Truth.assertThat((String)status.getMessage()).contains((CharSequence)"UnsupportedOperationException: applyCloneSettings");
        Status.StatusProto expectedStatus = Status.StatusProto.newBuilder().setSpace("RPC").setCode(3).setMessage(status.getMessage()).setCanonicalCode(13).build();
        Truth.assertThat((Object)status).isEqualTo((Object)expectedStatus);
        for (String message : this.expectedLogMessagesForUnimplemented()) {
            this.addExpectedLogMessage(message);
        }
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<RuntimePb.UPResponse> successCallback = new TestCallback<RuntimePb.UPResponse>();
        AnyRpcClientContext successClientContext = this.rpcClientContextFactory.newClientContext();
        RuntimePb.UPRequest successRequest = AbstractRpcCompatibilityTest.makeUPRequest("hello");
        evaluationRuntimeClient.handleRequest(successClientContext, successRequest, successCallback);
        Optional<RuntimePb.UPResponse> successResult = successCallback.result();
        ((OptionalSubject)Truth.assertWithMessage((String)"RPC should succeed").about(OptionalSubject.optionals()).that(successResult)).isPresent();
        Truth.assertThat((String)successResult.get().getErrorMessage()).startsWith("hello/");
    }

    @Test
    public void testDeadline() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<EmptyMessage> callback = new TestCallback<EmptyMessage>();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        clientContext.setDeadline(0.5);
        AppinfoPb.AppInfo request = AbstractRpcCompatibilityTest.makeAppInfo();
        evaluationRuntimeClient.addAppVersion(clientContext, request, callback);
        Optional<EmptyMessage> result = callback.result();
        Truth8.assertThat(result).isEmpty();
        Status.StatusProto status = clientContext.getStatus();
        Truth.assertThat((String)status.getSpace()).isEqualTo((Object)"RPC");
        Truth.assertThat((Integer)status.getCode()).isEqualTo((Object)4);
    }

    @Test
    public void testDeadlineRemaining() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        final ArrayBlockingQueue resultQueue = new ArrayBlockingQueue(1);
        AnyRpcCallback<RuntimePb.UPResponse> callback = new AnyRpcCallback<RuntimePb.UPResponse>(){

            public void success(RuntimePb.UPResponse response) {
                resultQueue.add(Optional.of(response));
            }

            public void failure() {
                resultQueue.add(Optional.empty());
            }
        };
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        double fakeDeadline = 1234.0;
        clientContext.setDeadline(fakeDeadline);
        RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest("hello");
        evaluationRuntimeClient.handleRequest(clientContext, request, callback);
        Optional result = (Optional)resultQueue.take();
        ((OptionalSubject)Truth.assertWithMessage((String)"RPC should succeed").about(OptionalSubject.optionals()).that((Object)result)).isPresent();
        String message = ((RuntimePb.UPResponse)result.get()).getErrorMessage();
        Pattern pattern = Pattern.compile("(.*)/(.*)/(.*)");
        Truth.assertThat((String)message).matches(pattern);
        Matcher matcher = pattern.matcher(message);
        Truth.assertThat((Boolean)matcher.matches()).isTrue();
        Truth.assertThat((String)matcher.group(1)).isEqualTo((Object)"hello");
        double remainingThisThread = Double.parseDouble(matcher.group(2));
        Truth.assertThat((Double)remainingThisThread).isLessThan((Comparable)Double.valueOf(fakeDeadline));
        Truth.assertThat((Double)remainingThisThread).isGreaterThan((Comparable)Double.valueOf(fakeDeadline - 30.0));
        double remainingOtherThread = Double.parseDouble(matcher.group(3));
        Truth.assertThat((Double)remainingOtherThread).isLessThan((Comparable)Double.valueOf(fakeDeadline));
        Truth.assertThat((Double)remainingOtherThread).isGreaterThan((Comparable)Double.valueOf(fakeDeadline - 30.0));
    }

    @Test
    public void testCancelled() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<EmptyMessage> callback = new TestCallback<EmptyMessage>();
        long rpcStartTime = this.clockHandler.getMillis();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        AppinfoPb.AppInfo request = AbstractRpcCompatibilityTest.makeAppInfo();
        evaluationRuntimeClient.addAppVersion(clientContext, request, callback);
        runtimeServer.addAppVersionReceived.acquire();
        this.clockHandler.advanceClock();
        clientContext.startCancel();
        Optional<EmptyMessage> result = callback.result();
        Truth8.assertThat(result).isEmpty();
        Status.StatusProto status = clientContext.getStatus();
        Truth.assertThat((String)status.getSpace()).isEqualTo((Object)"RPC");
        Truth.assertThat((Integer)status.getCode()).isEqualTo((Object)6);
        this.clockHandler.assertStartTime(rpcStartTime, clientContext.getStartTimeMillis());
    }

    @Test
    public void testCancelAlreadyCompleted() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<RuntimePb.UPResponse> callback = new TestCallback<RuntimePb.UPResponse>();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest("hello");
        evaluationRuntimeClient.handleRequest(clientContext, request, callback);
        Optional<RuntimePb.UPResponse> result = callback.result();
        ((OptionalSubject)Truth.assertWithMessage((String)"RPC should succeed").about(OptionalSubject.optionals()).that(result)).isPresent();
        clientContext.startCancel();
    }

    @Test
    public void testLargeRoundTrip() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<RuntimePb.UPResponse> callback = new TestCallback<RuntimePb.UPResponse>();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        String requestText = this.createRandomString(this.getPacketSize());
        RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest(requestText);
        evaluationRuntimeClient.handleRequest(clientContext, request, callback);
        Optional<RuntimePb.UPResponse> result = callback.result();
        ((OptionalSubject)Truth.assertWithMessage((String)"RPC should succeed").about(OptionalSubject.optionals()).that(result)).isPresent();
        Truth.assertThat((String)result.get().getErrorMessage()).startsWith(requestText);
    }

    @Test
    public void testConcurrency_smallRequest() throws Exception {
        this.doTestConcurrency(10);
    }

    @Test
    public void testConcurrency_largeRequest() throws Exception {
        this.doTestConcurrency(this.getPacketSize());
        this.dontCheckLogMessages();
    }

    private void doTestConcurrency(int requestSize) throws InterruptedException {
        int concurrentThreads = 5;
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        Semaphore done = new Semaphore(0);
        CountDownLatch countDownLatch = new CountDownLatch(5);
        LinkedBlockingQueue exceptions = new LinkedBlockingQueue();
        Runnable runClient = () -> this.runClient(requestSize, countDownLatch, evaluationRuntimeClient, done, exceptions);
        for (int i = 0; i < 5; ++i) {
            new Thread(runClient, "Client " + i).start();
        }
        boolean acquired = done.tryAcquire(5, 20L, TimeUnit.SECONDS);
        Truth.assertThat(exceptions).isEmpty();
        Truth.assertThat((Boolean)acquired).isTrue();
    }

    private void runClient(int requestSize, CountDownLatch countDownLatch, ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient, Semaphore done, Queue<Throwable> exceptions) {
        try {
            AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
            String text = this.createRandomString(requestSize);
            RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest(text);
            countDownLatch.countDown();
            countDownLatch.await();
            TestCallback<RuntimePb.UPResponse> callback = new TestCallback<RuntimePb.UPResponse>();
            evaluationRuntimeClient.handleRequest(clientContext, request, callback);
            Optional<RuntimePb.UPResponse> result = callback.result();
            ((OptionalSubject)Truth.assertWithMessage((String)"RPC should succeed").about(OptionalSubject.optionals()).that(result)).isPresent();
            Truth.assertThat((String)result.get().getErrorMessage()).startsWith(text);
            done.release();
        }
        catch (Throwable t) {
            exceptions.add(t);
        }
    }

    @Test
    public void testAppError() throws Exception {
        AppErrorEvaluationRuntimeServer runtimeServer = new AppErrorEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<RuntimePb.UPResponse> callback = new TestCallback<RuntimePb.UPResponse>();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest("hello");
        evaluationRuntimeClient.handleRequest(clientContext, request, callback);
        Optional<RuntimePb.UPResponse> result = callback.result();
        ((OptionalSubject)Truth.assertWithMessage((String)"RPC should fail").about(OptionalSubject.optionals()).that(result)).isEmpty();
        Truth.assertThat((Integer)clientContext.getApplicationError()).isEqualTo((Object)7);
        Truth.assertThat((String)clientContext.getErrorDetail()).isEqualTo((Object)"oh noes!");
    }

    @Test
    public void testStopServer() throws Exception {
        TestEvaluationRuntimeServer runtimeServer = new TestEvaluationRuntimeServer();
        CloneControllerServerInterface controllerServer = AbstractRpcCompatibilityTest.implementAsUnsupported(CloneControllerServerInterface.class);
        this.getServerPlugin().startServer((EvaluationRuntimeServerInterface)runtimeServer, controllerServer);
        ServerWatcher serverWatcher = new ServerWatcher(this.getServerPlugin());
        serverWatcher.start();
        Truth.assertThat((Integer)runtimeServer.handleRequestCount.get()).isEqualTo((Object)0);
        ClientInterfaces.EvaluationRuntimeClient evaluationRuntimeClient = this.newEvaluationRuntimeClient();
        TestCallback<RuntimePb.UPResponse> callback = new TestCallback<RuntimePb.UPResponse>();
        AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
        RuntimePb.UPRequest request = AbstractRpcCompatibilityTest.makeUPRequest("hello");
        evaluationRuntimeClient.handleRequest(clientContext, request, callback);
        Optional<RuntimePb.UPResponse> result = callback.result();
        ((OptionalSubject)Truth.assertWithMessage((String)"RPC should succeed").about(OptionalSubject.optionals()).that(result)).isPresent();
        Truth.assertThat((String)result.get().getErrorMessage()).startsWith("hello/");
        Truth.assertThat((Integer)runtimeServer.handleRequestCount.get()).isEqualTo((Object)1);
        Truth.assertThat((Boolean)serverWatcher.isAlive()).isTrue();
        Truth.assertThat((Boolean)this.getServerPlugin().serverStarted()).isTrue();
        this.getServerPlugin().stopServer();
        serverWatcher.join(1000L);
        Truth.assertThat((Boolean)serverWatcher.isAlive()).isFalse();
        Truth.assertThat((Boolean)this.getServerPlugin().serverStarted()).isFalse();
        AnyRpcClientContext clientContext2 = this.rpcClientContextFactory.newClientContext();
        TestCallback<RuntimePb.UPResponse> callback2 = new TestCallback<RuntimePb.UPResponse>();
        evaluationRuntimeClient.handleRequest(clientContext2, request, callback2);
        Thread.sleep(1000L);
        Truth.assertWithMessage((String)"Server should not handle requests").that(Integer.valueOf(runtimeServer.handleRequestCount.get())).isEqualTo((Object)1);
        callback2.assertFailureOrNoResult();
    }

    @Test
    public void testAllServerMethods() throws Exception {
        EvaluationRuntimeServerInterface evaluationRuntimeServer = (EvaluationRuntimeServerInterface)Mockito.mock(EvaluationRuntimeServerInterface.class);
        CloneControllerServerInterface cloneControllerServer = (CloneControllerServerInterface)Mockito.mock(CloneControllerServerInterface.class);
        AnyRpcPlugin serverPlugin = this.getServerPlugin();
        serverPlugin.startServer(evaluationRuntimeServer, cloneControllerServer);
        this.testServerMethods(EvaluationRuntimeServerInterface.class, evaluationRuntimeServer, this.newEvaluationRuntimeClient());
        this.testServerMethods(CloneControllerServerInterface.class, cloneControllerServer, this.newCloneControllerClient());
    }

    private <T> void testServerMethods(Class<T> serverInterface, T server, Object client) throws ReflectiveOperationException {
        for (Method serverMethod : serverInterface.getMethods()) {
            Class<? extends Message> requestType = AbstractRpcCompatibilityTest.getRequestTypeFromServerMethod(serverMethod);
            Method clientMethod = client.getClass().getMethod(serverMethod.getName(), AnyRpcClientContext.class, requestType, AnyRpcCallback.class);
            Class<? extends Message> responseType = AbstractRpcCompatibilityTest.getResponseTypeFromClientMethod(clientMethod);
            Message fakeRequest = AbstractRpcCompatibilityTest.getFakeMessage(requestType);
            Message fakeResponse = AbstractRpcCompatibilityTest.getFakeMessage(responseType);
            Mockito.when((Object)serverMethod.invoke(server, ArgumentMatchers.any(AnyRpcServerContext.class), ArgumentMatchers.eq((Object)fakeRequest))).thenAnswer(invocationOnMock -> {
                AnyRpcServerContext serverContext = (AnyRpcServerContext)invocationOnMock.getArguments()[0];
                serverContext.finishWithResponse((MessageLite)fakeResponse);
                return null;
            });
            AnyRpcClientContext clientContext = this.rpcClientContextFactory.newClientContext();
            TestCallback callback = new TestCallback();
            clientMethod.invoke(client, clientContext, fakeRequest, callback);
            Optional result = callback.result();
            Truth.assertWithMessage((String)clientMethod.getName()).that(result).isEqualTo(Optional.of(fakeResponse));
            Object serverVerify = Mockito.verify(server);
            serverMethod.invoke(serverVerify, ArgumentMatchers.any(AnyRpcServerContext.class), ArgumentMatchers.eq((Object)fakeRequest));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{server});
        }
    }

    private static Class<? extends Message> getRequestTypeFromServerMethod(Method serverMethod) {
        Object[] parameterTypes = serverMethod.getParameterTypes();
        Truth.assertThat((Object[])parameterTypes).hasLength(2);
        Truth.assertThat((Class)parameterTypes[0]).isEqualTo(AnyRpcServerContext.class);
        Truth.assertThat((Class)parameterTypes[1]).isAssignableTo(Message.class);
        Object requestType = parameterTypes[1];
        return requestType;
    }

    private static Class<? extends Message> getResponseTypeFromClientMethod(Method clientMethod) {
        Class<?>[] parameterTypes = clientMethod.getParameterTypes();
        Truth.assertThat(parameterTypes[2]).isEqualTo(AnyRpcCallback.class);
        ParameterizedType anyRpcCallbackType = (ParameterizedType)clientMethod.getGenericParameterTypes()[2];
        Class typeArgument = (Class)anyRpcCallbackType.getActualTypeArguments()[0];
        Truth.assertThat((Class)typeArgument).isAssignableTo(Message.class);
        Class responseType = typeArgument;
        return responseType;
    }

    private static <T extends Message> T getFakeMessage(Class<T> messageType) {
        Message message = (Message)FAKE_MESSAGES.getInstance(messageType);
        Truth.assertWithMessage((String)("Expected fake message for " + messageType.getName())).that((Object)message).isNotNull();
        Truth.assertWithMessage((String)(messageType.getName() + " " + message.getInitializationErrorString())).that(Boolean.valueOf(message.isInitialized())).isTrue();
        return (T)message;
    }

    private static <T> T implementAsUnsupported(Class<T> interfaceToImplement) {
        InvocationHandler unsupportedInvocationHandler = (proxy, method, args) -> {
            throw new UnsupportedOperationException(method.getName());
        };
        return (T)Reflection.newProxy(interfaceToImplement, (InvocationHandler)unsupportedInvocationHandler);
    }

    private static RuntimePb.UPRequest makeUPRequest(String appId) {
        AppinfoPb.Handler handler = AppinfoPb.Handler.newBuilder().setPath("foo").build();
        return RuntimePb.UPRequest.newBuilder().setAppId(appId).setVersionId("world").setNickname("foo").setSecurityTicket("bar").setHandler(handler).build();
    }

    private static AppinfoPb.AppInfo makeAppInfo() {
        return AppinfoPb.AppInfo.newBuilder().setAppId("foo").build();
    }

    private static ClonePb.PerformanceData makePerformanceData() {
        return ClonePb.PerformanceData.newBuilder().addEntries(ClonePb.PerformanceData.Entry.newBuilder().setPayload(ByteString.copyFrom((String)"payload", (Charset)StandardCharsets.UTF_8))).build();
    }

    private static ClonePb.CloudDebuggerBreakpoints makeCloudDebuggerBreakpoints() {
        return ClonePb.CloudDebuggerBreakpoints.newBuilder().addBreakpointData(ByteString.copyFrom((String)"breakpoint", (Charset)StandardCharsets.UTF_8)).build();
    }

    private String createRandomString(int size) {
        Random random = new Random();
        byte[] bytes = new byte[size];
        for (int i = 0; i < size; ++i) {
            bytes[i] = (byte)(random.nextInt(95) + 32);
        }
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    private static class ServerWatcher
    extends Thread {
        private final AnyRpcPlugin rpcPlugin;

        ServerWatcher(AnyRpcPlugin rpcPlugin) {
            this.rpcPlugin = rpcPlugin;
        }

        @Override
        public void run() {
            this.rpcPlugin.blockUntilShutdown();
        }
    }

    private static class AppErrorEvaluationRuntimeServer
    extends TestEvaluationRuntimeServer {
        private AppErrorEvaluationRuntimeServer() {
        }

        @Override
        public void handleRequest(AnyRpcServerContext ctx, RuntimePb.UPRequest req) {
            ctx.finishWithAppError(7, "oh noes!");
        }
    }

    class TestCallback<T extends MessageLite>
    implements AnyRpcCallback<T> {
        private final BlockingQueue<Optional<T>> resultQueue = new ArrayBlockingQueue<Optional<T>>(1);

        TestCallback() {
        }

        Optional<T> result() {
            try {
                Optional<T> result = this.resultQueue.poll(5L, TimeUnit.SECONDS);
                if (result == null) {
                    Assert.fail((String)"Timeout waiting for RPC result");
                }
                return result;
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
        }

        void assertFailureOrNoResult() {
            Optional result = (Optional)this.resultQueue.poll();
            if (result != null) {
                Truth8.assertThat((Optional)result).isEmpty();
            }
        }

        private void resultIs(Optional<T> result) {
            try {
                this.resultQueue.offer(result, 5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                ((GoogleLogger.Api)((GoogleLogger.Api)logger.atSevere()).withCause((Throwable)e)).log("Interrupted while sending result %s", result);
                AbstractRpcCompatibilityTest.this.asynchronousFailures.add("Interrupted while sending result " + result);
            }
        }

        public void success(T response) {
            this.resultIs(Optional.of(response));
        }

        public void failure() {
            this.resultIs(Optional.empty());
        }
    }

    private static class TestEvaluationRuntimeServer
    implements EvaluationRuntimeServerInterface {
        final AtomicInteger handleRequestCount = new AtomicInteger();
        final Semaphore addAppVersionReceived = new Semaphore(0);
        AtomicLong latestGlobalId = new AtomicLong();

        private TestEvaluationRuntimeServer() {
        }

        public void handleRequest(AnyRpcServerContext ctx, RuntimePb.UPRequest req) {
            this.latestGlobalId.set(ctx.getGlobalId());
            this.handleRequestCount.getAndIncrement();
            String appId = req.getAppId();
            RuntimePb.UPResponse resp = RuntimePb.UPResponse.newBuilder().setError(0).setErrorMessage(appId + "/" + ctx.getTimeRemaining().getSeconds() + "/" + TestEvaluationRuntimeServer.timeRemainingInAnotherThread(ctx).getSeconds()).build();
            ctx.finishWithResponse((MessageLite)resp);
        }

        private static Duration timeRemainingInAnotherThread(AnyRpcServerContext ctx) {
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Callable<Duration> getTimeRemaining = () -> ((AnyRpcServerContext)ctx).getTimeRemaining();
            try {
                Duration duration = executor.submit(getTimeRemaining).get();
                return duration;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                executor.shutdown();
            }
        }

        public void addAppVersion(AnyRpcServerContext ctx, AppinfoPb.AppInfo req) {
            this.addAppVersionReceived.release();
        }

        public void deleteAppVersion(AnyRpcServerContext ctx, AppinfoPb.AppInfo req) {
            throw new UnsupportedOperationException("deleteAppVersion");
        }

        long getLatestGlobalId() {
            return this.latestGlobalId.get();
        }
    }

    static abstract class ClockHandler {
        final Clock clock;

        ClockHandler(Clock clock) {
            this.clock = clock;
        }

        long getMillis() {
            return this.clock.millis();
        }

        abstract void advanceClock();

        abstract void assertStartTime(long var1, long var3);
    }
}

