/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.anyrpc;

import com.google.apphosting.base.protos.CloneControllerGrpc;
import com.google.apphosting.base.protos.EvaluationRuntimeGrpc;
import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.anyrpc.CloneControllerServerInterface;
import com.google.apphosting.runtime.anyrpc.EvaluationRuntimeServerInterface;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.truth.Expect;
import com.google.common.truth.Truth;
import io.grpc.stub.StreamObserver;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConsistentInterfaceTest {
    @Rule
    public final Expect expect = Expect.create();

    @Test
    public void testEvaluationRuntime() {
        ConsistentInterfaceTest.check(EvaluationRuntimeGrpc.EvaluationRuntimeImplBase.class, EvaluationRuntimeServerInterface.class);
    }

    @Test
    public void testCloneController() {
        ConsistentInterfaceTest.check(CloneControllerGrpc.CloneControllerImplBase.class, CloneControllerServerInterface.class);
    }

    private static void check(Class<?> gRpcClass, Class<?> anyRpcInterface) {
        Truth.assertThat((Boolean)anyRpcInterface.isInterface()).isTrue();
        ImmutableSortedMap gRpcMethods = (ImmutableSortedMap)Arrays.stream(gRpcClass.getMethods()).filter(m -> m.getParameterTypes().length == 2 && m.getParameterTypes()[1] == StreamObserver.class).collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), Method::getName, m -> m.getParameterTypes()[0]));
        ImmutableSortedMap anyRpcMethods = (ImmutableSortedMap)Arrays.stream(anyRpcInterface.getMethods()).filter(m -> m.getParameterTypes().length == 2 && m.getParameterTypes()[0] == AnyRpcServerContext.class).collect(ImmutableSortedMap.toImmutableSortedMap(Comparator.naturalOrder(), Method::getName, m -> m.getParameterTypes()[1]));
        Truth.assertThat((Map)anyRpcMethods).isNotEmpty();
        Truth.assertThat((Map)anyRpcMethods).isEqualTo((Object)gRpcMethods);
    }
}

