/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.anyrpc;

import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.base.protos.CloneControllerGrpc;
import com.google.apphosting.base.protos.ClonePb;
import com.google.apphosting.base.protos.EmptyMessage;
import com.google.apphosting.base.protos.EvaluationRuntimeGrpc;
import com.google.apphosting.base.protos.ModelClonePb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.runtime.anyrpc.AnyRpcCallback;
import com.google.apphosting.runtime.anyrpc.AnyRpcClientContext;
import com.google.apphosting.runtime.anyrpc.ClientInterfaces;
import com.google.apphosting.runtime.grpc.CallbackStreamObserver;
import com.google.apphosting.runtime.grpc.GrpcClientContext;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;

class GrpcClients {
    private GrpcClients() {
    }

    static class GrpcCloneControllerClient
    implements ClientInterfaces.CloneControllerClient {
        private static final EmptyMessage GRPC_EMPTY_MESSAGE = EmptyMessage.getDefaultInstance();
        private final Channel channel;

        GrpcCloneControllerClient(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void waitForSandbox(AnyRpcClientContext ctx, EmptyMessage req, AnyRpcCallback<EmptyMessage> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, CloneControllerGrpc.getWaitForSandboxMethod(), (Object)GRPC_EMPTY_MESSAGE, (StreamObserver)streamObserver);
        }

        @Override
        public void applyCloneSettings(AnyRpcClientContext ctx, ClonePb.CloneSettings req, AnyRpcCallback<EmptyMessage> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, CloneControllerGrpc.getApplyCloneSettingsMethod(), (Object)req, (StreamObserver)streamObserver);
        }

        @Override
        public void sendDeadline(AnyRpcClientContext ctx, ModelClonePb.DeadlineInfo req, AnyRpcCallback<EmptyMessage> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, CloneControllerGrpc.getSendDeadlineMethod(), (Object)req, (StreamObserver)streamObserver);
        }

        @Override
        public void getPerformanceData(AnyRpcClientContext ctx, ModelClonePb.PerformanceDataRequest req, AnyRpcCallback<ClonePb.PerformanceData> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, CloneControllerGrpc.getGetPerformanceDataMethod(), (Object)req, (StreamObserver)streamObserver);
        }

        @Override
        public void updateActiveBreakpoints(AnyRpcClientContext ctx, ClonePb.CloudDebuggerBreakpoints req, AnyRpcCallback<ClonePb.CloudDebuggerBreakpoints> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, CloneControllerGrpc.getUpdateActiveBreakpointsMethod(), (Object)req, (StreamObserver)streamObserver);
        }

        @Override
        public void getDebuggeeInfo(AnyRpcClientContext ctx, ClonePb.DebuggeeInfoRequest req, AnyRpcCallback<ClonePb.DebuggeeInfoResponse> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, CloneControllerGrpc.getGetDebuggeeInfoMethod(), (Object)req, (StreamObserver)streamObserver);
        }
    }

    static class GrpcEvaluationRuntimeClient
    implements ClientInterfaces.EvaluationRuntimeClient {
        private final Channel channel;

        GrpcEvaluationRuntimeClient(Channel channel) {
            this.channel = channel;
        }

        @Override
        public void handleRequest(AnyRpcClientContext ctx, RuntimePb.UPRequest req, AnyRpcCallback<RuntimePb.UPResponse> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, EvaluationRuntimeGrpc.getHandleRequestMethod(), (Object)req, (StreamObserver)streamObserver);
        }

        @Override
        public void addAppVersion(AnyRpcClientContext ctx, AppinfoPb.AppInfo req, AnyRpcCallback<EmptyMessage> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, EvaluationRuntimeGrpc.getAddAppVersionMethod(), (Object)req, (StreamObserver)streamObserver);
        }

        @Override
        public void deleteAppVersion(AnyRpcClientContext ctx, AppinfoPb.AppInfo req, AnyRpcCallback<EmptyMessage> callback) {
            GrpcClientContext grpcContext = (GrpcClientContext)ctx;
            CallbackStreamObserver streamObserver = CallbackStreamObserver.of((GrpcClientContext)grpcContext, callback);
            grpcContext.call(this.channel, EvaluationRuntimeGrpc.getDeleteAppVersionMethod(), (Object)req, (StreamObserver)streamObserver);
        }
    }
}

