/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.anyrpc;

import com.google.apphosting.runtime.anyrpc.AbstractRpcCompatibilityTest;
import com.google.apphosting.runtime.anyrpc.AnyRpcClientContextFactory;
import com.google.apphosting.runtime.anyrpc.AnyRpcPlugin;
import com.google.apphosting.runtime.anyrpc.ClientInterfaces;
import com.google.apphosting.runtime.anyrpc.GrpcClients;
import com.google.apphosting.runtime.grpc.GrpcClientContext;
import com.google.apphosting.runtime.grpc.GrpcPlugin;
import com.google.apphosting.testing.PortPicker;
import com.google.common.truth.Truth;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.MockitoAnnotations;

@RunWith(value=JUnit4.class)
public class GrpcTest
extends AbstractRpcCompatibilityTest {
    private static Logger grpcManagedChannelLogger;
    private static Logger grpcDnsNameResolverLogger;
    private GrpcPlugin rpcPlugin;

    @BeforeClass
    public static void beforeClass() {
        grpcManagedChannelLogger = Logger.getLogger("io.grpc.internal.ManagedChannelOrphanWrapper");
        grpcManagedChannelLogger.setLevel(Level.OFF);
        grpcDnsNameResolverLogger = Logger.getLogger("io.grpc.internal.DnsNameResolver");
        grpcDnsNameResolverLogger.setLevel(Level.OFF);
    }

    @Override
    AnyRpcPlugin getClientPlugin() {
        return this.rpcPlugin;
    }

    @Override
    AnyRpcPlugin getServerPlugin() {
        return this.rpcPlugin;
    }

    @Override
    int getPacketSize() {
        return 65536;
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        MockitoAnnotations.initMocks((Object)this);
        this.rpcPlugin = new GrpcPlugin();
        int serverPort = PortPicker.create().pickUnusedPort();
        this.rpcPlugin.initialize(serverPort);
    }

    @Override
    AnyRpcClientContextFactory newRpcClientContextFactory() {
        return () -> new GrpcClientContext(this.getClockHandler().clock);
    }

    @Override
    ClientInterfaces.EvaluationRuntimeClient newEvaluationRuntimeClient() {
        int serverPort = this.rpcPlugin.getServerPort();
        ManagedChannel channel = NettyChannelBuilder.forAddress((String)"localhost", (int)serverPort).negotiationType(NegotiationType.PLAINTEXT).build();
        return new GrpcClients.GrpcEvaluationRuntimeClient((Channel)channel);
    }

    @Override
    ClientInterfaces.CloneControllerClient newCloneControllerClient() {
        int serverPort = this.rpcPlugin.getServerPort();
        ManagedChannel channel = NettyChannelBuilder.forAddress((String)"localhost", (int)serverPort).negotiationType(NegotiationType.PLAINTEXT).build();
        return new GrpcClients.GrpcCloneControllerClient((Channel)channel);
    }

    @Override
    AbstractRpcCompatibilityTest.ClockHandler getClockHandler() {
        return new GrpcClockHandler(new FakeClock());
    }

    private static class FakeClock
    extends Clock {
        private final AtomicLong nowMillis = new AtomicLong(1000000000L);

        private FakeClock() {
        }

        @Override
        public Instant instant() {
            return Instant.ofEpochMilli(this.nowMillis.get());
        }

        void incrementTime(long millis) {
            this.nowMillis.addAndGet(millis);
        }

        @Override
        public ZoneId getZone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Clock withZone(ZoneId zone) {
            throw new UnsupportedOperationException();
        }
    }

    private static class GrpcClockHandler
    extends AbstractRpcCompatibilityTest.ClockHandler {
        GrpcClockHandler(Clock clock) {
            super(clock);
        }

        @Override
        void advanceClock() {
            ((FakeClock)this.clock).incrementTime(1000L);
        }

        @Override
        void assertStartTime(long expectedStartTime, long reportedStartTime) {
            Truth.assertThat((Long)reportedStartTime).isEqualTo((Object)expectedStartTime);
        }
    }
}

