/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.TraceWriter;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.apphosting.runtime.grpc.FakeApiProxyImplFactory;
import com.google.apphosting.runtime.http.FakeHttpApiHost;
import com.google.apphosting.runtime.http.HttpApiHostClient;
import com.google.apphosting.testing.PortPicker;
import com.google.common.base.Ascii;
import com.google.common.base.Splitter;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ApiHostSuspendResumeTest {
    private static final ImmutableList<String> PROC_SELF_NET_TCP = ImmutableList.of((Object)"/proc/self/net/tcp", (Object)"/proc/self/net/tcp6");
    private static final ImmutableSet<String> LOCAL_ADDRESSES = ImmutableSet.of((Object)"0100007F", (Object)"0000000000000000FFFF00000100007F", (Object)ApiHostSuspendResumeTest.localHexAddress(), (Object)String.format("0000000000000000FFFF0000%s", ApiHostSuspendResumeTest.localHexAddress()), (Object)ApiHostSuspendResumeTest.middleEndianHexAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}));

    @Test
    public void suspendResume() throws IOException, InterruptedException {
        if (StandardSystemProperty.FILE_SEPARATOR.value().equals("\\") || Ascii.toLowerCase((String)StandardSystemProperty.OS_NAME.value()).startsWith("mac os x")) {
            return;
        }
        int port = PortPicker.create().pickUnusedPort();
        FakeHttpApiHost fakeHttpApiHost = FakeHttpApiHost.create(port, new EchoHandler());
        try {
            this.doSuspendResume(fakeHttpApiHost, port);
        }
        finally {
            fakeHttpApiHost.stop();
        }
    }

    private void doSuspendResume(FakeHttpApiHost fakeHttpApiHost, int port) throws IOException {
        URL url = fakeHttpApiHost.getUrl();
        HttpApiHostClient apiHostClient = HttpApiHostClient.create((String)url.toString(), (HttpApiHostClient.Config)HttpApiHostClient.Config.builder().build());
        Truth.assertThat(this.connectionsTo(port)).isEmpty();
        ApiProxyImpl apiProxyImpl = FakeApiProxyImplFactory.newApiProxyImpl((APIHostClientInterface)apiHostClient);
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        byte[] requestPayload = new byte[]{1, 2, 3, 4};
        byte[] responsePayload = apiProxyImpl.makeSyncCall(environment, "echo", "Echo", requestPayload);
        Truth.assertThat((byte[])responsePayload).isEqualTo((Object)requestPayload);
        Truth.assertThat(this.connectionsTo(port)).isNotEmpty();
        apiHostClient.disable();
        Truth.assertThat(this.connectionsTo(port)).isEmpty();
        Assert.assertThrows(ApiProxy.CancelledException.class, () -> apiProxyImpl.makeSyncCall(environment, "echo", "Echo", requestPayload));
        apiHostClient.enable();
        responsePayload = apiProxyImpl.makeSyncCall(environment, "echo", "Echo", requestPayload);
        Truth.assertThat((byte[])responsePayload).isEqualTo((Object)requestPayload);
    }

    private ImmutableList<String> connectionsTo(int port) throws IOException {
        String colonPort = Ascii.toUpperCase((String)String.format(":%04x", port));
        ImmutableList.Builder connections = ImmutableList.builder();
        for (String tcp : PROC_SELF_NET_TCP) {
            Path path = Paths.get(tcp, new String[0]);
            for (String line : Files.readAllLines(path, StandardCharsets.US_ASCII)) {
                line = line.trim();
                List fields = Splitter.on((char)' ').splitToList((CharSequence)line);
                String remoteAddress = (String)fields.get(2);
                String state = (String)fields.get(3);
                if (!state.equals("01") || !remoteAddress.endsWith(colonPort)) continue;
                int lastColon = remoteAddress.lastIndexOf(58);
                Truth.assertThat((Integer)lastColon).isGreaterThan((Comparable)Integer.valueOf(0));
                String remoteIp = remoteAddress.substring(0, lastColon);
                if (!LOCAL_ADDRESSES.contains((Object)remoteIp)) continue;
                connections.add((Object)remoteIp);
            }
        }
        return connections.build();
    }

    private static String localHexAddress() {
        InetAddress local;
        try {
            local = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
        return ApiHostSuspendResumeTest.middleEndianHexAddress(local.getAddress());
    }

    private static String middleEndianHexAddress(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length; i += 4) {
            for (int j = 3; j >= 0; --j) {
                sb.append(Ascii.toUpperCase((String)String.format("%02x", bytes[i + j] & 0xFF)));
            }
        }
        return sb.toString();
    }

    private ApiProxyImpl.EnvironmentImpl newEnvironmentImpl(ApiProxyImpl apiProxyImpl) {
        Random random = new Random(1234L);
        byte[] traceId = new byte[18];
        random.nextBytes(traceId);
        CloudTraceContext cloudTraceContext = new CloudTraceContext(traceId, random.nextLong(), 1L);
        return FakeApiProxyImplFactory.fakeEnvironment(apiProxyImpl, "tickety-boo", new TraceWriter(cloudTraceContext, new MutableUpResponse()));
    }

    private static class EchoHandler
    implements FakeHttpApiHost.ApiRequestHandler {
        private EchoHandler() {
        }

        @Override
        public RemoteApiPb.Response handle(RemoteApiPb.Request request) {
            if (!request.getServiceName().equals("echo") || !request.getMethod().equals("Echo")) {
                throw new IllegalArgumentException("Unexpected request: " + request);
            }
            return RemoteApiPb.Response.newBuilder().setResponse(request.getRequest()).build();
        }
    }
}

