/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.base.protos.api.RemoteApiPb;
import com.google.common.collect.ImmutableList;
import com.google.common.net.HostAndPort;
import com.google.common.primitives.Doubles;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class FakeHttpApiHost {
    static final String RPC_ENDPOINT_HEADER = "X-Google-RPC-Service-Endpoint";
    static final String RPC_ENDPOINT_VALUE = "app-engine-apis";
    static final String RPC_METHOD_HEADER = "X-Google-RPC-Service-Method";
    static final String RPC_METHOD_VALUE = "/VMRemoteAPI.CallRemoteAPI";
    static final String CONTENT_TYPE_HEADER = "Content-Type";
    static final String CONTENT_TYPE_VALUE = "application/octet-stream";
    static final String REQUEST_ENDPOINT = "/rpc_http";
    static final String DEADLINE_HEADER = "X-Google-RPC-Service-Deadline";
    static final ByteString BAD_RESPONSE = ByteString.copyFromUtf8((String)"_BAD");
    private final HttpServer httpApiHostServer;
    private final URL httpApiHostUrl;
    private final ReentrantLock freezeLock;

    private FakeHttpApiHost(HttpServer httpApiHostServer, URL httpApiHostUrl, ReentrantLock freezeLock) {
        this.httpApiHostServer = httpApiHostServer;
        this.httpApiHostUrl = httpApiHostUrl;
        this.freezeLock = freezeLock;
    }

    public static FakeHttpApiHost create(int port, ApiRequestHandler apiRequestHandler) throws IOException {
        InetSocketAddress socketAddress = new InetSocketAddress(port);
        HttpServer httpApiHostServer = HttpServer.create(socketAddress, 0);
        ReentrantLock freezeLock = new ReentrantLock();
        httpApiHostServer.createContext(REQUEST_ENDPOINT, new ApiHandler(freezeLock, apiRequestHandler));
        httpApiHostServer.start();
        String url = String.format("http://%s%s", HostAndPort.fromParts((String)socketAddress.getHostString(), (int)port), REQUEST_ENDPOINT);
        URL httpApiHostUrl = new URL(url);
        return new FakeHttpApiHost(httpApiHostServer, httpApiHostUrl, freezeLock);
    }

    URL getUrl() {
        return this.httpApiHostUrl;
    }

    public void stop() {
        this.httpApiHostServer.stop(0);
    }

    void freeze() {
        this.freezeLock.lock();
    }

    void unfreeze() {
        if (this.freezeLock.isHeldByCurrentThread()) {
            this.freezeLock.unlock();
        }
    }

    private static class ApiHandler
    implements HttpHandler {
        private final Lock freezeLock;
        private final ApiRequestHandler apiRequestHandler;

        ApiHandler(Lock freezeLock, ApiRequestHandler apiRequestHandler) {
            this.freezeLock = freezeLock;
            this.apiRequestHandler = apiRequestHandler;
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            this.freezeLock.lock();
            this.freezeLock.unlock();
            try {
                this.handleOrThrow(exchange);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                exchange.sendResponseHeaders(400, 0L);
                exchange.getResponseBody().close();
            }
        }

        private void handleOrThrow(HttpExchange exchange) throws IOException {
            RemoteApiPb.Request requestPb;
            if (!exchange.getRequestMethod().equals("POST")) {
                throw new IllegalArgumentException("HTTP method must be POST, not " + exchange.getRequestMethod());
            }
            Headers requestHeaders = exchange.getRequestHeaders();
            String endpoint = requestHeaders.getFirst(FakeHttpApiHost.RPC_ENDPOINT_HEADER);
            if (!FakeHttpApiHost.RPC_ENDPOINT_VALUE.equals(endpoint)) {
                throw new IllegalArgumentException("X-Google-RPC-Service-Endpoint should be app-engine-apis, not " + endpoint);
            }
            String method = requestHeaders.getFirst(FakeHttpApiHost.RPC_METHOD_HEADER);
            if (!FakeHttpApiHost.RPC_METHOD_VALUE.equals(method)) {
                throw new IllegalArgumentException("X-Google-RPC-Service-Method should be /VMRemoteAPI.CallRemoteAPI, not " + method);
            }
            String contentType = requestHeaders.getFirst(FakeHttpApiHost.CONTENT_TYPE_HEADER);
            if (!FakeHttpApiHost.CONTENT_TYPE_VALUE.equals(contentType)) {
                throw new IllegalArgumentException("Content-Type should be application/octet-stream, not " + contentType);
            }
            String deadlineString = requestHeaders.getFirst(FakeHttpApiHost.DEADLINE_HEADER);
            Double deadline = deadlineString == null ? null : Doubles.tryParse((String)deadlineString);
            if (deadline == null) {
                throw new IllegalArgumentException("Missing or incorrect deadline header in request: " + deadlineString);
            }
            try (InputStream in = exchange.getRequestBody();){
                requestPb = RemoteApiPb.Request.parseFrom((InputStream)in, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                if (in.read() >= 0) {
                    throw new IllegalArgumentException("Extra junk after request");
                }
            }
            Headers responseHeaders = exchange.getResponseHeaders();
            responseHeaders.put(FakeHttpApiHost.CONTENT_TYPE_HEADER, (List<String>)ImmutableList.of((Object)FakeHttpApiHost.CONTENT_TYPE_VALUE));
            RemoteApiPb.Response responsePb = this.handleRequestInThread(requestPb, deadline);
            if (responsePb.getResponse().equals((Object)BAD_RESPONSE)) {
                responseHeaders.put("Transfer-Encoding", (List<String>)ImmutableList.of((Object)"bad,chunked,badly"));
            }
            byte[] responseBytes = responsePb.toByteArray();
            exchange.sendResponseHeaders(200, responseBytes.length);
            try (OutputStream out = exchange.getResponseBody();){
                out.write(responseBytes);
            }
        }

        private RemoteApiPb.Response handleRequestInThread(RemoteApiPb.Request requestPb, double deadline) {
            RemoteApiPb.Response response;
            ArrayBlockingQueue responseQueue = new ArrayBlockingQueue(1);
            Runnable runnable = () -> {
                RemoteApiPb.Response response = this.apiRequestHandler.handle(requestPb);
                responseQueue.add(response);
            };
            Thread thread = new Thread(runnable);
            thread.start();
            long deadlineMs = (long)(deadline * 1000.0);
            try {
                response = (RemoteApiPb.Response)responseQueue.poll(deadlineMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                response = null;
            }
            if (response == null) {
                thread.interrupt();
                return this.timeoutResponse(deadline);
            }
            return response;
        }

        private RemoteApiPb.Response timeoutResponse(double deadline) {
            RemoteApiPb.RpcError rpcError = RemoteApiPb.RpcError.newBuilder().setCode(12).setDetail("Deadline of " + deadline + "s was exceeded").build();
            return RemoteApiPb.Response.newBuilder().setRpcError(rpcError).build();
        }
    }

    public static interface ApiRequestHandler {
        public RemoteApiPb.Response handle(RemoteApiPb.Request var1);
    }
}

