/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.base.protos.api.RemoteApiPb;
import com.google.apphosting.runtime.http.FakeHttpApiHost;
import com.google.apphosting.testing.PortPicker;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class HttpApiHostTest {
    private static final String ECHO_SERVICE = "echo";
    private static final String ECHO_METHOD = "Echo";
    private static FakeHttpApiHost fakeHttpApiHost;

    @BeforeClass
    public static void setUp() throws Exception {
        int port = PortPicker.create().pickUnusedPort();
        fakeHttpApiHost = FakeHttpApiHost.create(port, new EchoHandler());
    }

    @AfterClass
    public static void tearDown() {
        fakeHttpApiHost.stop();
    }

    @Test
    public void echo() throws Exception {
        RemoteApiPb.Response responsePb;
        ByteString payload = ByteString.copyFrom((byte[])new byte[]{1, 2, 3, 4});
        RemoteApiPb.Request requestPb = RemoteApiPb.Request.newBuilder().setServiceName(ECHO_SERVICE).setMethod(ECHO_METHOD).setRequest(payload).build();
        URL httpApiHostUrl = fakeHttpApiHost.getUrl();
        HttpURLConnection urlConnection = (HttpURLConnection)httpApiHostUrl.openConnection();
        urlConnection.setDoOutput(true);
        urlConnection.setRequestMethod("POST");
        urlConnection.setRequestProperty("X-Google-RPC-Service-Endpoint", "app-engine-apis");
        urlConnection.setRequestProperty("X-Google-RPC-Service-Method", "/VMRemoteAPI.CallRemoteAPI");
        urlConnection.setRequestProperty("Content-Type", "application/octet-stream");
        urlConnection.setRequestProperty("X-Google-RPC-Service-Deadline", "60.0");
        try (OutputStream out = urlConnection.getOutputStream();){
            requestPb.writeTo(out);
        }
        try (InputStream in = urlConnection.getInputStream();){
            responsePb = RemoteApiPb.Response.parseFrom((InputStream)in, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
            Truth.assertThat((Integer)in.read()).isLessThan((Comparable)Integer.valueOf(0));
        }
        Truth.assertThat((Iterable)responsePb.getResponse()).isEqualTo((Object)payload);
        Truth.assertThat((String)urlConnection.getHeaderField("Content-Type")).isEqualTo((Object)"application/octet-stream");
    }

    private static class EchoHandler
    implements FakeHttpApiHost.ApiRequestHandler {
        private EchoHandler() {
        }

        @Override
        public RemoteApiPb.Response handle(RemoteApiPb.Request request) {
            if (!request.getServiceName().equals(HttpApiHostTest.ECHO_SERVICE) || !request.getMethod().equals(HttpApiHostTest.ECHO_METHOD)) {
                throw new IllegalArgumentException("Unexpected request: " + request);
            }
            ByteString payload = request.getRequest();
            return RemoteApiPb.Response.newBuilder().setResponse(payload).build();
        }
    }
}

