/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.TraceWriter;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.apphosting.runtime.grpc.FakeApiProxyImplFactory;
import com.google.apphosting.runtime.http.FakeHttpApiHost;
import com.google.apphosting.runtime.http.HttpApiHostClient;
import com.google.apphosting.runtime.http.HttpApiProxyImplTestBase;
import com.google.apphosting.testing.PortPicker;
import com.google.common.truth.Truth;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HttpApiProxyImplTest
extends HttpApiProxyImplTestBase {
    @Test
    public void apiCall() {
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        byte[] requestPayload = new byte[]{1, 2, 3, 4};
        byte[] responsePayload = apiProxyImpl.makeSyncCall(environment, "echo", "Echo", requestPayload);
        Truth.assertThat((byte[])responsePayload).isEqualTo((Object)requestPayload);
    }

    @Test
    public void apiCallNoTraceWriter() {
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl noTraceEnvironment = FakeApiProxyImplFactory.fakeEnvironment(apiProxyImpl, "tickety-boo");
        byte[] requestPayload = new byte[]{1, 2, 3, 4};
        ApiProxy.ApplicationException exception = (ApiProxy.ApplicationException)Assert.assertThrows(ApiProxy.ApplicationException.class, () -> apiProxyImpl.makeSyncCall(noTraceEnvironment, "echo", "Swallow", requestPayload));
        Truth.assertThat((Integer)exception.getApplicationError()).isEqualTo((Object)23);
        Truth.assertThat((Throwable)exception).hasMessageThat().contains((CharSequence)"Wrong traceId");
    }

    @Test
    public void bigApiCall() {
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        byte[] requestPayload = new byte[0x3200000];
        Arrays.fill(requestPayload, (byte)99);
        byte[] responsePayload = apiProxyImpl.makeSyncCall(environment, "echo", "Echo", requestPayload);
        Truth.assertThat((byte[])responsePayload).isEqualTo((Object)requestPayload);
    }

    @Test
    public void badApiResponse() {
        Assume.assumeTrue((this.propertyToSet == null ? 1 : 0) != 0);
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        byte[] requestPayload = new byte[]{1, 2, 3, 4};
        RuntimeException exception = (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> apiProxyImpl.makeSyncCall(environment, "echo", "Bad", requestPayload));
        Truth.assertThat((Throwable)exception).hasCauseThat().hasCauseThat().hasCauseThat().hasMessageThat().isAnyOf((Object)"400: Bad Transfer-Encoding, chunked not last", (Object)"400: Transfer-Encoding and Content-Length", new Object[0]);
    }

    @Test
    public void overBigApiRequest() {
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        byte[] requestPayload = new byte[52438800];
        Assert.assertThrows(ApiProxy.RequestTooLargeException.class, () -> apiProxyImpl.makeSyncCall(environment, "echo", "Swallow", requestPayload));
    }

    @Test
    public void overBigApiResponse() {
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        byte[] requestPayload = String.valueOf(52438800).getBytes(StandardCharsets.UTF_8);
        Assert.assertThrows(ApiProxy.ResponseTooLargeException.class, () -> apiProxyImpl.makeSyncCall(environment, "echo", "Spew", requestPayload));
    }

    @Test
    public void errorApiCall() {
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        byte[] requestPayload = new byte[]{1, 2, 3, 4};
        ApiProxy.ApplicationException exception = (ApiProxy.ApplicationException)Assert.assertThrows(ApiProxy.ApplicationException.class, () -> apiProxyImpl.makeSyncCall(environment, "echo", "Error", requestPayload));
        Truth.assertThat((Integer)exception.getApplicationError()).isEqualTo((Object)23);
        Truth.assertThat((String)exception.getErrorDetail()).isEqualTo((Object)"something bad happened");
    }

    @Test
    public void timeout() {
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        environment.getAttributes().put("com.google.apphosting.api.ApiProxy.api_deadline_key", 1);
        byte[] requestPayload = "10".getBytes(StandardCharsets.UTF_8);
        Assert.assertThrows(ApiProxy.ApiDeadlineExceededException.class, () -> apiProxyImpl.makeSyncCall(environment, "echo", "Delay", requestPayload));
    }

    @Test
    public void serverUnresponsive() throws Exception {
        fakeHttpApiHost.freeze();
        ApiProxyImpl apiProxyImpl = this.newApiProxyImpl();
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(Double.valueOf(1.0));
        Future future = apiProxyImpl.makeAsyncCall(environment, "echo", "Swallow", new byte[0], apiConfig);
        ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get(10L, TimeUnit.SECONDS));
        Truth.assertThat((Throwable)exception).hasCauseThat().isInstanceOf(ApiProxy.ApiDeadlineExceededException.class);
    }

    @Test
    public void httpClientTimesOut() throws Exception {
        fakeHttpApiHost.freeze();
        HttpApiHostClient.Config limitedConfig = this.config.toBuilder().setExtraTimeoutSeconds(-9.0).build();
        HttpApiHostClient limitedApiHostClient = HttpApiHostClient.create((String)fakeHttpApiHost.getUrl().toString(), (HttpApiHostClient.Config)limitedConfig);
        ApiProxyImpl apiProxyImpl = FakeApiProxyImplFactory.newApiProxyImpl((APIHostClientInterface)limitedApiHostClient);
        ApiProxyImpl.EnvironmentImpl environment = this.newEnvironmentImpl(apiProxyImpl);
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        apiConfig.setDeadlineInSeconds(Double.valueOf(10.0));
        Future future = apiProxyImpl.makeAsyncCall(environment, "echo", "Swallow", new byte[0], apiConfig);
        ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, () -> future.get(20L, TimeUnit.SECONDS));
        Truth.assertThat((Throwable)exception).hasCauseThat().isInstanceOf(ApiProxy.ApiDeadlineExceededException.class);
    }

    @Test
    public void serverClose() throws Exception {
        int port = PortPicker.create().pickUnusedPort();
        FakeHttpApiHost closeableHttpApiHost = FakeHttpApiHost.create(port, new HttpApiProxyImplTestBase.EchoHandler());
        HttpApiHostClient apiHostClient = HttpApiHostClient.create((String)closeableHttpApiHost.getUrl().toString(), (HttpApiHostClient.Config)this.config);
        ApiProxyImpl apiProxyImpl = FakeApiProxyImplFactory.newApiProxyImpl((APIHostClientInterface)apiHostClient);
        ApiProxyImpl.EnvironmentImpl environment = FakeApiProxyImplFactory.fakeEnvironment(apiProxyImpl, "tickety-boo", new TraceWriter(cloudTraceContext, new MutableUpResponse()));
        Future success = apiProxyImpl.makeAsyncCall(environment, "echo", "Echo", new byte[1], new ApiProxy.ApiConfig());
        Truth.assertThat((byte[])((byte[])success.get())).hasLength(1);
        closeableHttpApiHost.stop();
        Future failure = apiProxyImpl.makeAsyncCall(environment, "echo", "Echo", new byte[1], new ApiProxy.ApiConfig());
        ExecutionException exception = (ExecutionException)Assert.assertThrows(ExecutionException.class, failure::get);
        Truth.assertThat((Throwable)exception).hasCauseThat().isInstanceOf(ApiProxy.UnknownException.class);
        Throwable cause = exception.getCause().getCause();
        Truth.assertThat((Throwable)cause).isNotNull();
    }
}

