/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.api.CloudTraceContext;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.base.protos.api.RemoteApiPb;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.TraceWriter;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.apphosting.runtime.grpc.FakeApiProxyImplFactory;
import com.google.apphosting.runtime.http.FakeHttpApiHost;
import com.google.apphosting.runtime.http.HttpApiHostClient;
import com.google.apphosting.testing.PortPicker;
import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runners.Parameterized;

public class HttpApiProxyImplTestBase {
    @Parameterized.Parameter(value=0)
    public HttpApiHostClient.Config config;
    @Parameterized.Parameter(value=1)
    public String propertyToSet;
    static final String API_DEADLINE_KEY = "com.google.apphosting.api.ApiProxy.api_deadline_key";
    static final String ECHO_SERVICE = "echo";
    static final String DELAY_METHOD = "Delay";
    static final String ECHO_METHOD = "Echo";
    static final String ERROR_METHOD = "Error";
    static final String SWALLOW_METHOD = "Swallow";
    static final String SPEW_METHOD = "Spew";
    static final String BAD_METHOD = "Bad";
    static final String FAKE_SECURITY_TICKET = "tickety-boo";
    static final int FAKE_APPLICATION_ERROR = 23;
    static final String FAKE_ERROR_DETAIL = "something bad happened";
    static FakeHttpApiHost fakeHttpApiHost;
    static CloudTraceContext cloudTraceContext;

    @Parameterized.Parameters(name="{0}:{1}")
    public static Collection<Object[]> parameters() {
        return ImmutableList.copyOf((Object[])new Object[][]{{HttpApiHostClient.Config.builder().build(), null}, {HttpApiHostClient.Config.builder().setIgnoreContentLength(true).build(), null}, {HttpApiHostClient.Config.builder().build(), "com.google.appengine.api.calls.using.jdk.client"}});
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
        int port = PortPicker.create().pickUnusedPort();
        Random random = new Random(1234L);
        byte[] traceId = new byte[18];
        random.nextBytes(traceId);
        cloudTraceContext = new CloudTraceContext(traceId, random.nextLong(), 1L);
        fakeHttpApiHost = FakeHttpApiHost.create(port, new EchoHandler());
    }

    @Before
    public void setUp() {
        if (this.propertyToSet != null) {
            System.setProperty(this.propertyToSet, "true");
        }
    }

    @After
    public void tearDown() {
        fakeHttpApiHost.unfreeze();
        if (this.propertyToSet != null) {
            System.clearProperty(this.propertyToSet);
        }
    }

    @AfterClass
    public static void tearDownClass() {
        fakeHttpApiHost.stop();
    }

    ApiProxyImpl newApiProxyImpl() {
        HttpApiHostClient apiHostClient = HttpApiHostClient.create((String)fakeHttpApiHost.getUrl().toString(), (HttpApiHostClient.Config)this.config);
        return FakeApiProxyImplFactory.newApiProxyImpl((APIHostClientInterface)apiHostClient);
    }

    ApiProxyImpl.EnvironmentImpl newEnvironmentImpl(ApiProxyImpl apiProxyImpl) {
        return FakeApiProxyImplFactory.fakeEnvironment(apiProxyImpl, FAKE_SECURITY_TICKET, new TraceWriter(cloudTraceContext, new MutableUpResponse()));
    }

    private static RemoteApiPb.Response.Builder newAppErrorResponse(int code, String detail) {
        RemoteApiPb.ApplicationError applicationError = RemoteApiPb.ApplicationError.newBuilder().setCode(code).setDetail(detail).build();
        return RemoteApiPb.Response.newBuilder().setApplicationError(applicationError);
    }

    static class EchoHandler
    implements FakeHttpApiHost.ApiRequestHandler {
        EchoHandler() {
        }

        @Override
        public RemoteApiPb.Response handle(RemoteApiPb.Request request) {
            if (!request.getServiceName().equals(HttpApiProxyImplTestBase.ECHO_SERVICE)) {
                throw new IllegalArgumentException("Unexpected request: " + request);
            }
            if (!request.getRequestId().equals(HttpApiProxyImplTestBase.FAKE_SECURITY_TICKET)) {
                throw new IllegalArgumentException("Wrong security ticket: '" + request.getRequestId() + "'");
            }
            TracePb.TraceContextProto.Builder traceContext = TracePb.TraceContextProto.newBuilder();
            try {
                traceContext.mergeFrom(request.getTraceContext(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
            }
            catch (InvalidProtocolBufferException e) {
                throw new AssertionError((Object)e);
            }
            if (!traceContext.getTraceId().equals((Object)ByteString.copyFrom((byte[])cloudTraceContext.getTraceId()))) {
                return HttpApiProxyImplTestBase.newAppErrorResponse(23, String.format("Wrong traceId: '%s'", traceContext.getTraceId())).build();
            }
            if ((long)traceContext.getTraceMask() != cloudTraceContext.getTraceMask()) {
                return HttpApiProxyImplTestBase.newAppErrorResponse(23, String.format("Wrong traceMask: '%s'", traceContext.getTraceMask())).build();
            }
            RemoteApiPb.Response.Builder response = RemoteApiPb.Response.newBuilder();
            ByteString payload = request.getRequest();
            switch (request.getMethod()) {
                case "Delay": {
                    String delayString = payload.toStringUtf8();
                    double delay = Double.parseDouble(delayString);
                    long delayMs = (long)(delay * 1000.0);
                    try {
                        Thread.sleep(delayMs);
                        break;
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "Echo": {
                    response.setResponse(payload);
                    break;
                }
                case "Error": {
                    response = HttpApiProxyImplTestBase.newAppErrorResponse(23, HttpApiProxyImplTestBase.FAKE_ERROR_DETAIL);
                    break;
                }
                case "Swallow": {
                    response.setResponse(ByteString.EMPTY);
                    break;
                }
                case "Spew": {
                    String spewSizeString = payload.toStringUtf8();
                    int spewSize = Integer.parseInt(spewSizeString);
                    byte[] spew = new byte[spewSize];
                    Arrays.fill(spew, (byte)88);
                    response.setResponse(ByteString.copyFrom((byte[])spew));
                    break;
                }
                case "Bad": {
                    response.setResponse(FakeHttpApiHost.BAD_RESPONSE);
                    break;
                }
                default: {
                    throw new AssertionError((Object)request.getMethod());
                }
            }
            return response.build();
        }
    }
}

