/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.http;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.ApiProxyImpl;
import com.google.apphosting.runtime.MutableUpResponse;
import com.google.apphosting.runtime.TraceWriter;
import com.google.apphosting.runtime.anyrpc.APIHostClientInterface;
import com.google.apphosting.runtime.grpc.FakeApiProxyImplFactory;
import com.google.apphosting.runtime.http.HttpApiHostClient;
import com.google.apphosting.runtime.http.HttpApiProxyImplTestBase;
import com.google.common.truth.Truth;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class InterruptedApiCallTest
extends HttpApiProxyImplTestBase {
    @Test
    public void interruptedApiCall() {
        AtomicBoolean stop = new AtomicBoolean();
        try {
            this.interruptedApiCall(stop);
        }
        finally {
            stop.set(true);
        }
    }

    private void interruptedApiCall(AtomicBoolean stop) {
        HttpApiHostClient.Config interruptibleConfig = this.config.toBuilder().setTreatClosedChannelAsCancellation(true).build();
        HttpApiHostClient apiHostClient = HttpApiHostClient.create((String)fakeHttpApiHost.getUrl().toString(), (HttpApiHostClient.Config)interruptibleConfig);
        ApiProxyImpl apiProxyImpl = FakeApiProxyImplFactory.newApiProxyImpl((APIHostClientInterface)apiHostClient);
        ApiProxyImpl.EnvironmentImpl environment = FakeApiProxyImplFactory.fakeEnvironment(apiProxyImpl, "tickety-boo", new TraceWriter(cloudTraceContext, new MutableUpResponse()));
        ApiClientTask apiClientTask = new ApiClientTask(stop, apiProxyImpl, environment);
        Thread apiClientThread = new Thread(apiClientTask);
        apiClientThread.start();
        for (int i = 0; i < 1000; ++i) {
            apiClientThread.interrupt();
            while (apiClientThread.isInterrupted()) {
                Thread.yield();
            }
        }
        Truth.assertThat((Throwable)apiClientTask.exceptionInMakeAsyncCall.get()).isNull();
        Truth.assertThat((Throwable)apiClientTask.exceptionInFutureGet.get()).isNull();
    }

    private static class ApiClientTask
    implements Runnable {
        final AtomicBoolean stop;
        final ApiProxyImpl apiProxyImpl;
        final ApiProxyImpl.EnvironmentImpl environment;
        final AtomicReference<Exception> exceptionInMakeAsyncCall = new AtomicReference();
        final AtomicReference<Exception> exceptionInFutureGet = new AtomicReference();

        ApiClientTask(AtomicBoolean stop, ApiProxyImpl apiProxyImpl, ApiProxyImpl.EnvironmentImpl environment) {
            this.stop = stop;
            this.apiProxyImpl = apiProxyImpl;
            this.environment = environment;
        }

        @Override
        public void run() {
            ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
            apiConfig.setDeadlineInSeconds(Double.valueOf(1.0));
            byte[] payload = new byte[100];
            new Random().nextBytes(payload);
            while (!this.stop.get() && this.exceptionInMakeAsyncCall.get() == null && this.exceptionInFutureGet.get() == null) {
                Future future;
                try {
                    future = this.apiProxyImpl.makeAsyncCall(this.environment, "echo", "Echo", payload, apiConfig);
                }
                catch (Exception e) {
                    this.exceptionInMakeAsyncCall.set(e);
                    break;
                }
                Thread.interrupted();
                try {
                    byte[] response = (byte[])future.get();
                    Truth.assertThat((byte[])response).isEqualTo((Object)payload);
                }
                catch (InterruptedException response) {
                }
                catch (ApiProxy.CancelledException response) {
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof ApiProxy.CancelledException) continue;
                    this.exceptionInFutureGet.set(e);
                }
                catch (Exception e) {
                    this.exceptionInFutureGet.set(e);
                }
            }
        }
    }
}

