/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.appengine.tools.development.resource.ResourceExtractor;
import com.google.apphosting.runtime.jetty94.AppEngineWebAppContext;
import com.google.common.io.ByteStreams;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class AppEngineWebAppContextTest {
    private static final String PACKAGE_PATH = AppEngineWebAppContextTest.class.getPackage().getName().replace('.', '/');
    private static final String PROJECT_RESOURCE_NAME = String.format("%s/mytestproject", PACKAGE_PATH);
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private Path expandedAppDir;
    private Path zippedAppDir;

    @Before
    public void setUp() throws Exception {
        Path projPath = Paths.get(this.temporaryFolder.newFolder(PROJECT_RESOURCE_NAME).getPath(), new String[0]);
        this.expandedAppDir = projPath.resolve("100.mydeployment");
        ResourceExtractor.toFile((String)PROJECT_RESOURCE_NAME, (String)projPath.toString());
        this.zippedAppDir = projPath.resolveSibling("mytestproject.jar");
        try (FileOutputStream fos = new FileOutputStream(this.zippedAppDir.toFile());
             JarOutputStream jos = new JarOutputStream(fos);){
            this.addFileToJar(this.expandedAppDir, this.expandedAppDir, jos);
        }
    }

    private void addFileToJar(Path source, Path relativeTo, JarOutputStream jos) throws Exception {
        if (source.toFile().isDirectory()) {
            JarEntry entry = new JarEntry(relativeTo.relativize(source) + "/");
            jos.putNextEntry(entry);
            for (File f : source.toFile().listFiles()) {
                this.addFileToJar(f.toPath(), relativeTo, jos);
            }
            return;
        }
        JarEntry entry = new JarEntry(relativeTo.relativize(source).toString());
        jos.putNextEntry(entry);
        try (FileInputStream fis = new FileInputStream(source.toFile());){
            ByteStreams.copy((InputStream)fis, (OutputStream)jos);
            jos.closeEntry();
        }
    }

    @Test
    public void extractsWar() throws Exception {
        AppEngineWebAppContext context = new AppEngineWebAppContext(this.zippedAppDir.toFile(), "test server");
        Path extractedWarPath = Paths.get(context.getWar(), new String[0]);
        Truth.assertThat((Boolean)extractedWarPath.resolve("WEB-INF/appengine-generated/app.yaml").toFile().exists()).isTrue();
        Truth.assertThat((Comparable)context.getBaseResource().getURI()).isEqualTo((Object)extractedWarPath.toAbsolutePath().toUri());
        Truth.assertThat((Comparable)context.getTempDirectory()).isEqualTo((Object)extractedWarPath.toFile());
    }

    @Test
    public void acceptsUnpackedWar() throws Exception {
        AppEngineWebAppContext context = new AppEngineWebAppContext(this.expandedAppDir.toFile(), "test server");
        Truth.assertThat((Boolean)Paths.get(context.getWar(), new String[0]).resolve("WEB-INF/appengine-generated/app.yaml").toFile().exists()).isTrue();
        Truth.assertThat((Comparable)context.getBaseResource().getURI()).isEqualTo((Object)this.expandedAppDir.toAbsolutePath().toUri());
        Truth.assertThat((Comparable)context.getTempDirectory()).isEqualTo((Object)this.expandedAppDir.toFile());
    }

    @Test
    public void doesntExtractWar() throws Exception {
        AppEngineWebAppContext context = new AppEngineWebAppContext(this.zippedAppDir.toFile(), "test server", false);
        Truth.assertThat((String)context.getWar()).isEqualTo((Object)this.zippedAppDir.toString());
        Truth.assertThat((Object)context.getBaseResource()).isNull();
        Truth.assertThat((Comparable)context.getTempDirectory()).isNull();
    }
}

