/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.appengine.tools.development.resource.ResourceExtractor;
import com.google.apphosting.base.protos.AppinfoPb;
import com.google.apphosting.runtime.jetty94.AppInfoFactory;
import com.google.apphosting.utils.config.AppYaml;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableMap;
import com.google.common.truth.Truth;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class AppInfoFactoryTest {
    private static final String PACKAGE_PATH = AppInfoFactoryTest.class.getPackage().getName().replace('.', '/');
    private static final String PROJECT_RESOURCE_NAME = String.format("%s/mytestproject", PACKAGE_PATH);
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    private String appRoot;
    private String fixedAppDir;

    @Before
    public void setUp() throws IOException {
        Path projPath = Paths.get(this.temporaryFolder.newFolder(PROJECT_RESOURCE_NAME).getPath(), new String[0]);
        this.appRoot = projPath.getParent().toString();
        this.fixedAppDir = Paths.get(projPath.toString(), "100.mydeployment").toString();
        ResourceExtractor.toFile((String)PROJECT_RESOURCE_NAME, (String)projPath.toString());
    }

    @Test
    public void getGaeService_nonDefault() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_SERVICE", (Object)"mytestservice"));
        Truth.assertThat((String)factory.getGaeService()).isEqualTo((Object)"mytestservice");
    }

    @Test
    public void getGaeService_defaults() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of());
        Truth.assertThat((String)factory.getGaeService()).isEqualTo((Object)"default");
    }

    @Test
    public void getGaeVersion_nonDefaultWithDeploymentId() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_SERVICE", (Object)"mytestservice", (Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100"));
        Truth.assertThat((String)factory.getGaeVersion()).isEqualTo((Object)"mytestservice:100.mydeployment");
    }

    @Test
    public void getGaeVersion_defaultWithDeploymentId() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100"));
        Truth.assertThat((String)factory.getGaeVersion()).isEqualTo((Object)"100.mydeployment");
    }

    @Test
    public void getGaeVersion_defaultWithoutDeploymentId() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_VERSION", (Object)"100"));
        Truth.assertThat((String)factory.getGaeVersion()).isEqualTo((Object)"100");
    }

    @Test
    public void getGaeServiceVersion_withDeploymentId() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100"));
        Truth.assertThat((String)factory.getGaeVersion()).isEqualTo((Object)"100.mydeployment");
    }

    @Test
    public void getGaeServiceVersion_withoutDeploymentId() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_VERSION", (Object)"100"));
        Truth.assertThat((String)factory.getGaeVersion()).isEqualTo((Object)"100");
    }

    @Test
    public void getGaeApplication_nonDefault() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_APPLICATION", (Object)"s~myapp"));
        Truth.assertThat((String)factory.getGaeApplication()).isEqualTo((Object)"s~myapp");
    }

    @Test
    public void getGaeApplication_defaults() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of());
        Truth.assertThat((String)factory.getGaeApplication()).isEqualTo((Object)"s~testapp");
    }

    @Test
    public void getAppInfo_fixedApplicationPath() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_SERVICE", (Object)"mytestservice", (Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100", (Object)"GAE_APPLICATION", (Object)"s~myapp"));
        AppinfoPb.AppInfo appInfo = factory.getAppInfoFromFile(null, this.fixedAppDir);
        Truth.assertThat((String)appInfo.getAppId()).isEqualTo((Object)"s~myapp");
        Truth.assertThat((String)appInfo.getVersionId()).isEqualTo((Object)"mytestservice:100.mydeployment");
        Truth.assertThat((String)appInfo.getRuntimeId()).isEqualTo((Object)"java8");
        Truth.assertThat((String)appInfo.getApiVersion()).isEqualTo((Object)"200");
    }

    @Test
    public void getAppInfo_appRoot() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_SERVICE", (Object)"mytestservice", (Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100", (Object)"GAE_APPLICATION", (Object)"s~myapp", (Object)"GOOGLE_CLOUD_PROJECT", (Object)"mytestproject"));
        AppinfoPb.AppInfo appInfo = factory.getAppInfoFromFile(this.appRoot, null);
        Truth.assertThat((String)appInfo.getAppId()).isEqualTo((Object)"s~myapp");
        Truth.assertThat((String)appInfo.getVersionId()).isEqualTo((Object)"mytestservice:100.mydeployment");
        Truth.assertThat((String)appInfo.getRuntimeId()).isEqualTo((Object)"java8");
        Truth.assertThat((String)appInfo.getApiVersion()).isEqualTo((Object)"200");
    }

    @Test
    public void getAppInfo_noAppYaml() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_SERVICE", (Object)"mytestservice", (Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100", (Object)"GAE_APPLICATION", (Object)"s~myapp", (Object)"GOOGLE_CLOUD_PROJECT", (Object)"bogusproject"));
        AppinfoPb.AppInfo appInfo = factory.getAppInfoFromFile(null, StandardSystemProperty.USER_DIR.value());
        Truth.assertThat((String)appInfo.getAppId()).isEqualTo((Object)"s~myapp");
        Truth.assertThat((String)appInfo.getVersionId()).isEqualTo((Object)"mytestservice:100.mydeployment");
        Truth.assertThat((String)appInfo.getRuntimeId()).isEqualTo((Object)"java8");
        Truth.assertThat((String)appInfo.getApiVersion()).isEmpty();
    }

    @Test
    public void getAppInfo_noDirectory() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_SERVICE", (Object)"mytestservice", (Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100", (Object)"GAE_APPLICATION", (Object)"s~myapp", (Object)"GOOGLE_CLOUD_PROJECT", (Object)"bogusproject"));
        Assert.assertThrows(NoSuchFileException.class, () -> factory.getAppInfoFromFile(this.appRoot, null));
    }

    @Test
    public void getAppInfo_givenAppYaml() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_SERVICE", (Object)"mytestservice", (Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100", (Object)"GAE_APPLICATION", (Object)"s~myapp", (Object)"GOOGLE_CLOUD_PROJECT", (Object)"mytestproject"));
        File appYamlFile = new File(this.fixedAppDir + "/WEB-INF/appengine-generated/app.yaml");
        AppYaml appYaml = AppYaml.parse((Reader)new InputStreamReader((InputStream)new FileInputStream(appYamlFile), StandardCharsets.UTF_8));
        AppinfoPb.AppInfo appInfo = factory.getAppInfoFromAppYaml(appYaml);
        Truth.assertThat((String)appInfo.getAppId()).isEqualTo((Object)"s~myapp");
        Truth.assertThat((String)appInfo.getVersionId()).isEqualTo((Object)"mytestservice:100.mydeployment");
        Truth.assertThat((String)appInfo.getRuntimeId()).isEqualTo((Object)"java8");
        Truth.assertThat((String)appInfo.getApiVersion()).isEqualTo((Object)"200");
    }

    @Test
    public void getAppInfo_givenVersion() throws Exception {
        AppInfoFactory factory = new AppInfoFactory((Map)ImmutableMap.of((Object)"GAE_SERVICE", (Object)"mytestservice", (Object)"GAE_DEPLOYMENT_ID", (Object)"mydeployment", (Object)"GAE_VERSION", (Object)"100", (Object)"GAE_APPLICATION", (Object)"s~myapp", (Object)"GOOGLE_CLOUD_PROJECT", (Object)"mytestproject"));
        AppinfoPb.AppInfo appInfo = factory.getAppInfoWithApiVersion("my_api_version");
        Truth.assertThat((String)appInfo.getAppId()).isEqualTo((Object)"s~myapp");
        Truth.assertThat((String)appInfo.getVersionId()).isEqualTo((Object)"mytestservice:100.mydeployment");
        Truth.assertThat((String)appInfo.getRuntimeId()).isEqualTo((Object)"java8");
        Truth.assertThat((String)appInfo.getApiVersion()).isEqualTo((Object)"my_api_version");
    }
}

