/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.runtime.jetty94.CacheControlHeader;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class CacheControlHeaderTest {
    @Test
    public void fromExpirationTime_parsesCorrectlyFormattedExpirationTime() throws Exception {
        CacheControlHeader cacheControlHeader = CacheControlHeader.fromExpirationTime((String)"1d 2h 3m");
        Truth.assertThat((String)cacheControlHeader.getValue()).isEqualTo((Object)"public, max-age=93780");
    }

    @Test
    public void fromExpirationTime_usesDefaultMaxAgeForInvalidExpirationTime() throws Exception {
        CacheControlHeader cacheControlHeader = CacheControlHeader.fromExpirationTime((String)"asdf");
        Truth.assertThat((String)cacheControlHeader.getValue()).isEqualTo((Object)"public, max-age=600");
    }

    @Test
    public void fromExpirationTime_usesDefaultMaxAgeForEmptyExpirationTime() throws Exception {
        CacheControlHeader cacheControlHeader = CacheControlHeader.fromExpirationTime((String)"");
        Truth.assertThat((String)cacheControlHeader.getValue()).isEqualTo((Object)"public, max-age=600");
    }

    @Test
    public void fromExpirationTime_usesDefaultMaxAgeForIncorrectTimeUnits() throws Exception {
        CacheControlHeader cacheControlHeader = CacheControlHeader.fromExpirationTime((String)"3g");
        Truth.assertThat((String)cacheControlHeader.getValue()).isEqualTo((Object)"public, max-age=600");
    }
}

