/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.runtime.jetty94.FileSender;
import com.google.apphosting.utils.config.AppYaml;
import com.google.common.truth.Truth;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.util.resource.Resource;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public class FileSenderTest {
    private static final String FAKE_URL_PATH = "/fake_url";
    @Rule
    public final MockitoRule mocks = MockitoJUnit.rule();
    @Mock
    private Resource mockResource;
    @Mock
    private ServletContext mockServletContext;
    @Mock
    private HttpServletRequest mockRequest;
    @Mock
    private HttpServletResponse mockResponse;
    private AppYaml appYaml;
    private FileSender testInstance;

    @Before
    public void setUp() {
        this.appYaml = new AppYaml();
        this.testInstance = new FileSender(this.appYaml);
    }

    @Test
    public void shouldAddBasicHeaders_noAppYaml() throws Exception {
        Mockito.when((Object)this.mockResource.length()).thenReturn((Object)1L);
        Mockito.when((Object)this.mockServletContext.getMimeType((String)ArgumentMatchers.any())).thenReturn((Object)"fake_content_type");
        this.testInstance = new FileSender(null);
        this.testInstance.sendData(this.mockServletContext, this.mockResponse, false, this.mockResource, FAKE_URL_PATH);
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setContentType("fake_content_type");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setContentLength(1);
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader(HttpHeader.CACHE_CONTROL.asString(), "public, max-age=600");
        ((Resource)Mockito.verify((Object)this.mockResource, (VerificationMode)Mockito.times((int)1))).writeTo((OutputStream)ArgumentMatchers.any(), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)1L));
    }

    @Test
    public void shouldAddBasicHeaders_appYamlIncluded() throws Exception {
        AppYaml.Handler handler = new AppYaml.Handler();
        handler.setStatic_files("fake_static_files");
        handler.setUrl(FAKE_URL_PATH);
        handler.setExpiration("1d 2h 3m");
        HashMap<String, String> fakeHeaders = new HashMap<String, String>();
        fakeHeaders.put("fake_name", "fake_value");
        handler.setHttp_headers(fakeHeaders);
        this.appYaml.setHandlers(Arrays.asList(handler));
        Mockito.when((Object)this.mockResource.length()).thenReturn((Object)1L);
        this.testInstance.sendData(this.mockServletContext, this.mockResponse, false, this.mockResource, FAKE_URL_PATH);
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).setHeader(HttpHeader.CACHE_CONTROL.asString(), "public, max-age=93780");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse)).addHeader("fake_name", "fake_value");
        ((Resource)Mockito.verify((Object)this.mockResource, (VerificationMode)Mockito.times((int)1))).writeTo((OutputStream)ArgumentMatchers.any(), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)1L));
    }

    @Test
    public void shouldNotAddBasicHeaders_appYamlIncluded() throws Exception {
        AppYaml.Handler handler = new AppYaml.Handler();
        handler.setStatic_files("fake_static_files");
        handler.setUrl(FAKE_URL_PATH);
        handler.setExpiration("1d 2h 3m");
        HashMap<String, String> fakeHeaders = new HashMap<String, String>();
        fakeHeaders.put("fake_name", "fake_value");
        handler.setHttp_headers(fakeHeaders);
        this.appYaml.setHandlers(Arrays.asList(handler));
        Mockito.when((Object)this.mockResource.length()).thenReturn((Object)1L);
        this.testInstance.sendData(this.mockServletContext, this.mockResponse, false, this.mockResource, "/different_url_path");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).setHeader(HttpHeader.CACHE_CONTROL.asString(), "public, max-age=93780");
        ((HttpServletResponse)Mockito.verify((Object)this.mockResponse, (VerificationMode)Mockito.never())).addHeader("fake_name", "fake_value");
        ((Resource)Mockito.verify((Object)this.mockResource, (VerificationMode)Mockito.times((int)1))).writeTo((OutputStream)ArgumentMatchers.any(), ArgumentMatchers.eq((long)0L), ArgumentMatchers.eq((long)1L));
    }

    @Test
    public void checkIfUnmodified_requestMethodHead() throws Exception {
        Mockito.when((Object)this.mockRequest.getMethod()).thenReturn((Object)HttpMethod.HEAD.asString());
        Truth.assertThat((Boolean)this.testInstance.checkIfUnmodified(this.mockRequest, this.mockResponse, this.mockResource)).isFalse();
    }

    @Test
    public void checkIfUnmodified_validHeaders() throws Exception {
        Mockito.when((Object)this.mockRequest.getMethod()).thenReturn((Object)HttpMethod.GET.asString());
        Mockito.when((Object)this.mockRequest.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString())).thenReturn((Object)"Thu, 1 Jan 1970 00:00:00 GMT");
        Mockito.when((Object)this.mockRequest.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString())).thenReturn((Object)0L);
        Mockito.when((Object)this.mockRequest.getHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString())).thenReturn((Object)"Thu, 1 Jan 1970 00:00:01 GMT");
        Mockito.when((Object)this.mockRequest.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString())).thenReturn((Object)1000L);
        Mockito.when((Object)this.mockResource.lastModified()).thenReturn((Object)100L);
        Truth.assertThat((Boolean)this.testInstance.checkIfUnmodified(this.mockRequest, this.mockResponse, this.mockResource)).isFalse();
    }

    @Test
    public void checkIfUnmodified_headerModifedGreaterThanResource() throws Exception {
        Mockito.when((Object)this.mockRequest.getMethod()).thenReturn((Object)HttpMethod.GET.asString());
        Mockito.when((Object)this.mockRequest.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString())).thenReturn((Object)"Thu, 1 Jan 1970 00:00:01 GMT");
        Mockito.when((Object)this.mockRequest.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString())).thenReturn((Object)1000L);
        Mockito.when((Object)this.mockResource.lastModified()).thenReturn((Object)100L);
        Truth.assertThat((Boolean)this.testInstance.checkIfUnmodified(this.mockRequest, this.mockResponse, this.mockResource)).isTrue();
    }

    @Test
    public void checkIfUnmodified_headerUnmodifedLessThanResource() throws Exception {
        Mockito.when((Object)this.mockRequest.getMethod()).thenReturn((Object)HttpMethod.GET.asString());
        Mockito.when((Object)this.mockRequest.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString())).thenReturn((Object)"Thu, 1 Jan 1970 00:00:00 GMT");
        Mockito.when((Object)this.mockRequest.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString())).thenReturn((Object)0L);
        Mockito.when((Object)this.mockRequest.getHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString())).thenReturn((Object)"Thu, 1 Jan 1970 00:00:00 GMT");
        Mockito.when((Object)this.mockRequest.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString())).thenReturn((Object)0L);
        Mockito.when((Object)this.mockResource.lastModified()).thenReturn((Object)100L);
        Truth.assertThat((Boolean)this.testInstance.checkIfUnmodified(this.mockRequest, this.mockResponse, this.mockResource)).isTrue();
    }
}

