/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.jetty94;

import com.google.apphosting.base.protos.HttpPb;
import com.google.apphosting.base.protos.RuntimePb;
import com.google.apphosting.base.protos.TraceId;
import com.google.apphosting.base.protos.TracePb;
import com.google.apphosting.runtime.jetty94.AppInfoFactory;
import com.google.apphosting.runtime.jetty94.UPRequestTranslator;
import com.google.common.base.Ascii;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public final class UPRequestTranslatorTest {
    private static final String X_APPENGINE_HTTPS = "X-AppEngine-Https";
    private static final String X_APPENGINE_USER_IP = "X-AppEngine-User-IP";
    private static final String X_APPENGINE_USER_EMAIL = "X-AppEngine-User-Email";
    private static final String X_APPENGINE_AUTH_DOMAIN = "X-AppEngine-Auth-Domain";
    private static final String X_APPENGINE_USER_ID = "X-AppEngine-User-Id";
    private static final String X_APPENGINE_USER_NICKNAME = "X-AppEngine-User-Nickname";
    private static final String X_APPENGINE_USER_ORGANIZATION = "X-AppEngine-User-Organization";
    private static final String X_APPENGINE_USER_IS_ADMIN = "X-AppEngine-User-Is-Admin";
    private static final String X_APPENGINE_TRUSTED_IP_REQUEST = "X-AppEngine-Trusted-IP-Request";
    private static final String X_APPENGINE_LOAS_PEER_USERNAME = "X-AppEngine-LOAS-Peer-Username";
    private static final String X_APPENGINE_GAIA_ID = "X-AppEngine-Gaia-Id";
    private static final String X_APPENGINE_GAIA_AUTHUSER = "X-AppEngine-Gaia-Authuser";
    private static final String X_APPENGINE_GAIA_SESSION = "X-AppEngine-Gaia-Session";
    private static final String X_APPENGINE_APPSERVER_DATACENTER = "X-AppEngine-Appserver-Datacenter";
    private static final String X_APPENGINE_APPSERVER_TASK_BNS = "X-AppEngine-Appserver-Task-Bns";
    private static final String X_APPENGINE_DEFAULT_VERSION_HOSTNAME = "X-AppEngine-Default-Version-Hostname";
    private static final String X_APPENGINE_REQUEST_LOG_ID = "X-AppEngine-Request-Log-Id";
    private static final String X_APPENGINE_QUEUENAME = "X-AppEngine-QueueName";
    private static final String X_GOOGLE_INTERNAL_SKIPADMINCHECK = "X-Google-Internal-SkipAdminCheck";
    private static final String X_CLOUD_TRACE_CONTEXT = "X-Cloud-Trace-Context";
    private static final String X_APPENGINE_TIMEOUT_MS = "X-AppEngine-Timeout-Ms";
    UPRequestTranslator translator;
    private static final ImmutableMap<String, String> BASE_APPENGINE_HEADERS = ImmutableMap.builder().put((Object)"X-AppEngine-User-Nickname", (Object)"anickname").put((Object)"X-AppEngine-User-IP", (Object)"auserip").put((Object)"X-AppEngine-User-Email", (Object)"ausermail").put((Object)"X-AppEngine-Auth-Domain", (Object)"aauthdomain").put((Object)"X-AppEngine-User-Id", (Object)"auserid").put((Object)"X-AppEngine-User-Organization", (Object)"auserorg").put((Object)"X-AppEngine-User-Is-Admin", (Object)"false").put((Object)"X-AppEngine-Trusted-IP-Request", (Object)"atrustedip").put((Object)"X-AppEngine-LOAS-Peer-Username", (Object)"aloasname").put((Object)"X-AppEngine-Gaia-Id", (Object)"3142406").put((Object)"X-AppEngine-Gaia-Authuser", (Object)"aauthuser").put((Object)"X-AppEngine-Gaia-Session", (Object)"agaiasession").put((Object)"X-AppEngine-Appserver-Datacenter", (Object)"adatacenter").put((Object)"X-AppEngine-Appserver-Task-Bns", (Object)"ataskbns").put((Object)"X-AppEngine-Https", (Object)"on").put((Object)"X-AppEngine-Default-Version-Hostname", (Object)"foo.appspot.com").put((Object)"X-AppEngine-Request-Log-Id", (Object)"logid").put((Object)"X-AppEngine-Timeout-Ms", (Object)"20000").buildOrThrow();

    @Before
    public void setUp() throws Exception {
        ImmutableMap fakeEnv = ImmutableMap.of((Object)"GAE_VERSION", (Object)"3.14", (Object)"GOOGLE_CLOUD_PROJECT", (Object)"mytestappid", (Object)"GAE_APPLICATION", (Object)"s~mytestappid", (Object)"GAE_SERVICE", (Object)"mytestservice");
        this.translator = new UPRequestTranslator(new AppInfoFactory((Map)fakeEnv), false, false);
    }

    @Test
    public void translateWithoutAppEngineHeaders() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/foo/bar?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.of((Object)"testheader", (Object)"testvalue"));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        HttpPb.HttpRequest httpRequestPb = translatedUpRequest.getRequest();
        Truth.assertThat((String)httpRequestPb.getHttpVersion()).isEqualTo((Object)"HTTP/1.0");
        Truth.assertThat((Boolean)httpRequestPb.getIsHttps()).isFalse();
        Truth.assertThat((String)httpRequestPb.getProtocol()).isEqualTo((Object)"GET");
        Truth.assertThat((String)httpRequestPb.getUserIp()).isEqualTo((Object)"127.0.0.1");
        Truth.assertThat((Boolean)httpRequestPb.getIsOffline()).isFalse();
        Truth.assertThat((String)httpRequestPb.getUrl()).isEqualTo((Object)"http://myapp.appspot.com:80/foo/bar?a=b");
        Truth.assertThat((Iterable)httpRequestPb.getHeadersList()).hasSize(2);
        for (HttpPb.ParsedHttpHeader header : httpRequestPb.getHeadersList()) {
            Truth.assertThat((String)header.getKey()).isAnyOf((Object)"testheader", (Object)"host", new Object[0]);
            Truth.assertThat((String)header.getValue()).isAnyOf((Object)"testvalue", (Object)"myapp.appspot.com", new Object[0]);
        }
        Truth.assertThat((String)translatedUpRequest.getAppId()).isEqualTo((Object)"s~mytestappid");
        Truth.assertThat((String)translatedUpRequest.getVersionId()).isEqualTo((Object)"mytestservice:3.14");
        Truth.assertThat((String)translatedUpRequest.getModuleId()).isEqualTo((Object)"mytestservice");
        Truth.assertThat((String)translatedUpRequest.getModuleVersionId()).isEqualTo((Object)"3.14");
        Truth.assertThat((String)translatedUpRequest.getSecurityTicket()).isEqualTo((Object)"secretkey");
        Truth.assertThat((String)translatedUpRequest.getNickname()).isEmpty();
        Truth.assertThat((String)translatedUpRequest.getEmail()).isEmpty();
        Truth.assertThat((String)translatedUpRequest.getUserOrganization()).isEmpty();
        Truth.assertThat((Boolean)translatedUpRequest.getIsAdmin()).isFalse();
        Truth.assertThat((String)translatedUpRequest.getPeerUsername()).isEmpty();
        Truth.assertThat((String)translatedUpRequest.getAppserverDatacenter()).isEmpty();
        Truth.assertThat((String)translatedUpRequest.getAppserverTaskBns()).isEmpty();
    }

    @Test
    public void translateWithAppEngineHeaders() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/foo/bar?a=b", "127.0.0.1", BASE_APPENGINE_HEADERS);
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        HttpPb.HttpRequest httpRequestPb = translatedUpRequest.getRequest();
        Truth.assertThat((String)httpRequestPb.getHttpVersion()).isEqualTo((Object)"HTTP/1.0");
        Truth.assertThat((Boolean)httpRequestPb.getIsHttps()).isTrue();
        Truth.assertThat((String)httpRequestPb.getProtocol()).isEqualTo((Object)"GET");
        Truth.assertThat((String)httpRequestPb.getUserIp()).isEqualTo((Object)"auserip");
        Truth.assertThat((String)httpRequestPb.getUrl()).isEqualTo((Object)"http://myapp.appspot.com:80/foo/bar?a=b");
        Truth.assertThat((Boolean)httpRequestPb.getTrusted()).isFalse();
        ImmutableSet appengineHeaderNames = (ImmutableSet)httpRequestPb.getHeadersList().stream().map(h -> Ascii.toLowerCase((String)h.getKey())).filter(h -> h.startsWith("x-appengine-")).collect(ImmutableSet.toImmutableSet());
        Truth.assertThat((Iterable)appengineHeaderNames).isEmpty();
        Truth.assertThat((String)translatedUpRequest.getModuleVersionId()).isEqualTo((Object)"3.14");
        Truth.assertThat((String)translatedUpRequest.getSecurityTicket()).isEqualTo((Object)"secretkey");
        Truth.assertThat((String)translatedUpRequest.getModuleId()).isEqualTo((Object)"mytestservice");
        Truth.assertThat((String)translatedUpRequest.getNickname()).isEqualTo((Object)"anickname");
        Truth.assertThat((String)translatedUpRequest.getEmail()).isEqualTo((Object)"ausermail");
        Truth.assertThat((String)translatedUpRequest.getUserOrganization()).isEqualTo((Object)"auserorg");
        Truth.assertThat((Boolean)translatedUpRequest.getIsAdmin()).isFalse();
        Truth.assertThat((String)translatedUpRequest.getPeerUsername()).isEqualTo((Object)"aloasname");
        Truth.assertThat((Long)translatedUpRequest.getGaiaId()).isEqualTo((Object)3142406);
        Truth.assertThat((String)translatedUpRequest.getAuthuser()).isEqualTo((Object)"aauthuser");
        Truth.assertThat((String)translatedUpRequest.getGaiaSession()).isEqualTo((Object)"agaiasession");
        Truth.assertThat((String)translatedUpRequest.getAppserverDatacenter()).isEqualTo((Object)"adatacenter");
        Truth.assertThat((String)translatedUpRequest.getAppserverTaskBns()).isEqualTo((Object)"ataskbns");
        Truth.assertThat((String)translatedUpRequest.getDefaultVersionHostname()).isEqualTo((Object)"foo.appspot.com");
        Truth.assertThat((String)translatedUpRequest.getRequestLogId()).isEqualTo((Object)"logid");
        Truth.assertThat((Boolean)translatedUpRequest.getRequest().getIsOffline()).isFalse();
        Truth.assertThat((Boolean)translatedUpRequest.getIsTrustedApp()).isTrue();
        ImmutableMap runtimeHeaders = (ImmutableMap)translatedUpRequest.getRuntimeHeadersList().stream().collect(ImmutableMap.toImmutableMap(h -> Ascii.toLowerCase((String)h.getKey()), h -> h.getValue()));
        Truth.assertThat((Map)runtimeHeaders).doesNotContainKey((Object)Ascii.toLowerCase((String)X_GOOGLE_INTERNAL_SKIPADMINCHECK));
        Truth.assertThat((Map)runtimeHeaders).containsEntry((Object)Ascii.toLowerCase((String)X_APPENGINE_TIMEOUT_MS), (Object)"20000");
    }

    @Test
    public void translateWithAppEngineHeadersIncludingQueueName() throws Exception {
        ImmutableMap appengineHeaders = ImmutableMap.builder().putAll(BASE_APPENGINE_HEADERS).put((Object)X_APPENGINE_QUEUENAME, (Object)"default").buildOrThrow();
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/foo/bar?a=b", "127.0.0.1", (ImmutableMap<String, String>)appengineHeaders);
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        HttpPb.HttpRequest httpRequestPb = translatedUpRequest.getRequest();
        ImmutableSet appengineHeaderNames = (ImmutableSet)httpRequestPb.getHeadersList().stream().map(h -> Ascii.toLowerCase((String)h.getKey())).filter(h -> h.startsWith("x-appengine-")).collect(ImmutableSet.toImmutableSet());
        Truth.assertThat((Iterable)appengineHeaderNames).containsExactly(new Object[]{Ascii.toLowerCase((String)X_APPENGINE_QUEUENAME)});
        ImmutableMap runtimeHeaders = (ImmutableMap)translatedUpRequest.getRuntimeHeadersList().stream().collect(ImmutableMap.toImmutableMap(h -> Ascii.toLowerCase((String)h.getKey()), h -> h.getValue()));
        Truth.assertThat((Map)runtimeHeaders).containsEntry((Object)Ascii.toLowerCase((String)X_GOOGLE_INTERNAL_SKIPADMINCHECK), (Object)"true");
        Truth.assertThat((Boolean)translatedUpRequest.getRequest().getIsOffline()).isTrue();
    }

    @Test
    public void translateWithAppEngineHeadersTrustedUser() throws Exception {
        HashMap<String, String> appengineHeaders = new HashMap<String, String>((Map<String, String>)BASE_APPENGINE_HEADERS);
        appengineHeaders.put(X_APPENGINE_TRUSTED_IP_REQUEST, "1");
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/foo/bar?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.copyOf(appengineHeaders));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        HttpPb.HttpRequest httpRequestPb = translatedUpRequest.getRequest();
        Truth.assertThat((String)httpRequestPb.getHttpVersion()).isEqualTo((Object)"HTTP/1.0");
        Truth.assertThat((Boolean)httpRequestPb.getIsHttps()).isTrue();
        Truth.assertThat((String)httpRequestPb.getProtocol()).isEqualTo((Object)"GET");
        Truth.assertThat((String)httpRequestPb.getUserIp()).isEqualTo((Object)"auserip");
        Truth.assertThat((String)httpRequestPb.getUrl()).isEqualTo((Object)"http://myapp.appspot.com:80/foo/bar?a=b");
        Truth.assertThat((Boolean)httpRequestPb.getTrusted()).isTrue();
        ImmutableSet appengineHeaderNames = (ImmutableSet)httpRequestPb.getHeadersList().stream().map(h -> Ascii.toLowerCase((String)h.getKey())).filter(h -> h.startsWith("x-appengine-")).collect(ImmutableSet.toImmutableSet());
        Truth.assertThat((Iterable)appengineHeaderNames).isEmpty();
        Truth.assertThat((String)translatedUpRequest.getModuleVersionId()).isEqualTo((Object)"3.14");
        Truth.assertThat((String)translatedUpRequest.getSecurityTicket()).isEqualTo((Object)"secretkey");
        Truth.assertThat((String)translatedUpRequest.getModuleId()).isEqualTo((Object)"mytestservice");
        Truth.assertThat((String)translatedUpRequest.getNickname()).isEqualTo((Object)"anickname");
        Truth.assertThat((String)translatedUpRequest.getEmail()).isEqualTo((Object)"ausermail");
        Truth.assertThat((String)translatedUpRequest.getUserOrganization()).isEqualTo((Object)"auserorg");
        Truth.assertThat((Boolean)translatedUpRequest.getIsAdmin()).isFalse();
        Truth.assertThat((String)translatedUpRequest.getPeerUsername()).isEqualTo((Object)"aloasname");
        Truth.assertThat((Long)translatedUpRequest.getGaiaId()).isEqualTo((Object)3142406);
        Truth.assertThat((String)translatedUpRequest.getAuthuser()).isEqualTo((Object)"aauthuser");
        Truth.assertThat((String)translatedUpRequest.getGaiaSession()).isEqualTo((Object)"agaiasession");
        Truth.assertThat((String)translatedUpRequest.getAppserverDatacenter()).isEqualTo((Object)"adatacenter");
        Truth.assertThat((String)translatedUpRequest.getAppserverTaskBns()).isEqualTo((Object)"ataskbns");
        Truth.assertThat((String)translatedUpRequest.getDefaultVersionHostname()).isEqualTo((Object)"foo.appspot.com");
        Truth.assertThat((String)translatedUpRequest.getRequestLogId()).isEqualTo((Object)"logid");
        Truth.assertThat((Iterable)translatedUpRequest.getRuntimeHeadersList().stream().map(h -> Ascii.toLowerCase((String)h.getKey())).collect(Collectors.toSet())).doesNotContain((Object)Ascii.toLowerCase((String)X_GOOGLE_INTERNAL_SKIPADMINCHECK));
        Truth.assertThat((Boolean)translatedUpRequest.getRequest().getIsOffline()).isFalse();
        Truth.assertThat((Boolean)translatedUpRequest.getIsTrustedApp()).isTrue();
    }

    @Test
    public void translateEmptyGaiaIdInAppEngineHeaders() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/foo/bar?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.of((Object)X_APPENGINE_GAIA_ID, (Object)""));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        Truth.assertThat((Long)translatedUpRequest.getGaiaId()).isEqualTo((Object)0);
    }

    @Test
    public void translateErrorPageFromHttpResponseError() throws Exception {
        HttpServletResponse httpResponse = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Mockito.when((Object)httpResponse.getOutputStream()).thenReturn((Object)UPRequestTranslatorTest.copyingOutputStream(out));
        UPRequestTranslator.populateErrorResponse((HttpServletResponse)httpResponse, (String)"Expected error during test.");
        ((HttpServletResponse)Mockito.verify((Object)httpResponse)).setStatus(500);
        ((HttpServletResponse)Mockito.verify((Object)httpResponse, (VerificationMode)Mockito.never())).addHeader((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        ((HttpServletResponse)Mockito.verify((Object)httpResponse, (VerificationMode)Mockito.never())).setHeader((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any());
        Truth.assertThat((String)out.toString("UTF-8")).isEqualTo((Object)"<html><head><title>Server Error</title></head><body>Expected error during test.</body></html>");
    }

    @Test
    public void translateSkipAdminCheckInAppEngineHeaders() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/foo/bar?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.of((Object)X_GOOGLE_INTERNAL_SKIPADMINCHECK, (Object)"true"));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        Truth.assertThat((Iterable)translatedUpRequest.getRuntimeHeadersList()).contains((Object)HttpPb.ParsedHttpHeader.newBuilder().setKey(X_GOOGLE_INTERNAL_SKIPADMINCHECK).setValue("true").build());
    }

    @Test
    public void translateQueueNameSetsSkipAdminCheckInAppEngineHeaders() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/foo/bar?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.of((Object)X_APPENGINE_QUEUENAME, (Object)"__cron__"));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        Truth.assertThat((Iterable)translatedUpRequest.getRuntimeHeadersList()).contains((Object)HttpPb.ParsedHttpHeader.newBuilder().setKey(X_GOOGLE_INTERNAL_SKIPADMINCHECK).setValue("true").build());
    }

    @Test
    public void translateBackgroundURISetsBackgroundRequestType() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/_ah/background?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.of((Object)X_APPENGINE_USER_IP, (Object)"0.1.0.3"));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        Truth.assertThat((Comparable)translatedUpRequest.getRequestType()).isEqualTo((Object)RuntimePb.UPRequest.RequestType.BACKGROUND);
    }

    @Test
    public void translateNonBackgroundURIDoesNotSetsBackgroundRequestType() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/foo/bar?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.of((Object)X_APPENGINE_USER_IP, (Object)"0.1.0.3"));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        Truth.assertThat((Comparable)translatedUpRequest.getRequestType()).isNotEqualTo((Object)RuntimePb.UPRequest.RequestType.BACKGROUND);
    }

    @Test
    public void translateRealIpDoesNotSetsBackgroundRequestType() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/_ah/background?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.of((Object)X_APPENGINE_USER_IP, (Object)"1.2.3.4"));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        Truth.assertThat((Comparable)translatedUpRequest.getRequestType()).isNotEqualTo((Object)RuntimePb.UPRequest.RequestType.BACKGROUND);
    }

    @Test
    public void translateCloudContextInAppEngineHeaders() throws Exception {
        HttpServletRequest httpRequest = UPRequestTranslatorTest.mockServletRequest("http://myapp.appspot.com:80/_ah/background?a=b", "127.0.0.1", (ImmutableMap<String, String>)ImmutableMap.of((Object)X_CLOUD_TRACE_CONTEXT, (Object)"000000000000007b00000000000001c8/789;o=1"));
        RuntimePb.UPRequest translatedUpRequest = this.translator.translateRequest(httpRequest);
        TracePb.TraceContextProto contextProto = translatedUpRequest.getTraceContext();
        TraceId.TraceIdProto traceIdProto = TraceId.TraceIdProto.parseFrom((ByteString)contextProto.getTraceId(), (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
        String traceIdString = String.format("%016x%016x", traceIdProto.getHi(), traceIdProto.getLo());
        Truth.assertThat((String)traceIdString).isEqualTo((Object)"000000000000007b00000000000001c8");
        Truth.assertThat((Long)contextProto.getSpanId()).isEqualTo((Object)789L);
        Truth.assertThat((Integer)contextProto.getTraceMask()).isEqualTo((Object)1L);
    }

    private static HttpServletRequest mockServletRequest(String url, String remoteAddr, ImmutableMap<String, String> userHeaders) {
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String urlWithoutQuery = uri.getScheme() + "://" + uri.getHost() + (uri.getPort() > 0 ? ":" + uri.getPort() : "") + Strings.nullToEmpty((String)uri.getPath());
        ImmutableMap headers = ImmutableMap.builder().putAll(userHeaders).put((Object)"host", (Object)uri.getHost()).buildOrThrow();
        HttpServletRequest httpRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpRequest.getProtocol()).thenReturn((Object)"HTTP/1.0");
        Mockito.when((Object)httpRequest.getMethod()).thenReturn((Object)"GET");
        Answer requestUrlAnswer = invocation -> new StringBuffer(urlWithoutQuery);
        Mockito.when((Object)httpRequest.getRequestURL()).thenAnswer(requestUrlAnswer);
        Mockito.when((Object)httpRequest.getRequestURI()).thenReturn((Object)uri.getPath());
        Mockito.when((Object)httpRequest.getQueryString()).thenReturn((Object)uri.getQuery());
        Mockito.when((Object)httpRequest.getRemoteAddr()).thenReturn((Object)remoteAddr);
        Mockito.when((Object)httpRequest.getHeaderNames()).thenAnswer(invocation -> Collections.enumeration(headers.keySet()));
        headers.forEach((k, v) -> Mockito.when((Object)httpRequest.getHeader(k)).thenReturn(v));
        try {
            Mockito.when((Object)httpRequest.getInputStream()).thenReturn((Object)UPRequestTranslatorTest.emptyInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return httpRequest;
    }

    private static ServletInputStream emptyInputStream() {
        return new ServletInputStream(){

            public int read() {
                return -1;
            }

            public void setReadListener(ReadListener listener) {
                throw new UnsupportedOperationException();
            }

            public boolean isReady() {
                return true;
            }

            public boolean isFinished() {
                return true;
            }
        };
    }

    private static ServletOutputStream copyingOutputStream(final OutputStream out) {
        return new ServletOutputStream(){

            public void write(int b) throws IOException {
                out.write(b);
            }

            public void setWriteListener(WriteListener listener) {
                throw new UnsupportedOperationException();
            }

            public boolean isReady() {
                return true;
            }
        };
    }
}

