/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.test;

import com.google.apphosting.runtime.anyrpc.AnyRpcServerContext;
import com.google.apphosting.runtime.test.AutoOneOf_MockAnyRpcServerContext_Result;
import com.google.apphosting.runtime.test.AutoValue_MockAnyRpcServerContext_Failure;
import com.google.auto.value.AutoOneOf;
import com.google.auto.value.AutoValue;
import com.google.common.truth.Truth;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.MessageLite;
import java.time.Duration;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class MockAnyRpcServerContext
implements AnyRpcServerContext {
    private static final Random random = new Random();
    private final Duration timeRemaining;
    private final long startTimeMillis = System.currentTimeMillis();
    private final long globalId = random.nextLong();
    private final SettableFuture<Result> resultFuture = SettableFuture.create();

    public MockAnyRpcServerContext(Duration timeRemaining) {
        this.timeRemaining = timeRemaining;
    }

    public void finishWithResponse(MessageLite response) {
        this.resultFuture.set((Object)Result.ofSuccess(response));
    }

    public void finishWithAppError(int appErrorCode, String errorDetail) {
        this.resultFuture.set((Object)Result.ofFailure(appErrorCode, errorDetail));
    }

    public Duration getTimeRemaining() {
        return this.timeRemaining;
    }

    public long getGlobalId() {
        return this.globalId;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public void waitForCompletion() {
        try {
            this.resultFuture.get(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    public MessageLite assertSuccess() {
        Result result;
        Truth.assertWithMessage((String)"RPC should have completed").that(Boolean.valueOf(this.resultFuture.isDone())).isTrue();
        try {
            result = (Result)this.resultFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError((Object)e);
        }
        switch (result.getKind()) {
            case SUCCESS: {
                return result.success();
            }
            case FAILURE: {
                throw new AssertionError(result.failure());
            }
        }
        throw new AssertionError((Object)"Mystery kind of Result");
    }

    public void assertAppError(int errorCode) {
        Result result;
        Truth.assertWithMessage((String)"RPC should have completed").that(Boolean.valueOf(this.resultFuture.isDone())).isTrue();
        try {
            result = (Result)this.resultFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError((Object)e);
        }
        switch (result.getKind()) {
            case SUCCESS: {
                throw new AssertionError((Object)("RPC succeeded but should not have: " + result.success()));
            }
            case FAILURE: {
                Truth.assertThat((Integer)result.failure().code()).isEqualTo((Object)errorCode);
            }
        }
    }

    @AutoOneOf(value=Kind.class)
    static abstract class Result {
        Result() {
        }

        abstract Kind getKind();

        abstract MessageLite success();

        abstract Failure failure();

        static Result ofSuccess(MessageLite message) {
            return AutoOneOf_MockAnyRpcServerContext_Result.success(message);
        }

        static Result ofFailure(int code, String message) {
            return AutoOneOf_MockAnyRpcServerContext_Result.failure(Failure.of(code, message));
        }

        static enum Kind {
            SUCCESS,
            FAILURE;

        }
    }

    @AutoValue
    static abstract class Failure {
        Failure() {
        }

        abstract int code();

        abstract String message();

        static Failure of(int code, String message) {
            return new AutoValue_MockAnyRpcServerContext_Failure(code, message);
        }
    }
}

