/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.AbstractIntervalTimer;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AbstractIntervalTimerTest {
    private long currentTime;
    private AbstractIntervalTimer timer;

    @Before
    public void setUp() {
        this.currentTime = 0L;
        this.timer = new AbstractIntervalTimer(){

            public long getCurrent() {
                return AbstractIntervalTimerTest.this.currentTime;
            }
        };
    }

    @Test
    public void testNotStarted() throws Exception {
        Truth.assertThat((Long)this.timer.getNanoseconds()).isEqualTo((Object)0L);
    }

    @Test
    public void testStartStop() throws Exception {
        this.timer.start();
        this.currentTime = 3L;
        this.timer.stop();
        Truth.assertThat((Long)this.timer.getNanoseconds()).isEqualTo((Object)3L);
    }

    @Test
    public void testStartedLate() throws Exception {
        this.currentTime = 5L;
        this.timer.start();
        this.currentTime = 6L;
        this.timer.stop();
        Truth.assertThat((Long)this.timer.getNanoseconds()).isEqualTo((Object)1L);
    }

    @Test
    public void testStillRunning() throws Exception {
        this.timer.start();
        this.currentTime = 2L;
        Truth.assertThat((Long)this.timer.getNanoseconds()).isEqualTo((Object)2L);
    }

    @Test
    public void testStartStopTwice() throws Exception {
        this.timer.start();
        this.currentTime = 3L;
        this.timer.stop();
        this.currentTime = 5L;
        this.timer.start();
        this.currentTime = 10L;
        this.timer.stop();
        Truth.assertThat((Long)this.timer.getNanoseconds()).isEqualTo((Object)8L);
    }
}

