/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.AbstractSharedTimerSet;
import com.google.apphosting.runtime.timer.Timer;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class AbstractSharedTimerSetTest {
    private long current1;
    private long current2;
    private AbstractSharedTimerSet set1;
    private AbstractSharedTimerSet set2;
    private Timer timer1a;
    private Timer timer1b;
    private Timer timer2a;

    @Before
    public void setUp() {
        this.current2 = 0L;
        this.current1 = 0L;
        this.set1 = new AbstractSharedTimerSet(){

            public long getCurrentShared() {
                return AbstractSharedTimerSetTest.this.current1;
            }

            public String getTitle() {
                return "set1";
            }
        };
        this.timer1a = this.set1.createTimer();
        this.timer1b = this.set1.createTimer();
        this.set2 = new AbstractSharedTimerSet(){

            public long getCurrentShared() {
                return AbstractSharedTimerSetTest.this.current2;
            }

            public String getTitle() {
                return "set2";
            }
        };
        this.timer2a = this.set2.createTimer();
    }

    @Test
    public void testNotStarted() throws Exception {
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)0L);
    }

    @Test
    public void testStartStop() throws Exception {
        this.timer1a.start();
        this.current1 = 5L;
        this.timer1a.stop();
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)5L);
    }

    @Test
    public void testStartStopTwo() throws Exception {
        this.timer1a.start();
        this.timer1b.start();
        this.current1 = 6L;
        this.timer1a.stop();
        this.timer1b.stop();
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)3L);
        Truth.assertThat((Long)this.timer1b.getNanoseconds()).isEqualTo((Object)3L);
    }

    @Test
    public void testInterleaved() throws Exception {
        this.current1 = 3L;
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)0L);
        Truth.assertThat((Long)this.timer1b.getNanoseconds()).isEqualTo((Object)0L);
        this.timer1a.start();
        this.current1 = 4L;
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)1L);
        Truth.assertThat((Long)this.timer1b.getNanoseconds()).isEqualTo((Object)0L);
        this.timer1b.start();
        this.current1 = 8L;
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)3L);
        Truth.assertThat((Long)this.timer1b.getNanoseconds()).isEqualTo((Object)2L);
        this.timer1b.stop();
        this.current1 = 10L;
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)5L);
        Truth.assertThat((Long)this.timer1b.getNanoseconds()).isEqualTo((Object)2L);
        this.timer1a.stop();
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)5L);
        Truth.assertThat((Long)this.timer1b.getNanoseconds()).isEqualTo((Object)2L);
    }

    @Test
    public void testStartStopTwoDifferentSets() throws Exception {
        this.timer1a.start();
        this.timer2a.start();
        this.current1 = 6L;
        this.current2 = 10L;
        this.timer1a.stop();
        this.timer2a.stop();
        Truth.assertThat((Long)this.timer1a.getNanoseconds()).isEqualTo((Object)6L);
        Truth.assertThat((Long)this.timer1b.getNanoseconds()).isEqualTo((Object)0L);
        Truth.assertThat((Long)this.timer2a.getNanoseconds()).isEqualTo((Object)10L);
    }
}

