/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.JmxCpuTimer;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JmxCpuTimerTest {
    private static final long MILLIS_TO_NANOS = 1000000L;
    private static final long TEST_TIME = 2000L;
    private static final double MAX_SLEEP_CPU_RATIO = 0.01;
    private static final double MIN_BUSY_CPU_RATIO = 0.1;

    @Test
    public void testAvailable() {
        Truth.assertThat((Boolean)JmxCpuTimer.isAvailable()).isTrue();
    }

    @Test
    public void testSleep() throws Exception {
        JmxCpuTimer cpuTimer = new JmxCpuTimer(Thread.currentThread());
        Truth.assertThat((Long)cpuTimer.getNanoseconds()).isEqualTo((Object)0L);
        cpuTimer.start();
        Thread.sleep(2000L);
        cpuTimer.stop();
        Truth.assertWithMessage((String)"Spent %s ns while sleeping.", (Object[])new Object[]{cpuTimer.getNanoseconds()}).that(Double.valueOf(cpuTimer.getNanoseconds())).isAtMost((Comparable)Double.valueOf(2.0E7));
    }

    @Test
    public void testBusyLoop() throws Exception {
        JmxCpuTimer cpuTimer = new JmxCpuTimer(Thread.currentThread());
        this.busyLoop(cpuTimer);
        Truth.assertWithMessage((String)"Only spent %s ns while looping.", (Object[])new Object[]{cpuTimer.getNanoseconds()}).that(Double.valueOf(cpuTimer.getNanoseconds())).isAtLeast((Comparable)Double.valueOf(2.0E8));
    }

    private void busyLoop(JmxCpuTimer timer) {
        long stop = System.nanoTime() + 2000000000L;
        timer.start();
        int pow = 2;
        while (System.nanoTime() < stop) {
            double d = Math.pow(Math.PI, pow++);
        }
        timer.stop();
    }
}

