/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.runtime.timer;

import com.google.apphosting.runtime.timer.JmxThreadGroupCpuTimer;
import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class JmxThreadGroupCpuTimerTest {
    private static final long MILLIS_TO_NANOS = 1000000L;
    private static final long TEST_TIME = 2000L;
    private static final double MAX_SLEEP_CPU_RATIO = 0.01;
    private static final double MIN_BUSY_CPU_RATIO = 0.1;
    private ThreadGroup threadGroup;

    @Before
    public void setUp() throws Exception {
        this.threadGroup = new ThreadGroup("test");
    }

    @Test
    public void testAvailable() {
        Truth.assertThat((Boolean)JmxThreadGroupCpuTimer.isAvailable()).isTrue();
    }

    @Test
    public void testSleep() throws Exception {
        JmxThreadGroupCpuTimer cpuTimer = new JmxThreadGroupCpuTimer(this.threadGroup);
        Truth.assertThat((Long)cpuTimer.getNanoseconds()).isEqualTo((Object)0L);
        cpuTimer.start();
        this.runAndWait(this.threadGroup, () -> {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            cpuTimer.update();
        });
        cpuTimer.stop();
        Truth.assertWithMessage((String)"Spent %s ns while sleeping.", (Object[])new Object[]{cpuTimer.getNanoseconds()}).that(Double.valueOf(cpuTimer.getNanoseconds())).isAtMost((Comparable)Double.valueOf(2.0E7));
    }

    @Test
    public void testBusyLoop() throws Exception {
        JmxThreadGroupCpuTimer cpuTimer = new JmxThreadGroupCpuTimer(this.threadGroup);
        cpuTimer.start();
        this.runAndWait(this.threadGroup, () -> {
            this.busyLoop();
            cpuTimer.update();
        });
        cpuTimer.stop();
        Truth.assertWithMessage((String)"Only spent %s ns while looping.", (Object[])new Object[]{cpuTimer.getNanoseconds()}).that(Double.valueOf(cpuTimer.getNanoseconds())).isAtLeast((Comparable)Double.valueOf(2.0E8));
    }

    private void busyLoop() {
        long stop = System.nanoTime() + 2000000000L;
        int pow = 2;
        while (System.nanoTime() < stop) {
            double d = Math.pow(Math.PI, pow++);
        }
    }

    private void runAndWait(ThreadGroup group, Runnable runnable) {
        Thread thread = new Thread(group, runnable);
        thread.start();
        try {
            thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

