/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.testing;

import com.google.common.reflect.ClassPath;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public final class SerialVersionVerifier {
    private final ClassLoader classLoader;
    private final Predicate<CharSequence> namePredicate;
    private final List<String> problems = new ArrayList<String>();
    private int matchCount = 0;

    private SerialVersionVerifier(ClassLoader classLoader, Predicate<CharSequence> namePredicate) {
        this.classLoader = classLoader;
        this.namePredicate = namePredicate;
    }

    public static void verify(ClassLoader classLoader, Predicate<CharSequence> namePredicate) {
        SerialVersionVerifier verifier = new SerialVersionVerifier(classLoader, namePredicate);
        try {
            verifier.verifyOrThrow();
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
        if (!verifier.problems.isEmpty()) {
            throw new AssertionError((Object)String.join((CharSequence)"\n", verifier.problems));
        }
        if (verifier.matchCount == 0) {
            throw new AssertionError((Object)"No classes matched the predicate");
        }
    }

    private void verifyOrThrow() throws Exception {
        ClassPath classPath = ClassPath.from((ClassLoader)this.classLoader);
        for (ClassPath.ClassInfo classInfo : classPath.getAllClasses()) {
            String className = classInfo.getName();
            if (!this.namePredicate.test(className)) continue;
            ++this.matchCount;
            try {
                Optional<String> problem = this.checkClass(className);
                if (!problem.isPresent()) continue;
                this.problems.add(problem.get());
            }
            catch (NoClassDefFoundError noClassDefFoundError) {}
        }
    }

    private Optional<String> checkClass(String className) throws ReflectiveOperationException {
        Class<?> c = Class.forName(className, false, this.classLoader);
        if (Modifier.isPublic(c.getModifiers()) && !Modifier.isAbstract(c.getModifiers()) && Serializable.class.isAssignableFrom(c) && !Enum.class.isAssignableFrom(c)) {
            try {
                Field serialVersionUID = c.getDeclaredField("serialVersionUID");
                if (!Modifier.isStatic(serialVersionUID.getModifiers())) {
                    return Optional.of("Field " + className + ".serialVersionUID is not static");
                }
                Class<?> type = serialVersionUID.getType();
                if (type != Long.TYPE) {
                    return Optional.of("Field " + className + ".serialVersionUID should have type long, not " + type);
                }
            }
            catch (NoSuchFieldException e) {
                return Optional.of("Public serializable class " + className + " does not have a serialVersionUID");
            }
        }
        return Optional.empty();
    }
}

