/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.cloud.Restorable;
import com.google.cloud.RestorableState;
import com.google.cloud.ServiceAccountSigner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;

public abstract class AuthCredentials
implements Restorable<AuthCredentials> {
    public abstract GoogleCredentials credentials();

    public static AuthCredentials createForAppEngine() {
        return AppEngineAuthCredentials.INSTANCE;
    }

    public static AuthCredentials createApplicationDefaults() throws IOException {
        GoogleCredentials credentials = GoogleCredentials.getApplicationDefault();
        if (credentials instanceof ServiceAccountCredentials) {
            ServiceAccountCredentials serviceAccountCredentials = (ServiceAccountCredentials)credentials;
            return new ServiceAccountAuthCredentials(serviceAccountCredentials);
        }
        return new ApplicationDefaultAuthCredentials(credentials);
    }

    public static ServiceAccountAuthCredentials createFor(String account, PrivateKey privateKey) {
        return new ServiceAccountAuthCredentials(account, privateKey);
    }

    public static AuthCredentials noAuth() {
        return NoAuthCredentials.INSTANCE;
    }

    public static ServiceAccountAuthCredentials createForJson(InputStream jsonCredentialStream) throws IOException {
        GoogleCredentials tempCredentials = GoogleCredentials.fromStream((InputStream)jsonCredentialStream);
        if (tempCredentials instanceof ServiceAccountCredentials) {
            ServiceAccountCredentials tempServiceAccountCredentials = (ServiceAccountCredentials)tempCredentials;
            return new ServiceAccountAuthCredentials(tempServiceAccountCredentials.getClientEmail(), tempServiceAccountCredentials.getPrivateKey());
        }
        throw new IOException("The given JSON Credentials Stream is not for a service account credential.");
    }

    public static class NoAuthCredentials
    extends AuthCredentials {
        private static final AuthCredentials INSTANCE = new NoAuthCredentials();
        private static final NoAuthCredentialsState STATE = new NoAuthCredentialsState();

        private NoAuthCredentials() {
        }

        @Override
        public GoogleCredentials credentials() {
            return null;
        }

        @Override
        public RestorableState<AuthCredentials> capture() {
            return STATE;
        }

        private static class NoAuthCredentialsState
        implements RestorableState<AuthCredentials>,
        Serializable {
            private static final long serialVersionUID = -4022100563954640465L;

            private NoAuthCredentialsState() {
            }

            @Override
            public AuthCredentials restore() {
                return INSTANCE;
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof NoAuthCredentialsState;
            }
        }
    }

    public static class ApplicationDefaultAuthCredentials
    extends AuthCredentials {
        private GoogleCredentials googleCredentials;
        private static final ApplicationDefaultAuthCredentialsState STATE = new ApplicationDefaultAuthCredentialsState();

        ApplicationDefaultAuthCredentials(GoogleCredentials credentials) {
            this.googleCredentials = credentials;
        }

        ApplicationDefaultAuthCredentials() throws IOException {
            this.googleCredentials = GoogleCredentials.getApplicationDefault();
        }

        @Override
        public GoogleCredentials credentials() {
            return this.googleCredentials;
        }

        @Override
        public RestorableState<AuthCredentials> capture() {
            return STATE;
        }

        private static class ApplicationDefaultAuthCredentialsState
        implements RestorableState<AuthCredentials>,
        Serializable {
            private static final long serialVersionUID = -8839085552021212257L;

            private ApplicationDefaultAuthCredentialsState() {
            }

            @Override
            public AuthCredentials restore() {
                try {
                    return new ApplicationDefaultAuthCredentials();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Could not restore " + ApplicationDefaultAuthCredentials.class.getSimpleName(), e);
                }
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof ApplicationDefaultAuthCredentialsState;
            }
        }
    }

    public static class ServiceAccountAuthCredentials
    extends AuthCredentials
    implements ServiceAccountSigner {
        private final ServiceAccountCredentials credentials;
        private final String account;
        private final PrivateKey privateKey;

        ServiceAccountAuthCredentials(String account, PrivateKey privateKey) {
            this(new ServiceAccountCredentials(null, account, privateKey, null, null));
        }

        ServiceAccountAuthCredentials(ServiceAccountCredentials credentials) {
            this.credentials = (ServiceAccountCredentials)Preconditions.checkNotNull((Object)credentials);
            this.account = (String)Preconditions.checkNotNull((Object)credentials.getClientEmail());
            this.privateKey = (PrivateKey)Preconditions.checkNotNull((Object)credentials.getPrivateKey());
        }

        public ServiceAccountCredentials credentials() {
            return this.credentials;
        }

        @Override
        public String account() {
            return this.account;
        }

        public PrivateKey privateKey() {
            return this.privateKey;
        }

        @Override
        public byte[] sign(byte[] toSign) {
            try {
                Signature signer = Signature.getInstance("SHA256withRSA");
                signer.initSign(this.privateKey());
                signer.update(toSign);
                return signer.sign();
            }
            catch (InvalidKeyException | NoSuchAlgorithmException | SignatureException ex) {
                throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", ex);
            }
        }

        @Override
        public RestorableState<AuthCredentials> capture() {
            return new ServiceAccountAuthCredentialsState(this.account, this.privateKey);
        }

        private static class ServiceAccountAuthCredentialsState
        implements RestorableState<AuthCredentials>,
        Serializable {
            private static final long serialVersionUID = -7302180782414633639L;
            private final String account;
            private final PrivateKey privateKey;

            private ServiceAccountAuthCredentialsState(String account, PrivateKey privateKey) {
                this.account = account;
                this.privateKey = privateKey;
            }

            @Override
            public AuthCredentials restore() {
                return new ServiceAccountAuthCredentials(this.account, this.privateKey);
            }

            public int hashCode() {
                return Objects.hash(this.account, this.privateKey);
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof ServiceAccountAuthCredentialsState)) {
                    return false;
                }
                ServiceAccountAuthCredentialsState other = (ServiceAccountAuthCredentialsState)obj;
                return Objects.equals(this.account, other.account) && Objects.equals(this.privateKey, other.privateKey);
            }
        }
    }

    public static class AppEngineAuthCredentials
    extends AuthCredentials
    implements ServiceAccountSigner {
        private static final AuthCredentials INSTANCE = new AppEngineAuthCredentials();
        private static final AppEngineAuthCredentialsState STATE = new AppEngineAuthCredentialsState();
        private AppEngineCredentials credentials;

        @Override
        public AppEngineCredentials credentials() {
            if (this.credentials == null) {
                this.credentials = new AppEngineCredentials();
            }
            return this.credentials;
        }

        @Override
        public RestorableState<AuthCredentials> capture() {
            return STATE;
        }

        @Override
        public String account() {
            return this.credentials().account();
        }

        @Override
        public byte[] sign(byte[] toSign) {
            return this.credentials().sign(toSign);
        }

        private static class AppEngineAuthCredentialsState
        implements RestorableState<AuthCredentials>,
        Serializable {
            private static final long serialVersionUID = 3558563960848658928L;

            private AppEngineAuthCredentialsState() {
            }

            @Override
            public AuthCredentials restore() {
                return INSTANCE;
            }

            public int hashCode() {
                return this.getClass().getName().hashCode();
            }

            public boolean equals(Object obj) {
                return obj instanceof AppEngineAuthCredentialsState;
            }
        }

        private static class AppEngineCredentials
        extends GoogleCredentials
        implements ServiceAccountSigner {
            private final Object appIdentityService;
            private final String account;
            private final Method getAccessToken;
            private final Method getAccessTokenResult;
            private final Method getExpirationTime;
            private final Method signForApp;
            private final Method getSignature;
            private final Collection<String> scopes;

            AppEngineCredentials() {
                try {
                    Class<?> factoryClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityServiceFactory");
                    Method method = factoryClass.getMethod("getAppIdentityService", new Class[0]);
                    this.appIdentityService = method.invoke(null, new Object[0]);
                    Class<?> serviceClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityService");
                    Class<?> tokenResultClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityService$GetAccessTokenResult");
                    this.getAccessTokenResult = serviceClass.getMethod("getAccessToken", Iterable.class);
                    this.getAccessToken = tokenResultClass.getMethod("getAccessToken", new Class[0]);
                    this.getExpirationTime = tokenResultClass.getMethod("getExpirationTime", new Class[0]);
                    this.account = (String)serviceClass.getMethod("getServiceAccountName", new Class[0]).invoke(this.appIdentityService, new Object[0]);
                    this.signForApp = serviceClass.getMethod("signForApp", byte[].class);
                    Class<?> signingResultClass = Class.forName("com.google.appengine.api.appidentity.AppIdentityService$SigningResult");
                    this.getSignature = signingResultClass.getMethod("getSignature", new Class[0]);
                    this.scopes = null;
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not create AppEngineCredentials.", e);
                }
            }

            AppEngineCredentials(Collection<String> scopes, AppEngineCredentials unscoped) {
                this.appIdentityService = unscoped.appIdentityService;
                this.getAccessToken = unscoped.getAccessToken;
                this.getAccessTokenResult = unscoped.getAccessTokenResult;
                this.getExpirationTime = unscoped.getExpirationTime;
                this.account = unscoped.account;
                this.signForApp = unscoped.signForApp;
                this.getSignature = unscoped.getSignature;
                this.scopes = scopes;
            }

            public AccessToken refreshAccessToken() throws IOException {
                if (this.createScopedRequired()) {
                    throw new IOException("AppEngineCredentials requires createScoped call before use.");
                }
                try {
                    Object accessTokenResult = this.getAccessTokenResult.invoke(this.appIdentityService, this.scopes);
                    String accessToken = (String)this.getAccessToken.invoke(accessTokenResult, new Object[0]);
                    Date expirationTime = (Date)this.getExpirationTime.invoke(accessTokenResult, new Object[0]);
                    return new AccessToken(accessToken, expirationTime);
                }
                catch (Exception e) {
                    throw new IOException("Could not get the access token.", e);
                }
            }

            public boolean createScopedRequired() {
                return this.scopes == null || this.scopes.isEmpty();
            }

            public GoogleCredentials createScoped(Collection<String> scopes) {
                return new AppEngineCredentials(scopes, this);
            }

            @Override
            public String account() {
                return this.account;
            }

            @Override
            public byte[] sign(byte[] toSign) {
                try {
                    Object signingResult = this.signForApp.invoke(this.appIdentityService, new Object[]{toSign});
                    return (byte[])this.getSignature.invoke(signingResult, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    throw new ServiceAccountSigner.SigningException("Failed to sign the provided bytes", ex);
                }
            }
        }
    }
}

