/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.cloud.RetryHelper;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class BaseServiceException
extends RuntimeException {
    private static final long serialVersionUID = 759921776378760835L;
    public static final int UNKNOWN_CODE = 0;
    private final int code;
    private final boolean retryable;
    private final String reason;
    private final boolean idempotent;
    private final String location;
    private final String debugInfo;

    public BaseServiceException(IOException exception, boolean idempotent) {
        super(BaseServiceException.message(exception), exception);
        int code = 0;
        String reason = null;
        String location = null;
        String debugInfo = null;
        if (exception instanceof GoogleJsonResponseException) {
            GoogleJsonError jsonError = ((GoogleJsonResponseException)exception).getDetails();
            if (jsonError != null) {
                Error error = BaseServiceException.error(jsonError);
                code = error.code;
                reason = error.reason;
                if (reason != null) {
                    GoogleJsonError.ErrorInfo errorInfo = (GoogleJsonError.ErrorInfo)jsonError.getErrors().get(0);
                    location = errorInfo.getLocation();
                    debugInfo = (String)errorInfo.get((Object)"debugInfo");
                }
            } else {
                code = ((GoogleJsonResponseException)exception).getStatusCode();
            }
        }
        this.code = code;
        this.retryable = idempotent && this.isRetryable(exception);
        this.reason = reason;
        this.idempotent = idempotent;
        this.location = location;
        this.debugInfo = debugInfo;
    }

    public BaseServiceException(GoogleJsonError error, boolean idempotent) {
        super(error.getMessage());
        this.code = error.getCode();
        this.reason = BaseServiceException.reason(error);
        this.idempotent = idempotent;
        this.retryable = idempotent && this.isRetryable(error);
        this.location = null;
        this.debugInfo = null;
    }

    public BaseServiceException(int code, String message, String reason, boolean idempotent) {
        this(code, message, reason, idempotent, null);
    }

    public BaseServiceException(int code, String message, String reason, boolean idempotent, Throwable cause) {
        super(message, cause);
        this.code = code;
        this.reason = reason;
        this.idempotent = idempotent;
        this.retryable = idempotent && new Error(code, reason).isRetryable(this.retryableErrors());
        this.location = null;
        this.debugInfo = null;
    }

    protected Set<Error> retryableErrors() {
        return Collections.emptySet();
    }

    protected boolean isRetryable(GoogleJsonError error) {
        return error != null && BaseServiceException.error(error).isRetryable(this.retryableErrors());
    }

    protected boolean isRetryable(IOException exception) {
        if (exception instanceof GoogleJsonResponseException) {
            return this.isRetryable(((GoogleJsonResponseException)exception).getDetails());
        }
        return exception instanceof SocketTimeoutException;
    }

    public int code() {
        return this.code;
    }

    public String reason() {
        return this.reason;
    }

    public boolean retryable() {
        return this.retryable;
    }

    public boolean idempotent() {
        return this.idempotent;
    }

    public String location() {
        return this.location;
    }

    protected String debugInfo() {
        return this.debugInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BaseServiceException)) {
            return false;
        }
        BaseServiceException other = (BaseServiceException)obj;
        return Objects.equals(this.getCause(), other.getCause()) && Objects.equals(this.getMessage(), other.getMessage()) && this.code == other.code && this.retryable == other.retryable && Objects.equals(this.reason, other.reason) && this.idempotent == other.idempotent && Objects.equals(this.location, other.location) && Objects.equals(this.debugInfo, other.debugInfo);
    }

    public int hashCode() {
        return Objects.hash(this.getCause(), this.getMessage(), this.code, this.retryable, this.reason, this.idempotent, this.location, this.debugInfo);
    }

    protected static String reason(GoogleJsonError error) {
        if (error.getErrors() != null && !error.getErrors().isEmpty()) {
            return ((GoogleJsonError.ErrorInfo)error.getErrors().get(0)).getReason();
        }
        return null;
    }

    protected static Error error(GoogleJsonError error) {
        return new Error(error.getCode(), BaseServiceException.reason(error));
    }

    protected static String message(IOException exception) {
        GoogleJsonError details;
        if (exception instanceof GoogleJsonResponseException && (details = ((GoogleJsonResponseException)exception).getDetails()) != null) {
            return details.getMessage();
        }
        return exception.getMessage();
    }

    protected static void translateAndPropagateIfPossible(RetryHelper.RetryHelperException ex) {
        if (ex.getCause() instanceof BaseServiceException) {
            throw (BaseServiceException)ex.getCause();
        }
        if (ex instanceof RetryHelper.RetryInterruptedException) {
            RetryHelper.RetryInterruptedException.propagate();
        }
    }

    protected static final class Error
    implements Serializable {
        private static final long serialVersionUID = -4019600198652965721L;
        private final Integer code;
        private final String reason;

        public Error(Integer code, String reason) {
            this.code = code;
            this.reason = reason;
        }

        public Integer code() {
            return this.code;
        }

        public String reason() {
            return this.reason;
        }

        boolean isRetryable(Set<Error> retryableErrors) {
            for (Error retryableError : retryableErrors) {
                if (retryableError.code() != null && !retryableError.code().equals(this.code()) || retryableError.reason() != null && !retryableError.reason().equals(this.reason())) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("code", (Object)this.code).add("reason", (Object)this.reason).toString();
        }

        public int hashCode() {
            return Objects.hash(this.code, this.reason);
        }
    }
}

