/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import com.google.cloud.Identity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class IamPolicy<R>
implements Serializable {
    private static final long serialVersionUID = 1114489978726897720L;
    private final Map<R, Set<Identity>> bindings;
    private final String etag;
    private final Integer version;

    protected IamPolicy(Builder<R, ? extends Builder<R, ?>> builder) {
        ImmutableMap.Builder bindingsBuilder = ImmutableMap.builder();
        for (Map.Entry binding : ((Builder)builder).bindings.entrySet()) {
            bindingsBuilder.put(binding.getKey(), (Object)ImmutableSet.copyOf((Collection)((Collection)binding.getValue())));
        }
        this.bindings = bindingsBuilder.build();
        this.etag = ((Builder)builder).etag;
        this.version = ((Builder)builder).version;
    }

    public abstract Builder<R, ? extends Builder<R, ?>> toBuilder();

    public Map<R, Set<Identity>> bindings() {
        return this.bindings;
    }

    public String etag() {
        return this.etag;
    }

    public Integer version() {
        return this.version;
    }

    public final int hashCode() {
        return Objects.hash(this.getClass(), this.bindings, this.etag, this.version);
    }

    public final boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        IamPolicy other = (IamPolicy)obj;
        return Objects.equals(this.bindings, other.bindings()) && Objects.equals(this.etag, other.etag()) && Objects.equals(this.version, other.version());
    }

    public static abstract class Builder<R, B extends Builder<R, B>> {
        private final Map<R, Set<Identity>> bindings = new HashMap<R, Set<Identity>>();
        private String etag;
        private Integer version;

        protected Builder() {
        }

        public final B bindings(Map<R, Set<Identity>> bindings) {
            Preconditions.checkNotNull(bindings, (Object)"The provided map of bindings cannot be null.");
            for (Map.Entry<R, Set<Identity>> binding : bindings.entrySet()) {
                Preconditions.checkNotNull(binding.getKey(), (Object)"The role cannot be null.");
                Set<Identity> identities = binding.getValue();
                Preconditions.checkNotNull(identities, (Object)"A role cannot be assigned to a null set of identities.");
                Preconditions.checkArgument((!identities.contains(null) ? 1 : 0) != 0, (Object)"Null identities are not permitted.");
            }
            this.bindings.clear();
            for (Map.Entry<R, Set<Identity>> binding : bindings.entrySet()) {
                this.bindings.put(binding.getKey(), new HashSet(binding.getValue()));
            }
            return this.self();
        }

        public final B removeRole(R role) {
            this.bindings.remove(role);
            return this.self();
        }

        public final B addIdentity(R role, Identity first, Identity ... others) {
            String nullIdentityMessage = "Null identities are not permitted.";
            Preconditions.checkNotNull((Object)first, (Object)nullIdentityMessage);
            Preconditions.checkNotNull((Object)others, (Object)nullIdentityMessage);
            for (Identity identity : others) {
                Preconditions.checkNotNull((Object)identity, (Object)nullIdentityMessage);
            }
            LinkedHashSet<Identity> toAdd = new LinkedHashSet<Identity>();
            toAdd.add(first);
            toAdd.addAll(Arrays.asList(others));
            Set<Identity> identities = this.bindings.get(Preconditions.checkNotNull(role, (Object)"The role cannot be null."));
            if (identities == null) {
                identities = new HashSet<Identity>();
                this.bindings.put(role, identities);
            }
            identities.addAll(toAdd);
            return this.self();
        }

        public final B removeIdentity(R role, Identity first, Identity ... others) {
            Set<Identity> identities = this.bindings.get(role);
            if (identities != null) {
                identities.remove(first);
                identities.removeAll(Arrays.asList(others));
            }
            if (identities != null && identities.isEmpty()) {
                this.bindings.remove(role);
            }
            return this.self();
        }

        protected final B etag(String etag) {
            this.etag = etag;
            return this.self();
        }

        protected final B version(Integer version) {
            this.version = version;
            return this.self();
        }

        private B self() {
            return (B)this;
        }

        public abstract IamPolicy<R> build();
    }
}

