/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Blob;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BlobTest {
    private static final byte[] bytes1 = new byte[10];
    private static final byte[] bytes2 = new byte[11];
    private Blob blob1;
    private Blob blob2;

    @Before
    public void setUp() {
        Random rnd = new Random();
        rnd.nextBytes(bytes1);
        rnd.nextBytes(bytes2);
        this.blob1 = Blob.copyFrom((byte[])bytes1);
        this.blob2 = Blob.copyFrom((byte[])bytes2);
    }

    @Test
    public void testEquals() throws Exception {
        Assert.assertEquals((Object)this.blob1, (Object)this.blob1);
        Assert.assertEquals((Object)this.blob1, (Object)Blob.copyFrom((byte[])bytes1));
        Assert.assertNotEquals((Object)this.blob1, (Object)this.blob2);
    }

    @Test
    public void testLength() throws Exception {
        Assert.assertEquals((long)bytes1.length, (long)this.blob1.length());
        Assert.assertEquals((long)bytes2.length, (long)this.blob2.length());
    }

    @Test
    public void testToByteArray() throws Exception {
        Assert.assertArrayEquals((byte[])bytes1, (byte[])this.blob1.toByteArray());
        Assert.assertArrayEquals((byte[])bytes2, (byte[])this.blob2.toByteArray());
    }

    @Test
    public void testAsReadOnlyByteBuffer() throws Exception {
        ByteBuffer buffer = this.blob1.asReadOnlyByteBuffer();
        byte[] bytes = new byte[bytes1.length];
        buffer.get(bytes);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertArrayEquals((byte[])bytes1, (byte[])bytes);
    }

    @Test
    public void testAsInputStream() throws Exception {
        byte[] bytes = new byte[bytes1.length];
        InputStream in = this.blob1.asInputStream();
        Assert.assertEquals((long)bytes1.length, (long)in.read(bytes));
        Assert.assertEquals((long)-1L, (long)in.read());
        Assert.assertArrayEquals((byte[])bytes1, (byte[])bytes);
    }

    @Test
    public void testCopyTo() throws Exception {
        byte[] bytes = new byte[bytes1.length];
        this.blob1.copyTo(bytes);
        Assert.assertArrayEquals((byte[])bytes1, (byte[])bytes);
        ByteBuffer buffer = ByteBuffer.allocate(bytes1.length);
        this.blob1.copyTo(buffer);
        buffer.flip();
        bytes = new byte[bytes1.length];
        buffer.get(bytes);
        Assert.assertFalse((boolean)buffer.hasRemaining());
        Assert.assertArrayEquals((byte[])bytes1, (byte[])bytes);
    }

    @Test
    public void testCopyFrom() throws Exception {
        Blob blob = Blob.copyFrom((ByteBuffer)ByteBuffer.wrap(bytes1));
        Assert.assertEquals((Object)this.blob1, (Object)blob);
        Assert.assertArrayEquals((byte[])bytes1, (byte[])blob.toByteArray());
        blob = Blob.copyFrom((InputStream)new ByteArrayInputStream(bytes2));
        Assert.assertEquals((Object)this.blob2, (Object)blob);
        Assert.assertArrayEquals((byte[])bytes2, (byte[])blob.toByteArray());
    }
}

