/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.datastore.DatastoreException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DatastoreExceptionTest {
    @Test
    public void testDatastoreException() throws Exception {
        DatastoreException exception = new DatastoreException(10, "message", "ABORTED");
        Assert.assertEquals((long)10L, (long)exception.code());
        Assert.assertEquals((Object)"ABORTED", (Object)exception.reason());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        exception = new DatastoreException(4, "message", "DEADLINE_EXCEEDED");
        Assert.assertEquals((long)4L, (long)exception.code());
        Assert.assertEquals((Object)"DEADLINE_EXCEEDED", (Object)exception.reason());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        exception = new DatastoreException(14, "message", "UNAVAILABLE");
        Assert.assertEquals((long)14L, (long)exception.code());
        Assert.assertEquals((Object)"UNAVAILABLE", (Object)exception.reason());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        exception = new DatastoreException(2, "message", "INTERNAL");
        Assert.assertEquals((long)2L, (long)exception.code());
        Assert.assertEquals((Object)"INTERNAL", (Object)exception.reason());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertFalse((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        SocketTimeoutException cause = new SocketTimeoutException("socketTimeoutMessage");
        exception = new DatastoreException((IOException)cause);
        Assert.assertEquals((long)0L, (long)exception.code());
        Assert.assertNull((Object)exception.reason());
        Assert.assertEquals((Object)"socketTimeoutMessage", (Object)exception.getMessage());
        Assert.assertEquals((Object)cause, (Object)exception.getCause());
        Assert.assertTrue((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
        exception = new DatastoreException(2, "message", "INTERNAL", (Throwable)cause);
        Assert.assertEquals((long)2L, (long)exception.code());
        Assert.assertEquals((Object)"INTERNAL", (Object)exception.reason());
        Assert.assertEquals((Object)"message", (Object)exception.getMessage());
        Assert.assertFalse((boolean)exception.retryable());
        Assert.assertTrue((boolean)exception.idempotent());
        Assert.assertSame((Object)cause, (Object)exception.getCause());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        Throwable cause = new DatastoreException(14, "message", "UNAVAILABLE");
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn((Object)cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            DatastoreException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)14L, (long)ex.code());
                Assert.assertEquals((Object)"message", (Object)ex.getMessage());
                Assert.assertTrue((boolean)ex.retryable());
                Assert.assertTrue((boolean)ex.idempotent());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
        cause = new IllegalArgumentException("message");
        exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getMessage()).andReturn((Object)"message").times(1);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn((Object)cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            DatastoreException.translateAndThrow((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)0L, (long)ex.code());
                Assert.assertEquals((Object)"message", (Object)ex.getMessage());
                Assert.assertFalse((boolean)ex.retryable());
                Assert.assertTrue((boolean)ex.idempotent());
                Assert.assertSame((Object)cause, (Object)ex.getCause());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
    }

    @Test
    public void testThrowInvalidRequest() throws Exception {
        try {
            DatastoreException.throwInvalidRequest((String)"message %s %d", (Object[])new Object[]{"a", 1});
            Assert.fail((String)"Exception expected");
        }
        catch (DatastoreException ex) {
            Assert.assertEquals((Object)"FAILED_PRECONDITION", (Object)ex.reason());
            Assert.assertEquals((Object)"message a 1", (Object)ex.getMessage());
        }
    }
}

