/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Datastore;
import com.google.cloud.datastore.DatastoreException;
import com.google.cloud.datastore.DatastoreHelper;
import com.google.cloud.datastore.DatastoreOptions;
import com.google.cloud.datastore.DatastoreReaderWriter;
import com.google.cloud.datastore.DatastoreWriter;
import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.ReadOption;
import com.google.cloud.datastore.Transaction;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class DatastoreHelperTest {
    @Test
    public void testNewKeyFactory() {
        DatastoreOptions options = (DatastoreOptions)EasyMock.createMock(DatastoreOptions.class);
        EasyMock.expect((Object)options.projectId()).andReturn((Object)"ds1").once();
        EasyMock.expect((Object)options.namespace()).andReturn((Object)"ns1").once();
        EasyMock.replay((Object[])new Object[]{options});
        KeyFactory keyFactory = DatastoreHelper.newKeyFactory((DatastoreOptions)options);
        Key key = ((KeyFactory)keyFactory.kind("k")).newKey("bla");
        Assert.assertEquals((Object)"ds1", (Object)key.projectId());
        Assert.assertEquals((Object)"ns1", (Object)key.namespace());
        Assert.assertEquals((Object)"k", (Object)key.kind());
        Assert.assertEquals((Object)"bla", (Object)key.name());
        EasyMock.verify((Object[])new Object[]{options});
    }

    @Test
    public void testAllocateId() throws Exception {
        Datastore datastore = (Datastore)EasyMock.createStrictMock(Datastore.class);
        IncompleteKey pKey1 = IncompleteKey.builder((String)"ds", (String)"k").build();
        Key key1 = Key.builder((IncompleteKey)pKey1, (long)1L).build();
        EasyMock.expect((Object)datastore.allocateId(new IncompleteKey[]{pKey1})).andReturn(Collections.singletonList(key1));
        EasyMock.replay((Object[])new Object[]{datastore});
        Assert.assertEquals((Object)key1, (Object)DatastoreHelper.allocateId((Datastore)datastore, (IncompleteKey)pKey1));
        EasyMock.verify((Object[])new Object[]{datastore});
    }

    @Test
    public void testGetWithDatastore() throws Exception {
        Datastore datastore = (Datastore)EasyMock.createStrictMock(Datastore.class);
        IncompleteKey pKey1 = IncompleteKey.builder((String)"ds", (String)"k").build();
        Key key1 = Key.builder((IncompleteKey)pKey1, (long)1L).build();
        Entity entity1 = Entity.builder((Key)key1).build();
        Key key2 = Key.builder((IncompleteKey)pKey1, (long)2L).build();
        ReadOption.EventualConsistency eventualConsistency = ReadOption.eventualConsistency();
        EasyMock.expect((Object)datastore.get(Collections.singletonList(key1), new ReadOption[0])).andReturn(Collections.singletonList(entity1).iterator());
        EasyMock.expect((Object)datastore.get(Collections.singletonList(key2), new ReadOption[0])).andReturn(Collections.emptyIterator());
        EasyMock.expect((Object)datastore.get(Collections.singletonList(key1), new ReadOption[]{eventualConsistency})).andReturn(Collections.singletonList(entity1).iterator());
        EasyMock.replay((Object[])new Object[]{datastore});
        Assert.assertEquals((Object)entity1, (Object)DatastoreHelper.get((Datastore)datastore, (Key)key1, (ReadOption[])new ReadOption[0]));
        Assert.assertNull((Object)DatastoreHelper.get((Datastore)datastore, (Key)key2, (ReadOption[])new ReadOption[0]));
        Assert.assertEquals((Object)entity1, (Object)DatastoreHelper.get((Datastore)datastore, (Key)key1, (ReadOption[])new ReadOption[]{eventualConsistency}));
        EasyMock.verify((Object[])new Object[]{datastore});
    }

    @Test
    public void testGetWithTransaction() throws Exception {
        Transaction transaction = (Transaction)EasyMock.createStrictMock(Transaction.class);
        IncompleteKey pKey1 = IncompleteKey.builder((String)"ds", (String)"k").build();
        Key key1 = Key.builder((IncompleteKey)pKey1, (long)1L).build();
        Entity entity1 = Entity.builder((Key)key1).build();
        Key key2 = Key.builder((IncompleteKey)pKey1, (long)2L).build();
        EasyMock.expect((Object)transaction.get(new Key[]{key1})).andReturn(Collections.singletonList(entity1).iterator());
        EasyMock.expect((Object)transaction.get(new Key[]{key2})).andReturn(Collections.emptyIterator());
        EasyMock.replay((Object[])new Object[]{transaction});
        Assert.assertEquals((Object)entity1, (Object)DatastoreHelper.get((Transaction)transaction, (Key)key1));
        Assert.assertNull((Object)DatastoreHelper.get((Transaction)transaction, (Key)key2));
        EasyMock.verify((Object[])new Object[]{transaction});
    }

    @Test
    public void testAdd() throws Exception {
        Datastore datastore = (Datastore)EasyMock.createStrictMock(Datastore.class);
        IncompleteKey pKey = IncompleteKey.builder((String)"ds", (String)"k").build();
        Key key = Key.builder((IncompleteKey)pKey, (long)1L).build();
        Entity entity = Entity.builder((Key)key).build();
        EasyMock.expect((Object)datastore.add((FullEntity[])new Entity[]{entity})).andReturn(Collections.singletonList(entity));
        EasyMock.replay((Object[])new Object[]{datastore});
        Assert.assertEquals((Object)entity, (Object)DatastoreHelper.add((DatastoreWriter)datastore, (FullEntity)entity));
        EasyMock.verify((Object[])new Object[]{datastore});
    }

    @Test
    public void testFetchWithDatastore() throws Exception {
        Datastore datastore = (Datastore)EasyMock.createStrictMock(Datastore.class);
        IncompleteKey pKey1 = IncompleteKey.builder((String)"ds", (String)"k").build();
        Key key1 = Key.builder((IncompleteKey)pKey1, (long)1L).build();
        Key key2 = Key.builder((IncompleteKey)pKey1, (String)"a").build();
        Entity entity1 = Entity.builder((Key)key1).build();
        Entity entity2 = Entity.builder((Key)key2).build();
        ReadOption.EventualConsistency eventualConsistency = ReadOption.eventualConsistency();
        EasyMock.expect((Object)datastore.get((Iterable)ImmutableList.of((Object)key1, (Object)key2), new ReadOption[0])).andReturn((Object)Iterators.forArray((Object[])new Entity[]{entity1, entity2})).once();
        EasyMock.expect((Object)datastore.get((Iterable)ImmutableList.of((Object)key1, (Object)key2), new ReadOption[]{eventualConsistency})).andReturn((Object)Iterators.forArray((Object[])new Entity[]{entity1, entity2})).once();
        EasyMock.replay((Object[])new Object[]{datastore});
        List values = DatastoreHelper.fetch((Datastore)datastore, (Key[])new Key[]{key1, key2}, (ReadOption[])new ReadOption[0]);
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)entity1, values.get(0));
        Assert.assertEquals((Object)entity2, values.get(1));
        values = DatastoreHelper.fetch((Datastore)datastore, (Key[])new Key[]{key1, key2}, (ReadOption[])new ReadOption[]{eventualConsistency});
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)entity1, values.get(0));
        Assert.assertEquals((Object)entity2, values.get(1));
        EasyMock.verify((Object[])new Object[]{datastore});
    }

    @Test
    public void testFetchWithTransaction() throws Exception {
        Transaction transaction = (Transaction)EasyMock.createStrictMock(Transaction.class);
        IncompleteKey pKey1 = IncompleteKey.builder((String)"ds", (String)"k").build();
        Key key1 = Key.builder((IncompleteKey)pKey1, (long)1L).build();
        Key key2 = Key.builder((IncompleteKey)pKey1, (String)"a").build();
        Entity entity1 = Entity.builder((Key)key1).build();
        Entity entity2 = Entity.builder((Key)key2).build();
        EasyMock.expect((Object)transaction.get(new Key[]{key1, key2})).andReturn((Object)Iterators.forArray((Object[])new Entity[]{entity1, entity2})).once();
        EasyMock.replay((Object[])new Object[]{transaction});
        List values = DatastoreHelper.fetch((Transaction)transaction, (Key[])new Key[]{key1, key2});
        Assert.assertEquals((long)2L, (long)values.size());
        Assert.assertEquals((Object)entity1, values.get(0));
        Assert.assertEquals((Object)entity2, values.get(1));
        EasyMock.verify((Object[])new Object[]{transaction});
    }

    @Test
    public void testRunInTransaction() throws Exception {
        Datastore datastore = (Datastore)EasyMock.createStrictMock(Datastore.class);
        final Transaction transaction = (Transaction)EasyMock.createStrictMock(Transaction.class);
        EasyMock.expect((Object)datastore.newTransaction()).andReturn((Object)transaction).once();
        EasyMock.expect((Object)transaction.active()).andReturn((Object)true).once();
        EasyMock.expect((Object)transaction.commit()).andReturn(null).once();
        EasyMock.expect((Object)transaction.active()).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{datastore, transaction});
        String value = (String)DatastoreHelper.runInTransaction((Datastore)datastore, (Datastore.TransactionCallable)new Datastore.TransactionCallable<String>(){

            public String run(DatastoreReaderWriter readerWriter) {
                Assert.assertTrue((boolean)transaction.active());
                Assert.assertSame((Object)transaction, (Object)readerWriter);
                return "done";
            }
        });
        EasyMock.verify((Object[])new Object[]{datastore, transaction});
        Assert.assertEquals((Object)"done", (Object)value);
    }

    @Test
    public void testRunInTransactionWithException() throws Exception {
        Datastore datastore = (Datastore)EasyMock.createStrictMock(Datastore.class);
        final Transaction transaction = (Transaction)EasyMock.createStrictMock(Transaction.class);
        EasyMock.expect((Object)datastore.newTransaction()).andReturn((Object)transaction).once();
        EasyMock.expect((Object)transaction.active()).andReturn((Object)true).once();
        transaction.rollback();
        EasyMock.expectLastCall().once();
        EasyMock.expect((Object)transaction.active()).andReturn((Object)false).once();
        EasyMock.replay((Object[])new Object[]{datastore, transaction});
        try {
            DatastoreHelper.runInTransaction((Datastore)datastore, (Datastore.TransactionCallable)new Datastore.TransactionCallable<Void>(){

                public Void run(DatastoreReaderWriter readerWriter) throws Exception {
                    Assert.assertTrue((boolean)transaction.active());
                    Assert.assertSame((Object)transaction, (Object)readerWriter);
                    throw new Exception("Bla");
                }
            });
            Assert.fail((String)"DatastoreException was expected");
        }
        catch (DatastoreException ex) {
            Assert.assertEquals((Object)"Bla", (Object)ex.getCause().getMessage());
        }
        EasyMock.verify((Object[])new Object[]{datastore, transaction});
    }
}

