/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.DateTime;
import java.util.Calendar;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;

public class DateTimeTest {
    @Test
    public void testTimestampMicroseconds() throws Exception {
        Calendar cal = Calendar.getInstance();
        DateTime date = DateTime.copyFrom((Calendar)cal);
        Assert.assertEquals((long)(cal.getTimeInMillis() * 1000L), (long)date.timestampMicroseconds());
    }

    @Test
    public void testTimestampMillis() throws Exception {
        Calendar cal = Calendar.getInstance();
        DateTime date = DateTime.copyFrom((Calendar)cal);
        Assert.assertEquals((long)cal.getTimeInMillis(), (long)date.timestampMillis());
    }

    @Test
    public void testToDate() throws Exception {
        Calendar cal = Calendar.getInstance();
        DateTime date = DateTime.copyFrom((Calendar)cal);
        Assert.assertEquals((Object)cal.getTime(), (Object)date.toDate());
    }

    @Test
    public void testToCalendar() throws Exception {
        Calendar cal = Calendar.getInstance();
        DateTime date = DateTime.copyFrom((Calendar)cal);
        Assert.assertEquals((Object)cal, (Object)date.toCalendar());
    }

    @Test
    public void testNow() throws Exception {
        Calendar cal1 = Calendar.getInstance();
        DateTime now = DateTime.now();
        Calendar cal2 = Calendar.getInstance();
        Assert.assertTrue((now.timestampMillis() >= cal1.getTimeInMillis() ? 1 : 0) != 0);
        Assert.assertTrue((now.timestampMillis() <= cal2.getTimeInMillis() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyFrom() throws Exception {
        Calendar cal = Calendar.getInstance();
        DateTime date1 = DateTime.copyFrom((Calendar)cal);
        DateTime date2 = DateTime.copyFrom((Date)cal.getTime());
        cal.add(5, 1);
        DateTime date3 = DateTime.copyFrom((Date)cal.getTime());
        Assert.assertEquals((Object)date1, (Object)date2);
        Assert.assertNotEquals((Object)date1, (Object)date3);
    }
}

