/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.Entity;
import com.google.cloud.datastore.FullEntity;
import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import org.junit.Assert;
import org.junit.Test;

public class FullEntityTest {
    private static final Key KEY1 = Key.builder((String)"ds1", (String)"k1", (String)"n1").build();
    private static final Key KEY2 = Key.builder((String)"ds1", (String)"k2", (long)1L).build();
    private static final IncompleteKey INCOMPLETE_KEY = IncompleteKey.builder((String)"ds1", (String)"k2").build();
    private static final Entity ENTITY;
    private static final FullEntity<Key> COMPLETE_ENTITY1;
    private static final FullEntity<Key> COMPLETE_ENTITY2;
    private static final FullEntity<IncompleteKey> INCOMPLETE_ENTITY;

    @Test
    public void testFullEntity() throws Exception {
        Assert.assertTrue((boolean)COMPLETE_ENTITY1.hasKey());
        Assert.assertEquals((Object)KEY1, (Object)COMPLETE_ENTITY1.key());
        Assert.assertEquals((Object)"bar", (Object)COMPLETE_ENTITY1.getString("foo"));
        Assert.assertTrue((boolean)COMPLETE_ENTITY2.hasKey());
        Assert.assertEquals((Object)KEY2, (Object)COMPLETE_ENTITY2.key());
        Assert.assertEquals((Object)"bar", (Object)COMPLETE_ENTITY2.getString("foo"));
    }

    @Test
    public void testNoKey() throws Exception {
        FullEntity entity = ((FullEntity.Builder)FullEntity.builder().set("foo", "bar")).build();
        Assert.assertFalse((boolean)entity.hasKey());
        Assert.assertNull((Object)entity.key());
        Assert.assertEquals((Object)"bar", (Object)entity.getString("foo"));
        entity = FullEntity.builder((IncompleteKey)null).build();
        Assert.assertFalse((boolean)entity.hasKey());
        Assert.assertNull((Object)entity.key());
    }

    @Test
    public void testCopyFrom() throws Exception {
        FullEntity.Builder builder1 = FullEntity.builder((FullEntity)ENTITY);
        Assert.assertEquals((Object)ENTITY, (Object)builder1.build());
        builder1 = FullEntity.builder(COMPLETE_ENTITY1);
        Assert.assertEquals(COMPLETE_ENTITY1, (Object)builder1.build());
        FullEntity.Builder builder2 = FullEntity.builder(INCOMPLETE_ENTITY);
        Assert.assertEquals(INCOMPLETE_ENTITY, (Object)builder2.build());
    }

    static {
        COMPLETE_ENTITY1 = ENTITY = ((Entity.Builder)Entity.builder((Key)KEY1).set("foo", "bar")).build();
        COMPLETE_ENTITY2 = ((FullEntity.Builder)FullEntity.builder((IncompleteKey)KEY2).set("foo", "bar")).build();
        INCOMPLETE_ENTITY = ((FullEntity.Builder)Entity.builder((IncompleteKey)INCOMPLETE_KEY).set("a", "b")).build();
    }
}

