/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore;

import com.google.cloud.datastore.IncompleteKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.datastore.KeyFactory;
import com.google.cloud.datastore.PathElement;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KeyFactoryTest {
    private static final String PROJECT_ID = "projectid";
    private KeyFactory keyFactory;

    @Before
    public void setUp() {
        this.keyFactory = (KeyFactory)new KeyFactory(PROJECT_ID).kind("k");
    }

    @Test
    public void testReset() {
        IncompleteKey key = ((KeyFactory)((KeyFactory)((KeyFactory)this.keyFactory.projectId("ds1")).namespace("ns1")).ancestors(PathElement.of((String)"p", (long)1L))).build();
        Assert.assertEquals((Object)"k", (Object)key.kind());
        Assert.assertEquals((Object)"ds1", (Object)key.projectId());
        Assert.assertEquals((Object)"ns1", (Object)key.namespace());
        Assert.assertEquals((long)1L, (long)key.ancestors().size());
        this.keyFactory.reset();
        try {
            this.keyFactory.newKey(1L);
        }
        catch (NullPointerException ex) {
            Assert.assertEquals((Object)"kind must not be null", (Object)ex.getMessage());
        }
        this.keyFactory.kind("k1");
        key = this.keyFactory.newKey();
        Assert.assertEquals((Object)"k1", (Object)key.kind());
        Assert.assertEquals((Object)PROJECT_ID, (Object)key.projectId());
        Assert.assertTrue((boolean)key.namespace().isEmpty());
        Assert.assertTrue((boolean)key.ancestors().isEmpty());
        this.keyFactory = (KeyFactory)new KeyFactory(PROJECT_ID, "ns1").kind("k");
        key = this.keyFactory.newKey();
        Assert.assertEquals((Object)PROJECT_ID, (Object)key.projectId());
        Assert.assertEquals((Object)"ns1", (Object)key.namespace());
        key = ((KeyFactory)((KeyFactory)this.keyFactory.projectId("bla1")).namespace("bla2")).build();
        Assert.assertEquals((Object)"bla1", (Object)key.projectId());
        Assert.assertEquals((Object)"bla2", (Object)key.namespace());
        this.keyFactory.reset().kind("kind");
        key = this.keyFactory.newKey();
        Assert.assertEquals((Object)PROJECT_ID, (Object)key.projectId());
        Assert.assertEquals((Object)"ns1", (Object)key.namespace());
        Assert.assertEquals((Object)"kind", (Object)key.kind());
    }

    @Test
    public void testNewKey() throws Exception {
        Key key = this.keyFactory.newKey(1L);
        this.verifyKey(key, 1L, "", new PathElement[0]);
        key = this.keyFactory.newKey("n");
        this.verifyKey(key, "n", "", new PathElement[0]);
        PathElement p1 = PathElement.of((String)"k1", (String)"n");
        PathElement p2 = PathElement.of((String)"k2", (long)10L);
        key = ((KeyFactory)((KeyFactory)this.keyFactory.namespace("ns")).ancestors(p1, new PathElement[]{p2})).newKey("k3");
        this.verifyKey(key, "k3", "ns", p1, p2);
    }

    @Test
    public void testNewIncompleteKey() throws Exception {
        IncompleteKey key = this.keyFactory.newKey();
        this.verifyIncompleteKey(key, "", new PathElement[0]);
        PathElement p1 = PathElement.of((String)"k1", (String)"n");
        PathElement p2 = PathElement.of((String)"k2", (long)10L);
        key = ((KeyFactory)((KeyFactory)this.keyFactory.namespace("ns")).ancestors(p1, new PathElement[]{p2})).newKey();
        this.verifyIncompleteKey(key, "ns", p1, p2);
    }

    @Test(expected=NullPointerException.class)
    public void testNewIncompleteWithNoKind() {
        new KeyFactory(PROJECT_ID).build();
    }

    private void verifyKey(Key key, String name, String namespace, PathElement ... ancestors) {
        Assert.assertEquals((Object)name, (Object)key.name());
        this.verifyIncompleteKey((IncompleteKey)key, namespace, ancestors);
    }

    private void verifyKey(Key key, Long id, String namespace, PathElement ... ancestors) {
        Assert.assertEquals((Object)id, (Object)key.id());
        this.verifyIncompleteKey((IncompleteKey)key, namespace, ancestors);
    }

    private void verifyIncompleteKey(IncompleteKey key, String namespace, PathElement ... ancestors) {
        Assert.assertEquals((Object)"k", (Object)key.kind());
        Assert.assertEquals((Object)PROJECT_ID, (Object)key.projectId());
        Assert.assertEquals((Object)namespace, (Object)key.namespace());
        Assert.assertEquals((long)ancestors.length, (long)key.ancestors().size());
        Iterator iter = key.ancestors().iterator();
        for (PathElement ancestor : ancestors) {
            Assert.assertEquals((Object)ancestor, iter.next());
        }
    }
}

