/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.http;

import com.google.api.client.googleapis.json.GoogleJsonError;
import com.google.cloud.BaseServiceException;
import com.google.cloud.RetryHelper;
import com.google.cloud.http.BaseHttpServiceException;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class BaseHttpServiceExceptionTest {
    private static final int CODE = 1;
    private static final int CODE_NO_REASON = 2;
    private static final String MESSAGE = "some message";
    private static final String REASON = "some reason";
    private static final boolean RETRYABLE = true;
    private static final boolean IDEMPOTENT = true;
    private static final boolean NOT_IDEMPOTENT = false;
    private static final Set<BaseServiceException.Error> EMPTY_RETRYABLE_ERRORS = Collections.emptySet();

    @Test
    public void testBaseServiceException() {
        BaseHttpServiceException serviceException = new BaseHttpServiceException(1, MESSAGE, REASON, true, EMPTY_RETRYABLE_ERRORS);
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertFalse((boolean)serviceException.isRetryable());
        Assert.assertNull((Object)serviceException.getCause());
        serviceException = new BaseHttpServiceException(1, MESSAGE, REASON, true, EMPTY_RETRYABLE_ERRORS);
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertFalse((boolean)serviceException.isRetryable());
        Assert.assertNull((Object)serviceException.getCause());
        RuntimeException cause = new RuntimeException();
        serviceException = new BaseHttpServiceException(1, MESSAGE, REASON, true, EMPTY_RETRYABLE_ERRORS, (Throwable)cause);
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertFalse((boolean)serviceException.isRetryable());
        Assert.assertEquals((Object)cause, (Object)serviceException.getCause());
        serviceException = new BaseHttpServiceException(1, MESSAGE, REASON, false, EMPTY_RETRYABLE_ERRORS, (Throwable)cause);
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertFalse((boolean)serviceException.isRetryable());
        Assert.assertEquals((Object)cause, (Object)serviceException.getCause());
        IOException exception = new SocketTimeoutException();
        serviceException = new BaseHttpServiceException(exception, true, EMPTY_RETRYABLE_ERRORS);
        Assert.assertTrue((boolean)serviceException.isRetryable());
        Assert.assertNull((Object)serviceException.getMessage());
        Assert.assertEquals((Object)exception, (Object)serviceException.getCause());
        exception = new SocketException();
        serviceException = new BaseHttpServiceException(exception, true, EMPTY_RETRYABLE_ERRORS);
        Assert.assertTrue((boolean)serviceException.isRetryable());
        Assert.assertNull((Object)serviceException.getMessage());
        Assert.assertEquals((Object)exception, (Object)serviceException.getCause());
        exception = new IOException("insufficient data written");
        serviceException = new BaseHttpServiceException(exception, true, EMPTY_RETRYABLE_ERRORS);
        Assert.assertTrue((boolean)serviceException.isRetryable());
        Assert.assertEquals((Object)"insufficient data written", (Object)serviceException.getMessage());
        Assert.assertEquals((Object)exception, (Object)serviceException.getCause());
        GoogleJsonError error = new GoogleJsonError();
        error.setCode(1);
        error.setMessage(MESSAGE);
        serviceException = new BaseHttpServiceException(error, true, EMPTY_RETRYABLE_ERRORS);
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertFalse((boolean)serviceException.isRetryable());
        serviceException = new CustomServiceException(1, MESSAGE, REASON, true);
        Assert.assertEquals((long)1L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertEquals((Object)true, (Object)serviceException.isRetryable());
        serviceException = new CustomServiceException(2, MESSAGE, null, true);
        Assert.assertEquals((long)2L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertNull((Object)serviceException.getReason());
        Assert.assertEquals((Object)true, (Object)serviceException.isRetryable());
        serviceException = new CustomServiceException(0, MESSAGE, REASON, true);
        Assert.assertEquals((long)0L, (long)serviceException.getCode());
        Assert.assertEquals((Object)MESSAGE, (Object)serviceException.getMessage());
        Assert.assertEquals((Object)REASON, (Object)serviceException.getReason());
        Assert.assertEquals((Object)true, (Object)serviceException.isRetryable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTranslateAndThrow() throws Exception {
        BaseHttpServiceException cause = new BaseHttpServiceException(1, MESSAGE, REASON, true, EMPTY_RETRYABLE_ERRORS);
        RetryHelper.RetryHelperException exceptionMock = (RetryHelper.RetryHelperException)EasyMock.createMock(RetryHelper.RetryHelperException.class);
        EasyMock.expect((Object)exceptionMock.getCause()).andReturn((Object)cause).times(2);
        EasyMock.replay((Object[])new Object[]{exceptionMock});
        try {
            BaseServiceException.translate((RetryHelper.RetryHelperException)exceptionMock);
        }
        catch (BaseServiceException ex) {
            try {
                Assert.assertEquals((long)1L, (long)ex.getCode());
                Assert.assertEquals((Object)MESSAGE, (Object)ex.getMessage());
                Assert.assertFalse((boolean)ex.isRetryable());
            }
            catch (Throwable throwable) {
                EasyMock.verify((Object[])new Object[]{exceptionMock});
                throw throwable;
            }
            EasyMock.verify((Object[])new Object[]{exceptionMock});
        }
        EasyMock.verify((Object[])new Object[]{exceptionMock});
    }

    private static class CustomServiceException
    extends BaseHttpServiceException {
        private static final long serialVersionUID = -195251309124875103L;
        private static final Set<BaseServiceException.Error> RETRYABLE_ERRORS = ImmutableSet.of((Object)new BaseServiceException.Error(Integer.valueOf(1), "some reason"), (Object)new BaseServiceException.Error(null, "some reason"), (Object)new BaseServiceException.Error(Integer.valueOf(2), null));

        public CustomServiceException(int code, String message, String reason, boolean idempotent) {
            super(code, message, reason, idempotent, RETRYABLE_ERRORS);
        }
    }
}

