/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.http;

import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.auth.http.HttpTransportFactory;
import com.google.cloud.ServiceOptions;
import com.google.cloud.http.HttpTransportOptions;
import java.util.regex.Pattern;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;

public class HttpTransportOptionsTest {
    private static final HttpTransportFactory MOCK_HTTP_TRANSPORT_FACTORY = (HttpTransportFactory)EasyMock.createMock(HttpTransportFactory.class);
    private static final HttpTransportOptions OPTIONS = HttpTransportOptions.newBuilder().setConnectTimeout(1234).setHttpTransportFactory(MOCK_HTTP_TRANSPORT_FACTORY).setReadTimeout(5678).build();
    private static final HttpTransportOptions DEFAULT_OPTIONS = HttpTransportOptions.newBuilder().build();
    private static final HttpTransportOptions OPTIONS_COPY = OPTIONS.toBuilder().build();

    @Test
    public void testBuilder() {
        Assert.assertEquals((long)1234L, (long)OPTIONS.getConnectTimeout());
        Assert.assertSame((Object)MOCK_HTTP_TRANSPORT_FACTORY, (Object)OPTIONS.getHttpTransportFactory());
        Assert.assertEquals((long)5678L, (long)OPTIONS.getReadTimeout());
        Assert.assertEquals((long)-1L, (long)DEFAULT_OPTIONS.getConnectTimeout());
        Assert.assertTrue((boolean)(DEFAULT_OPTIONS.getHttpTransportFactory() instanceof HttpTransportOptions.DefaultHttpTransportFactory));
        Assert.assertEquals((long)-1L, (long)DEFAULT_OPTIONS.getReadTimeout());
    }

    @Test
    public void testBaseEquals() {
        Assert.assertEquals((Object)OPTIONS, (Object)OPTIONS_COPY);
        Assert.assertNotEquals((Object)DEFAULT_OPTIONS, (Object)OPTIONS);
    }

    @Test
    public void testBaseHashCode() {
        Assert.assertEquals((long)OPTIONS.hashCode(), (long)OPTIONS_COPY.hashCode());
        Assert.assertNotEquals((long)DEFAULT_OPTIONS.hashCode(), (long)OPTIONS.hashCode());
    }

    @Test
    public void testHeader() {
        String expectedHeaderPattern = "^gl-java/.+ gccl/.* gax/.+";
        ServiceOptions serviceOptions = (ServiceOptions)EasyMock.createMock(ServiceOptions.class);
        ApiClientHeaderProvider headerProvider = OPTIONS.getInternalHeaderProviderBuilder(serviceOptions).build();
        Assert.assertEquals((long)1L, (long)headerProvider.getHeaders().size());
        Assert.assertTrue((boolean)Pattern.compile(expectedHeaderPattern).matcher((CharSequence)headerProvider.getHeaders().values().iterator().next()).find());
    }
}

