/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.cloud.http.CensusHttpModule;
import com.google.common.truth.Truth;
import io.opencensus.common.Scope;
import io.opencensus.trace.Span;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.SpanId;
import io.opencensus.trace.TraceId;
import io.opencensus.trace.TraceOptions;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracestate;
import io.opencensus.trace.Tracing;
import io.opencensus.trace.propagation.TextFormat;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Random;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class CensusHttpModuleTest {
    @Rule
    public final ExpectedException thrown = ExpectedException.none();
    private final Tracer tracer = Tracing.getTracer();
    private final CensusHttpModule censusHttpModule = new CensusHttpModule(this.tracer, false);
    private HttpRequest httpRequest;

    @Before
    public void setUp() throws IOException {
        this.httpRequest = new NetHttpTransport().createRequestFactory().buildRequest("GET", new GenericUrl("https://www.google.com"), null);
    }

    @Test
    public void tracerShouldNotBeNull() {
        Truth.assertThat((Object)this.censusHttpModule.getTracer()).isNotNull();
    }

    @Test
    public void isRecordEventsShouldBeSet() {
        Truth.assertThat((Boolean)this.censusHttpModule.isRecordEvents()).isEqualTo((Object)false);
    }

    @Test
    public void getHttpRequestInitializerShouldReturnCorrectClass() {
        HttpRequestInitializer initializer = this.censusHttpModule.getHttpRequestInitializer(null);
        Truth.assertThat((Object)initializer).isInstanceOf(CensusHttpModule.CensusHttpRequestInitializer.class);
    }

    @Test
    public void implementationOfDefaultTextFormatSetter() {
        String testKey = "testKey";
        String testValue = "testValue";
        TextFormat.Setter setter = CensusHttpModule.DefaultPropagationTextFormatSetter.INSTANCE;
        setter.put((Object)this.httpRequest.getHeaders(), testKey, testValue);
        Truth.assertThat((Object)this.httpRequest.getHeaders().get((Object)testKey)).isEqualTo((Object)testValue);
    }

    @Test
    public void censusHttpExecuteInterceptorDisallowNullRequest() throws IOException {
        CensusHttpModule censusHttpModule = this.censusHttpModule;
        censusHttpModule.getClass();
        CensusHttpModule.CensusHttpExecuteInterceptor interceptor = new CensusHttpModule.CensusHttpExecuteInterceptor(censusHttpModule, null);
        this.thrown.expect(NullPointerException.class);
        interceptor.intercept(null);
    }

    @Test
    public void censusHttpExecuteInterceptorShouldExecuteOriginal() throws IOException {
        HttpExecuteInterceptor mockInterceptor = (HttpExecuteInterceptor)EasyMock.createMock(HttpExecuteInterceptor.class);
        CensusHttpModule censusHttpModule = this.censusHttpModule;
        censusHttpModule.getClass();
        CensusHttpModule.CensusHttpExecuteInterceptor censusInterceptor = new CensusHttpModule.CensusHttpExecuteInterceptor(censusHttpModule, mockInterceptor);
        mockInterceptor.intercept(this.httpRequest);
        EasyMock.replay((Object[])new Object[]{mockInterceptor});
        censusInterceptor.intercept(this.httpRequest);
        EasyMock.verify((Object[])new Object[]{mockInterceptor});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void censusHttpExecuteInterceptorShouldInjectHeader() throws IOException {
        Random random = new Random();
        SpanContext spanContext = SpanContext.create((TraceId)TraceId.generateRandomId((Random)random), (SpanId)SpanId.generateRandomId((Random)random), (TraceOptions)TraceOptions.DEFAULT, (Tracestate)Tracestate.builder().build());
        Span mockSpan = (Span)EasyMock.createMockBuilder(Span.class).withConstructor(new Class[]{SpanContext.class, EnumSet.class}).withArgs(new Object[]{spanContext, null}).createMock();
        try (Scope scope = this.tracer.withSpan(mockSpan);){
            CensusHttpModule censusHttpModule = this.censusHttpModule;
            censusHttpModule.getClass();
            CensusHttpModule.CensusHttpExecuteInterceptor interceptor = new CensusHttpModule.CensusHttpExecuteInterceptor(censusHttpModule, null);
            interceptor.intercept(this.httpRequest);
            Truth.assertThat((Object)this.httpRequest.getHeaders().get((Object)"X-Cloud-Trace-Context")).isNotNull();
        }
    }

    @Test
    public void censusHttpRequestInitializerDisallowNullRequest() throws IOException {
        HttpRequestInitializer initializer = this.censusHttpModule.getHttpRequestInitializer(null);
        this.thrown.expect(NullPointerException.class);
        initializer.initialize(null);
    }

    @Test
    public void censusHttpRequestInitializerShouldExecuteOriginal() throws IOException {
        HttpRequestInitializer mockOriginalInitializer = (HttpRequestInitializer)EasyMock.createMock(HttpRequestInitializer.class);
        HttpRequestInitializer censusInitializer = this.censusHttpModule.getHttpRequestInitializer(mockOriginalInitializer);
        mockOriginalInitializer.initialize(this.httpRequest);
        EasyMock.replay((Object[])new Object[]{mockOriginalInitializer});
        censusInitializer.initialize(this.httpRequest);
        EasyMock.verify((Object[])new Object[]{mockOriginalInitializer});
    }

    @Test
    public void censusHttpRequestInitializerShouldSetInterceptor() throws IOException {
        this.censusHttpModule.getHttpRequestInitializer(null).initialize(this.httpRequest);
        Truth.assertThat((Object)this.httpRequest.getInterceptor()).isInstanceOf(CensusHttpModule.CensusHttpExecuteInterceptor.class);
    }
}

