/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1.CreateRealmRequest;
import com.google.cloud.gaming.v1.DeleteRealmRequest;
import com.google.cloud.gaming.v1.GetRealmRequest;
import com.google.cloud.gaming.v1.ListRealmsRequest;
import com.google.cloud.gaming.v1.ListRealmsResponse;
import com.google.cloud.gaming.v1.LocationName;
import com.google.cloud.gaming.v1.MockGameServerClustersService;
import com.google.cloud.gaming.v1.MockGameServerConfigsService;
import com.google.cloud.gaming.v1.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1.MockRealmsService;
import com.google.cloud.gaming.v1.PreviewRealmUpdateRequest;
import com.google.cloud.gaming.v1.PreviewRealmUpdateResponse;
import com.google.cloud.gaming.v1.Realm;
import com.google.cloud.gaming.v1.RealmName;
import com.google.cloud.gaming.v1.RealmsServiceClient;
import com.google.cloud.gaming.v1.RealmsServiceSettings;
import com.google.cloud.gaming.v1.UpdateRealmRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RealmsServiceClientTest {
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerConfigsService mockGameServerConfigsService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockServiceHelper serviceHelper;
    private RealmsServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerConfigsService = new MockGameServerConfigsService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockGameServerClustersService, mockGameServerConfigsService, mockGameServerDeploymentsService, mockRealmsService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        RealmsServiceSettings settings = ((RealmsServiceSettings.Builder)((RealmsServiceSettings.Builder)RealmsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = RealmsServiceClient.create((RealmsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listRealmsTest() {
        String nextPageToken = "";
        Realm realmsElement = Realm.newBuilder().build();
        List<Realm> realms = Arrays.asList(realmsElement);
        ListRealmsResponse expectedResponse = ListRealmsResponse.newBuilder().setNextPageToken(nextPageToken).addAllRealms(realms).build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        RealmsServiceClient.ListRealmsPagedResponse pagedListResponse = this.client.listRealms(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getRealmsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListRealmsRequest actualRequest = (ListRealmsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listRealmsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listRealms(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getRealmTest() {
        RealmName name2 = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        String timeZone = "timeZone36848094";
        String etag = "etag3123477";
        String description = "description-1724546052";
        Realm expectedResponse = Realm.newBuilder().setName(name2.toString()).setTimeZone(timeZone).setEtag(etag).setDescription(description).build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        Realm actualResponse = this.client.getRealm(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetRealmRequest actualRequest = (GetRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)RealmName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.getRealm(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createRealmTest() throws Exception {
        RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        String timeZone = "timeZone36848094";
        String etag = "etag3123477";
        String description = "description-1724546052";
        Realm expectedResponse = Realm.newBuilder().setName(name.toString()).setTimeZone(timeZone).setEtag(etag).setDescription(description).build();
        Operation resultOperation = Operation.newBuilder().setName("createRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        Realm realm = Realm.newBuilder().build();
        String realmId = "realmId-859416373";
        Realm actualResponse = (Realm)this.client.createRealmAsync(parent, realm, realmId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateRealmRequest actualRequest = (CreateRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)realm, (Object)actualRequest.getRealm());
        Assert.assertEquals((Object)realmId, (Object)actualRequest.getRealmId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            Realm realm = Realm.newBuilder().build();
            String realmId = "realmId-859416373";
            this.client.createRealmAsync(parent, realm, realmId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteRealmTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        Empty actualResponse = (Empty)this.client.deleteRealmAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteRealmRequest actualRequest = (DeleteRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)RealmName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.deleteRealmAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateRealmTest() throws Exception {
        RealmName name = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        String timeZone = "timeZone36848094";
        String etag = "etag3123477";
        String description = "description-1724546052";
        Realm expectedResponse = Realm.newBuilder().setName(name.toString()).setTimeZone(timeZone).setEtag(etag).setDescription(description).build();
        Operation resultOperation = Operation.newBuilder().setName("updateRealmTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockRealmsService.addResponse((AbstractMessage)resultOperation);
        Realm realm = Realm.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        Realm actualResponse = (Realm)this.client.updateRealmAsync(realm, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateRealmRequest actualRequest = (UpdateRealmRequest)actualRequests.get(0);
        Assert.assertEquals((Object)realm, (Object)actualRequest.getRealm());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateRealmExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            Realm realm = Realm.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateRealmAsync(realm, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewRealmUpdateTest() {
        String etag = "etag3123477";
        PreviewRealmUpdateResponse expectedResponse = PreviewRealmUpdateResponse.newBuilder().setEtag(etag).build();
        mockRealmsService.addResponse((AbstractMessage)expectedResponse);
        Realm realm = Realm.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        PreviewRealmUpdateRequest request = PreviewRealmUpdateRequest.newBuilder().setRealm(realm).setUpdateMask(updateMask).build();
        PreviewRealmUpdateResponse actualResponse = this.client.previewRealmUpdate(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockRealmsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewRealmUpdateRequest actualRequest = (PreviewRealmUpdateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)realm, (Object)actualRequest.getRealm());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewRealmUpdateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockRealmsService.addException((Exception)exception);
        try {
            Realm realm = Realm.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            PreviewRealmUpdateRequest request = PreviewRealmUpdateRequest.newBuilder().setRealm(realm).setUpdateMask(updateMask).build();
            this.client.previewRealmUpdate(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

