/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1beta.CreateGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.DeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.GameServerCluster;
import com.google.cloud.gaming.v1beta.GameServerClusterName;
import com.google.cloud.gaming.v1beta.GameServerClustersServiceClient;
import com.google.cloud.gaming.v1beta.GameServerClustersServiceSettings;
import com.google.cloud.gaming.v1beta.GetGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.ListGameServerClustersRequest;
import com.google.cloud.gaming.v1beta.ListGameServerClustersResponse;
import com.google.cloud.gaming.v1beta.MockGameServerClustersService;
import com.google.cloud.gaming.v1beta.MockGameServerConfigsService;
import com.google.cloud.gaming.v1beta.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1beta.MockRealmsService;
import com.google.cloud.gaming.v1beta.PreviewCreateGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.PreviewCreateGameServerClusterResponse;
import com.google.cloud.gaming.v1beta.PreviewDeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.PreviewDeleteGameServerClusterResponse;
import com.google.cloud.gaming.v1beta.PreviewUpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1beta.PreviewUpdateGameServerClusterResponse;
import com.google.cloud.gaming.v1beta.RealmName;
import com.google.cloud.gaming.v1beta.UpdateGameServerClusterRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerClustersServiceClientTest {
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerConfigsService mockGameServerConfigsService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockServiceHelper serviceHelper;
    private GameServerClustersServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerConfigsService = new MockGameServerConfigsService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockGameServerClustersService, mockGameServerConfigsService, mockGameServerDeploymentsService, mockRealmsService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        GameServerClustersServiceSettings settings = ((GameServerClustersServiceSettings.Builder)((GameServerClustersServiceSettings.Builder)GameServerClustersServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = GameServerClustersServiceClient.create((GameServerClustersServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listGameServerClustersTest() {
        String nextPageToken = "";
        GameServerCluster gameServerClustersElement = GameServerCluster.newBuilder().build();
        List<GameServerCluster> gameServerClusters = Arrays.asList(gameServerClustersElement);
        ListGameServerClustersResponse expectedResponse = ListGameServerClustersResponse.newBuilder().setNextPageToken(nextPageToken).addAllGameServerClusters(gameServerClusters).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        GameServerClustersServiceClient.ListGameServerClustersPagedResponse pagedListResponse = this.client.listGameServerClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerClustersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerClustersRequest actualRequest = (ListGameServerClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)RealmName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerClustersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.listGameServerClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerClusterTest() {
        GameServerClusterName name2 = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        String etag = "etag3123477";
        String description = "description-1724546052";
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(name2.toString()).setEtag(etag).setDescription(description).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        GameServerCluster actualResponse = this.client.getGameServerCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerClusterRequest actualRequest = (GetGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)GameServerClusterName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
            this.client.getGameServerCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerClusterTest() throws Exception {
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        String etag = "etag3123477";
        String description = "description-1724546052";
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(name.toString()).setEtag(etag).setDescription(description).build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        String gameServerClusterId = "gameServerClusterId-858763025";
        GameServerCluster actualResponse = (GameServerCluster)this.client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerClusterRequest actualRequest = (CreateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)RealmName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)gameServerClusterId, (Object)actualRequest.getGameServerClusterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            String gameServerClusterId = "gameServerClusterId-858763025";
            this.client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewCreateGameServerClusterTest() {
        String etag = "etag3123477";
        PreviewCreateGameServerClusterResponse expectedResponse = PreviewCreateGameServerClusterResponse.newBuilder().setEtag(etag).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        String gameServerClusterId = "gameServerClusterId-858763025";
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        PreviewCreateGameServerClusterRequest request = PreviewCreateGameServerClusterRequest.newBuilder().setParent(parent.toString()).setGameServerClusterId(gameServerClusterId).setGameServerCluster(gameServerCluster).build();
        PreviewCreateGameServerClusterResponse actualResponse = this.client.previewCreateGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewCreateGameServerClusterRequest actualRequest = (PreviewCreateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)RealmName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)gameServerClusterId, (Object)actualRequest.getGameServerClusterId());
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewCreateGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            String gameServerClusterId = "gameServerClusterId-858763025";
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            PreviewCreateGameServerClusterRequest request = PreviewCreateGameServerClusterRequest.newBuilder().setParent(parent.toString()).setGameServerClusterId(gameServerClusterId).setGameServerCluster(gameServerCluster).build();
            this.client.previewCreateGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGameServerClusterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        Empty actualResponse = (Empty)this.client.deleteGameServerClusterAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerClusterRequest actualRequest = (DeleteGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)GameServerClusterName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
            this.client.deleteGameServerClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewDeleteGameServerClusterTest() {
        String etag = "etag3123477";
        PreviewDeleteGameServerClusterResponse expectedResponse = PreviewDeleteGameServerClusterResponse.newBuilder().setEtag(etag).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        PreviewDeleteGameServerClusterRequest request = PreviewDeleteGameServerClusterRequest.newBuilder().setName(name.toString()).build();
        PreviewDeleteGameServerClusterResponse actualResponse = this.client.previewDeleteGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewDeleteGameServerClusterRequest actualRequest = (PreviewDeleteGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)GameServerClusterName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewDeleteGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
            PreviewDeleteGameServerClusterRequest request = PreviewDeleteGameServerClusterRequest.newBuilder().setName(name.toString()).build();
            this.client.previewDeleteGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateGameServerClusterTest() throws Exception {
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        String etag = "etag3123477";
        String description = "description-1724546052";
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(name.toString()).setEtag(etag).setDescription(description).build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerCluster actualResponse = (GameServerCluster)this.client.updateGameServerClusterAsync(gameServerCluster, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGameServerClusterRequest actualRequest = (UpdateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateGameServerClusterAsync(gameServerCluster, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewUpdateGameServerClusterTest() {
        String etag = "etag3123477";
        PreviewUpdateGameServerClusterResponse expectedResponse = PreviewUpdateGameServerClusterResponse.newBuilder().setEtag(etag).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        PreviewUpdateGameServerClusterRequest request = PreviewUpdateGameServerClusterRequest.newBuilder().setGameServerCluster(gameServerCluster).setUpdateMask(updateMask).build();
        PreviewUpdateGameServerClusterResponse actualResponse = this.client.previewUpdateGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewUpdateGameServerClusterRequest actualRequest = (PreviewUpdateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewUpdateGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            PreviewUpdateGameServerClusterRequest request = PreviewUpdateGameServerClusterRequest.newBuilder().setGameServerCluster(gameServerCluster).setUpdateMask(updateMask).build();
            this.client.previewUpdateGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

