/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1beta.CreateGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.DeleteGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.GameServerConfig;
import com.google.cloud.gaming.v1beta.GameServerConfigName;
import com.google.cloud.gaming.v1beta.GameServerConfigsServiceClient;
import com.google.cloud.gaming.v1beta.GameServerConfigsServiceSettings;
import com.google.cloud.gaming.v1beta.GameServerDeploymentName;
import com.google.cloud.gaming.v1beta.GetGameServerConfigRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsRequest;
import com.google.cloud.gaming.v1beta.ListGameServerConfigsResponse;
import com.google.cloud.gaming.v1beta.MockGameServerClustersService;
import com.google.cloud.gaming.v1beta.MockGameServerConfigsService;
import com.google.cloud.gaming.v1beta.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1beta.MockRealmsService;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerConfigsServiceClientTest {
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerConfigsService mockGameServerConfigsService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockServiceHelper serviceHelper;
    private GameServerConfigsServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerConfigsService = new MockGameServerConfigsService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockGameServerClustersService, mockGameServerConfigsService, mockGameServerDeploymentsService, mockRealmsService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        GameServerConfigsServiceSettings settings = ((GameServerConfigsServiceSettings.Builder)((GameServerConfigsServiceSettings.Builder)GameServerConfigsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = GameServerConfigsServiceClient.create((GameServerConfigsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listGameServerConfigsTest() {
        String nextPageToken = "";
        GameServerConfig gameServerConfigsElement = GameServerConfig.newBuilder().build();
        List<GameServerConfig> gameServerConfigs = Arrays.asList(gameServerConfigsElement);
        ListGameServerConfigsResponse expectedResponse = ListGameServerConfigsResponse.newBuilder().setNextPageToken(nextPageToken).addAllGameServerConfigs(gameServerConfigs).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)expectedResponse);
        GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse pagedListResponse = this.client.listGameServerConfigs(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerConfigsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerConfigsRequest actualRequest = (ListGameServerConfigsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)GameServerDeploymentName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerConfigsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.listGameServerConfigs(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerConfigTest() {
        GameServerConfigName name2 = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
        String description = "description-1724546052";
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(name2.toString()).setDescription(description).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)expectedResponse);
        GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
        GameServerConfig actualResponse = this.client.getGameServerConfig(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerConfigRequest actualRequest = (GetGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)GameServerConfigName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
            this.client.getGameServerConfig(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerConfigTest() throws Exception {
        GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
        String description = "description-1724546052";
        GameServerConfig expectedResponse = GameServerConfig.newBuilder().setName(name.toString()).setDescription(description).build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)resultOperation);
        GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
        GameServerConfig actualResponse = (GameServerConfig)this.client.createGameServerConfigAsync(parent, gameServerConfig).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerConfigRequest actualRequest = (CreateGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)GameServerDeploymentName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)gameServerConfig, (Object)actualRequest.getGameServerConfig());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            GameServerDeploymentName parent = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            GameServerConfig gameServerConfig = GameServerConfig.newBuilder().build();
            this.client.createGameServerConfigAsync(parent, gameServerConfig).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGameServerConfigTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerConfigTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerConfigsService.addResponse((AbstractMessage)resultOperation);
        GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
        Empty actualResponse = (Empty)this.client.deleteGameServerConfigAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerConfigsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerConfigRequest actualRequest = (DeleteGameServerConfigRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)GameServerConfigName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerConfigExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerConfigsService.addException((Exception)exception);
        try {
            GameServerConfigName name = GameServerConfigName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]", (String)"[CONFIG]");
            this.client.deleteGameServerConfigAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }
}

