/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1beta;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1beta.CreateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1beta.DeleteGameServerDeploymentRequest;
import com.google.cloud.gaming.v1beta.FetchDeploymentStateRequest;
import com.google.cloud.gaming.v1beta.FetchDeploymentStateResponse;
import com.google.cloud.gaming.v1beta.GameServerDeployment;
import com.google.cloud.gaming.v1beta.GameServerDeploymentName;
import com.google.cloud.gaming.v1beta.GameServerDeploymentRollout;
import com.google.cloud.gaming.v1beta.GameServerDeploymentRolloutName;
import com.google.cloud.gaming.v1beta.GameServerDeploymentsServiceClient;
import com.google.cloud.gaming.v1beta.GameServerDeploymentsServiceSettings;
import com.google.cloud.gaming.v1beta.GetGameServerDeploymentRequest;
import com.google.cloud.gaming.v1beta.GetGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1beta.ListGameServerDeploymentsRequest;
import com.google.cloud.gaming.v1beta.ListGameServerDeploymentsResponse;
import com.google.cloud.gaming.v1beta.LocationName;
import com.google.cloud.gaming.v1beta.MockGameServerClustersService;
import com.google.cloud.gaming.v1beta.MockGameServerConfigsService;
import com.google.cloud.gaming.v1beta.MockGameServerDeploymentsService;
import com.google.cloud.gaming.v1beta.MockRealmsService;
import com.google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1beta.PreviewGameServerDeploymentRolloutResponse;
import com.google.cloud.gaming.v1beta.UpdateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1beta.UpdateGameServerDeploymentRolloutRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerDeploymentsServiceClientTest {
    private static MockGameServerClustersService mockGameServerClustersService;
    private static MockGameServerConfigsService mockGameServerConfigsService;
    private static MockGameServerDeploymentsService mockGameServerDeploymentsService;
    private static MockRealmsService mockRealmsService;
    private static MockServiceHelper serviceHelper;
    private GameServerDeploymentsServiceClient client;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockGameServerClustersService = new MockGameServerClustersService();
        mockGameServerConfigsService = new MockGameServerConfigsService();
        mockGameServerDeploymentsService = new MockGameServerDeploymentsService();
        mockRealmsService = new MockRealmsService();
        serviceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockGameServerClustersService, mockGameServerConfigsService, mockGameServerDeploymentsService, mockRealmsService));
        serviceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        serviceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        serviceHelper.reset();
        this.channelProvider = serviceHelper.createChannelProvider();
        GameServerDeploymentsServiceSettings settings = ((GameServerDeploymentsServiceSettings.Builder)((GameServerDeploymentsServiceSettings.Builder)GameServerDeploymentsServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = GameServerDeploymentsServiceClient.create((GameServerDeploymentsServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listGameServerDeploymentsTest() {
        String nextPageToken = "";
        GameServerDeployment gameServerDeploymentsElement = GameServerDeployment.newBuilder().build();
        List<GameServerDeployment> gameServerDeployments = Arrays.asList(gameServerDeploymentsElement);
        ListGameServerDeploymentsResponse expectedResponse = ListGameServerDeploymentsResponse.newBuilder().setNextPageToken(nextPageToken).addAllGameServerDeployments(gameServerDeployments).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)expectedResponse);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        GameServerDeploymentsServiceClient.ListGameServerDeploymentsPagedResponse pagedListResponse = this.client.listGameServerDeployments(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerDeploymentsList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerDeploymentsRequest actualRequest = (ListGameServerDeploymentsRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerDeploymentsExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            this.client.listGameServerDeployments(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerDeploymentTest() {
        GameServerDeploymentName name2 = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        String etag = "etag3123477";
        String description = "description-1724546052";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name2.toString()).setEtag(etag).setDescription(description).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)expectedResponse);
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerDeployment actualResponse = this.client.getGameServerDeployment(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerDeploymentRequest actualRequest = (GetGameServerDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)GameServerDeploymentName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.getGameServerDeployment(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerDeploymentTest() throws Exception {
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        String etag = "etag3123477";
        String description = "description-1724546052";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name.toString()).setEtag(etag).setDescription(description).build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
        GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.createGameServerDeploymentAsync(parent, gameServerDeployment).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerDeploymentRequest actualRequest = (CreateGameServerDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)LocationName.parse((String)actualRequest.getParent()));
        Assert.assertEquals((Object)gameServerDeployment, (Object)actualRequest.getGameServerDeployment());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            LocationName parent = LocationName.of((String)"[PROJECT]", (String)"[LOCATION]");
            GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
            this.client.createGameServerDeploymentAsync(parent, gameServerDeployment).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGameServerDeploymentTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        Empty actualResponse = (Empty)this.client.deleteGameServerDeploymentAsync(name).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerDeploymentRequest actualRequest = (DeleteGameServerDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)GameServerDeploymentName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.deleteGameServerDeploymentAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void updateGameServerDeploymentTest() throws Exception {
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        String etag = "etag3123477";
        String description = "description-1724546052";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name.toString()).setEtag(etag).setDescription(description).build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerDeploymentTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.updateGameServerDeploymentAsync(gameServerDeployment, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGameServerDeploymentRequest actualRequest = (UpdateGameServerDeploymentRequest)actualRequests.get(0);
        Assert.assertEquals((Object)gameServerDeployment, (Object)actualRequest.getGameServerDeployment());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGameServerDeploymentExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateGameServerDeploymentAsync(gameServerDeployment, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void getGameServerDeploymentRolloutTest() {
        GameServerDeploymentRolloutName name2 = GameServerDeploymentRolloutName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        String defaultGameServerConfig = "defaultGameServerConfig-1758159633";
        String etag = "etag3123477";
        GameServerDeploymentRollout expectedResponse = GameServerDeploymentRollout.newBuilder().setName(name2.toString()).setDefaultGameServerConfig(defaultGameServerConfig).setEtag(etag).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)expectedResponse);
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        GameServerDeploymentRollout actualResponse = this.client.getGameServerDeploymentRollout(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerDeploymentRolloutRequest actualRequest = (GetGameServerDeploymentRolloutRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)GameServerDeploymentName.parse((String)actualRequest.getName()));
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerDeploymentRolloutExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
            this.client.getGameServerDeploymentRollout(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateGameServerDeploymentRolloutTest() throws Exception {
        GameServerDeploymentName name = GameServerDeploymentName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[DEPLOYMENT]");
        String etag = "etag3123477";
        String description = "description-1724546052";
        GameServerDeployment expectedResponse = GameServerDeployment.newBuilder().setName(name.toString()).setEtag(etag).setDescription(description).build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerDeploymentRolloutTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)resultOperation);
        GameServerDeploymentRollout rollout = GameServerDeploymentRollout.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerDeployment actualResponse = (GameServerDeployment)this.client.updateGameServerDeploymentRolloutAsync(rollout, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGameServerDeploymentRolloutRequest actualRequest = (UpdateGameServerDeploymentRolloutRequest)actualRequests.get(0);
        Assert.assertEquals((Object)rollout, (Object)actualRequest.getRollout());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGameServerDeploymentRolloutExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            GameServerDeploymentRollout rollout = GameServerDeploymentRollout.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateGameServerDeploymentRolloutAsync(rollout, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewGameServerDeploymentRolloutTest() {
        String etag = "etag3123477";
        PreviewGameServerDeploymentRolloutResponse expectedResponse = PreviewGameServerDeploymentRolloutResponse.newBuilder().setEtag(etag).build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)expectedResponse);
        GameServerDeploymentRollout rollout = GameServerDeploymentRollout.newBuilder().build();
        PreviewGameServerDeploymentRolloutRequest request = PreviewGameServerDeploymentRolloutRequest.newBuilder().setRollout(rollout).build();
        PreviewGameServerDeploymentRolloutResponse actualResponse = this.client.previewGameServerDeploymentRollout(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewGameServerDeploymentRolloutRequest actualRequest = (PreviewGameServerDeploymentRolloutRequest)actualRequests.get(0);
        Assert.assertEquals((Object)rollout, (Object)actualRequest.getRollout());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewGameServerDeploymentRolloutExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            GameServerDeploymentRollout rollout = GameServerDeploymentRollout.newBuilder().build();
            PreviewGameServerDeploymentRolloutRequest request = PreviewGameServerDeploymentRolloutRequest.newBuilder().setRollout(rollout).build();
            this.client.previewGameServerDeploymentRollout(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void fetchDeploymentStateTest() {
        FetchDeploymentStateResponse expectedResponse = FetchDeploymentStateResponse.newBuilder().build();
        mockGameServerDeploymentsService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        FetchDeploymentStateRequest request = FetchDeploymentStateRequest.newBuilder().setName(name).build();
        FetchDeploymentStateResponse actualResponse = this.client.fetchDeploymentState(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerDeploymentsService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        FetchDeploymentStateRequest actualRequest = (FetchDeploymentStateRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void fetchDeploymentStateExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerDeploymentsService.addException((Exception)exception);
        try {
            String name = "name3373707";
            FetchDeploymentStateRequest request = FetchDeploymentStateRequest.newBuilder().setName(name).build();
            this.client.fetchDeploymentState(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

