/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1.CreateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.DeleteGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.FetchDeploymentStateRequest;
import com.google.cloud.gaming.v1.FetchDeploymentStateResponse;
import com.google.cloud.gaming.v1.GameServerDeployment;
import com.google.cloud.gaming.v1.GameServerDeploymentName;
import com.google.cloud.gaming.v1.GameServerDeploymentRollout;
import com.google.cloud.gaming.v1.GameServerDeploymentsServiceSettings;
import com.google.cloud.gaming.v1.GetGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.GetGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.ListGameServerDeploymentsRequest;
import com.google.cloud.gaming.v1.ListGameServerDeploymentsResponse;
import com.google.cloud.gaming.v1.LocationName;
import com.google.cloud.gaming.v1.OperationMetadata;
import com.google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutResponse;
import com.google.cloud.gaming.v1.UpdateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.UpdateGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.stub.GameServerDeploymentsServiceStub;
import com.google.cloud.gaming.v1.stub.GameServerDeploymentsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class GameServerDeploymentsServiceClient
implements BackgroundResource {
    private final GameServerDeploymentsServiceSettings settings;
    private final GameServerDeploymentsServiceStub stub;
    private final OperationsClient operationsClient;

    public static final GameServerDeploymentsServiceClient create() throws IOException {
        return GameServerDeploymentsServiceClient.create(GameServerDeploymentsServiceSettings.newBuilder().build());
    }

    public static final GameServerDeploymentsServiceClient create(GameServerDeploymentsServiceSettings settings) throws IOException {
        return new GameServerDeploymentsServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final GameServerDeploymentsServiceClient create(GameServerDeploymentsServiceStub stub) {
        return new GameServerDeploymentsServiceClient(stub);
    }

    protected GameServerDeploymentsServiceClient(GameServerDeploymentsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((GameServerDeploymentsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected GameServerDeploymentsServiceClient(GameServerDeploymentsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final GameServerDeploymentsServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GameServerDeploymentsServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListGameServerDeploymentsPagedResponse listGameServerDeployments(LocationName parent) {
        ListGameServerDeploymentsRequest request = ListGameServerDeploymentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listGameServerDeployments(request);
    }

    public final ListGameServerDeploymentsPagedResponse listGameServerDeployments(String parent) {
        ListGameServerDeploymentsRequest request = ListGameServerDeploymentsRequest.newBuilder().setParent(parent).build();
        return this.listGameServerDeployments(request);
    }

    public final ListGameServerDeploymentsPagedResponse listGameServerDeployments(ListGameServerDeploymentsRequest request) {
        return (ListGameServerDeploymentsPagedResponse)((Object)this.listGameServerDeploymentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListGameServerDeploymentsRequest, ListGameServerDeploymentsPagedResponse> listGameServerDeploymentsPagedCallable() {
        return this.stub.listGameServerDeploymentsPagedCallable();
    }

    public final UnaryCallable<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse> listGameServerDeploymentsCallable() {
        return this.stub.listGameServerDeploymentsCallable();
    }

    public final GameServerDeployment getGameServerDeployment(GameServerDeploymentName name) {
        GetGameServerDeploymentRequest request = GetGameServerDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGameServerDeployment(request);
    }

    public final GameServerDeployment getGameServerDeployment(String name) {
        GetGameServerDeploymentRequest request = GetGameServerDeploymentRequest.newBuilder().setName(name).build();
        return this.getGameServerDeployment(request);
    }

    public final GameServerDeployment getGameServerDeployment(GetGameServerDeploymentRequest request) {
        return (GameServerDeployment)this.getGameServerDeploymentCallable().call((Object)request);
    }

    public final UnaryCallable<GetGameServerDeploymentRequest, GameServerDeployment> getGameServerDeploymentCallable() {
        return this.stub.getGameServerDeploymentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, OperationMetadata> createGameServerDeploymentAsync(LocationName parent, GameServerDeployment gameServerDeployment) {
        CreateGameServerDeploymentRequest request = CreateGameServerDeploymentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setGameServerDeployment(gameServerDeployment).build();
        return this.createGameServerDeploymentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, OperationMetadata> createGameServerDeploymentAsync(String parent, GameServerDeployment gameServerDeployment) {
        CreateGameServerDeploymentRequest request = CreateGameServerDeploymentRequest.newBuilder().setParent(parent).setGameServerDeployment(gameServerDeployment).build();
        return this.createGameServerDeploymentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, OperationMetadata> createGameServerDeploymentAsync(CreateGameServerDeploymentRequest request) {
        return this.createGameServerDeploymentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> createGameServerDeploymentOperationCallable() {
        return this.stub.createGameServerDeploymentOperationCallable();
    }

    public final UnaryCallable<CreateGameServerDeploymentRequest, Operation> createGameServerDeploymentCallable() {
        return this.stub.createGameServerDeploymentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteGameServerDeploymentAsync(GameServerDeploymentName name) {
        DeleteGameServerDeploymentRequest request = DeleteGameServerDeploymentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteGameServerDeploymentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteGameServerDeploymentAsync(String name) {
        DeleteGameServerDeploymentRequest request = DeleteGameServerDeploymentRequest.newBuilder().setName(name).build();
        return this.deleteGameServerDeploymentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteGameServerDeploymentAsync(DeleteGameServerDeploymentRequest request) {
        return this.deleteGameServerDeploymentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteGameServerDeploymentRequest, Empty, OperationMetadata> deleteGameServerDeploymentOperationCallable() {
        return this.stub.deleteGameServerDeploymentOperationCallable();
    }

    public final UnaryCallable<DeleteGameServerDeploymentRequest, Operation> deleteGameServerDeploymentCallable() {
        return this.stub.deleteGameServerDeploymentCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, OperationMetadata> updateGameServerDeploymentAsync(GameServerDeployment gameServerDeployment, FieldMask updateMask) {
        UpdateGameServerDeploymentRequest request = UpdateGameServerDeploymentRequest.newBuilder().setGameServerDeployment(gameServerDeployment).setUpdateMask(updateMask).build();
        return this.updateGameServerDeploymentAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, OperationMetadata> updateGameServerDeploymentAsync(UpdateGameServerDeploymentRequest request) {
        return this.updateGameServerDeploymentOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateGameServerDeploymentRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentOperationCallable() {
        return this.stub.updateGameServerDeploymentOperationCallable();
    }

    public final UnaryCallable<UpdateGameServerDeploymentRequest, Operation> updateGameServerDeploymentCallable() {
        return this.stub.updateGameServerDeploymentCallable();
    }

    public final GameServerDeploymentRollout getGameServerDeploymentRollout(GameServerDeploymentName name) {
        GetGameServerDeploymentRolloutRequest request = GetGameServerDeploymentRolloutRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getGameServerDeploymentRollout(request);
    }

    public final GameServerDeploymentRollout getGameServerDeploymentRollout(String name) {
        GetGameServerDeploymentRolloutRequest request = GetGameServerDeploymentRolloutRequest.newBuilder().setName(name).build();
        return this.getGameServerDeploymentRollout(request);
    }

    public final GameServerDeploymentRollout getGameServerDeploymentRollout(GetGameServerDeploymentRolloutRequest request) {
        return (GameServerDeploymentRollout)this.getGameServerDeploymentRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<GetGameServerDeploymentRolloutRequest, GameServerDeploymentRollout> getGameServerDeploymentRolloutCallable() {
        return this.stub.getGameServerDeploymentRolloutCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, OperationMetadata> updateGameServerDeploymentRolloutAsync(GameServerDeploymentRollout rollout, FieldMask updateMask) {
        UpdateGameServerDeploymentRolloutRequest request = UpdateGameServerDeploymentRolloutRequest.newBuilder().setRollout(rollout).setUpdateMask(updateMask).build();
        return this.updateGameServerDeploymentRolloutAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<GameServerDeployment, OperationMetadata> updateGameServerDeploymentRolloutAsync(UpdateGameServerDeploymentRolloutRequest request) {
        return this.updateGameServerDeploymentRolloutOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateGameServerDeploymentRolloutRequest, GameServerDeployment, OperationMetadata> updateGameServerDeploymentRolloutOperationCallable() {
        return this.stub.updateGameServerDeploymentRolloutOperationCallable();
    }

    public final UnaryCallable<UpdateGameServerDeploymentRolloutRequest, Operation> updateGameServerDeploymentRolloutCallable() {
        return this.stub.updateGameServerDeploymentRolloutCallable();
    }

    public final PreviewGameServerDeploymentRolloutResponse previewGameServerDeploymentRollout(PreviewGameServerDeploymentRolloutRequest request) {
        return (PreviewGameServerDeploymentRolloutResponse)this.previewGameServerDeploymentRolloutCallable().call((Object)request);
    }

    public final UnaryCallable<PreviewGameServerDeploymentRolloutRequest, PreviewGameServerDeploymentRolloutResponse> previewGameServerDeploymentRolloutCallable() {
        return this.stub.previewGameServerDeploymentRolloutCallable();
    }

    public final FetchDeploymentStateResponse fetchDeploymentState(FetchDeploymentStateRequest request) {
        return (FetchDeploymentStateResponse)this.fetchDeploymentStateCallable().call((Object)request);
    }

    public final UnaryCallable<FetchDeploymentStateRequest, FetchDeploymentStateResponse> fetchDeploymentStateCallable() {
        return this.stub.fetchDeploymentStateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListGameServerDeploymentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment, ListGameServerDeploymentsPage, ListGameServerDeploymentsFixedSizeCollection> {
        private ListGameServerDeploymentsFixedSizeCollection(List<ListGameServerDeploymentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListGameServerDeploymentsFixedSizeCollection createEmptyCollection() {
            return new ListGameServerDeploymentsFixedSizeCollection(null, 0);
        }

        protected ListGameServerDeploymentsFixedSizeCollection createCollection(List<ListGameServerDeploymentsPage> pages, int collectionSize) {
            return new ListGameServerDeploymentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListGameServerDeploymentsPage
    extends AbstractPage<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment, ListGameServerDeploymentsPage> {
        private ListGameServerDeploymentsPage(PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> context, ListGameServerDeploymentsResponse response) {
            super(context, (Object)response);
        }

        private static ListGameServerDeploymentsPage createEmptyPage() {
            return new ListGameServerDeploymentsPage(null, null);
        }

        protected ListGameServerDeploymentsPage createPage(PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> context, ListGameServerDeploymentsResponse response) {
            return new ListGameServerDeploymentsPage(context, response);
        }

        public ApiFuture<ListGameServerDeploymentsPage> createPageAsync(PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> context, ApiFuture<ListGameServerDeploymentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListGameServerDeploymentsPagedResponse
    extends AbstractPagedListResponse<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment, ListGameServerDeploymentsPage, ListGameServerDeploymentsFixedSizeCollection> {
        public static ApiFuture<ListGameServerDeploymentsPagedResponse> createAsync(PageContext<ListGameServerDeploymentsRequest, ListGameServerDeploymentsResponse, GameServerDeployment> context, ApiFuture<ListGameServerDeploymentsResponse> futureResponse) {
            ApiFuture<ListGameServerDeploymentsPage> futurePage = ListGameServerDeploymentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListGameServerDeploymentsPage, ListGameServerDeploymentsPagedResponse>(){

                public ListGameServerDeploymentsPagedResponse apply(ListGameServerDeploymentsPage input) {
                    return new ListGameServerDeploymentsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListGameServerDeploymentsPagedResponse(ListGameServerDeploymentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListGameServerDeploymentsFixedSizeCollection.createEmptyCollection());
        }
    }
}

