/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1.CreateRealmRequest;
import com.google.cloud.gaming.v1.DeleteRealmRequest;
import com.google.cloud.gaming.v1.GetRealmRequest;
import com.google.cloud.gaming.v1.ListRealmsRequest;
import com.google.cloud.gaming.v1.ListRealmsResponse;
import com.google.cloud.gaming.v1.LocationName;
import com.google.cloud.gaming.v1.OperationMetadata;
import com.google.cloud.gaming.v1.PreviewRealmUpdateRequest;
import com.google.cloud.gaming.v1.PreviewRealmUpdateResponse;
import com.google.cloud.gaming.v1.Realm;
import com.google.cloud.gaming.v1.RealmName;
import com.google.cloud.gaming.v1.RealmsServiceSettings;
import com.google.cloud.gaming.v1.UpdateRealmRequest;
import com.google.cloud.gaming.v1.stub.RealmsServiceStub;
import com.google.cloud.gaming.v1.stub.RealmsServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class RealmsServiceClient
implements BackgroundResource {
    private final RealmsServiceSettings settings;
    private final RealmsServiceStub stub;
    private final OperationsClient operationsClient;

    public static final RealmsServiceClient create() throws IOException {
        return RealmsServiceClient.create(RealmsServiceSettings.newBuilder().build());
    }

    public static final RealmsServiceClient create(RealmsServiceSettings settings) throws IOException {
        return new RealmsServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final RealmsServiceClient create(RealmsServiceStub stub) {
        return new RealmsServiceClient(stub);
    }

    protected RealmsServiceClient(RealmsServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((RealmsServiceStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected RealmsServiceClient(RealmsServiceStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final RealmsServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RealmsServiceStub getStub() {
        return this.stub;
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final ListRealmsPagedResponse listRealms(LocationName parent) {
        ListRealmsRequest request = ListRealmsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listRealms(request);
    }

    public final ListRealmsPagedResponse listRealms(String parent) {
        ListRealmsRequest request = ListRealmsRequest.newBuilder().setParent(parent).build();
        return this.listRealms(request);
    }

    public final ListRealmsPagedResponse listRealms(ListRealmsRequest request) {
        return (ListRealmsPagedResponse)((Object)this.listRealmsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListRealmsRequest, ListRealmsPagedResponse> listRealmsPagedCallable() {
        return this.stub.listRealmsPagedCallable();
    }

    public final UnaryCallable<ListRealmsRequest, ListRealmsResponse> listRealmsCallable() {
        return this.stub.listRealmsCallable();
    }

    public final Realm getRealm(RealmName name) {
        GetRealmRequest request = GetRealmRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getRealm(request);
    }

    public final Realm getRealm(String name) {
        GetRealmRequest request = GetRealmRequest.newBuilder().setName(name).build();
        return this.getRealm(request);
    }

    public final Realm getRealm(GetRealmRequest request) {
        return (Realm)this.getRealmCallable().call((Object)request);
    }

    public final UnaryCallable<GetRealmRequest, Realm> getRealmCallable() {
        return this.stub.getRealmCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, OperationMetadata> createRealmAsync(LocationName parent, Realm realm, String realmId) {
        CreateRealmRequest request = CreateRealmRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setRealm(realm).setRealmId(realmId).build();
        return this.createRealmAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, OperationMetadata> createRealmAsync(String parent, Realm realm, String realmId) {
        CreateRealmRequest request = CreateRealmRequest.newBuilder().setParent(parent).setRealm(realm).setRealmId(realmId).build();
        return this.createRealmAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, OperationMetadata> createRealmAsync(CreateRealmRequest request) {
        return this.createRealmOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationCallable() {
        return this.stub.createRealmOperationCallable();
    }

    public final UnaryCallable<CreateRealmRequest, Operation> createRealmCallable() {
        return this.stub.createRealmCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteRealmAsync(RealmName name) {
        DeleteRealmRequest request = DeleteRealmRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteRealmAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteRealmAsync(String name) {
        DeleteRealmRequest request = DeleteRealmRequest.newBuilder().setName(name).build();
        return this.deleteRealmAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Empty, OperationMetadata> deleteRealmAsync(DeleteRealmRequest request) {
        return this.deleteRealmOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationCallable() {
        return this.stub.deleteRealmOperationCallable();
    }

    public final UnaryCallable<DeleteRealmRequest, Operation> deleteRealmCallable() {
        return this.stub.deleteRealmCallable();
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, OperationMetadata> updateRealmAsync(Realm realm, FieldMask updateMask) {
        UpdateRealmRequest request = UpdateRealmRequest.newBuilder().setRealm(realm).setUpdateMask(updateMask).build();
        return this.updateRealmAsync(request);
    }

    @BetaApi(value="The surface for long-running operations is not stable yet and may change in the future.")
    public final OperationFuture<Realm, OperationMetadata> updateRealmAsync(UpdateRealmRequest request) {
        return this.updateRealmOperationCallable().futureCall((Object)request);
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public final OperationCallable<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationCallable() {
        return this.stub.updateRealmOperationCallable();
    }

    public final UnaryCallable<UpdateRealmRequest, Operation> updateRealmCallable() {
        return this.stub.updateRealmCallable();
    }

    public final PreviewRealmUpdateResponse previewRealmUpdate(PreviewRealmUpdateRequest request) {
        return (PreviewRealmUpdateResponse)this.previewRealmUpdateCallable().call((Object)request);
    }

    public final UnaryCallable<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateCallable() {
        return this.stub.previewRealmUpdateCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListRealmsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListRealmsRequest, ListRealmsResponse, Realm, ListRealmsPage, ListRealmsFixedSizeCollection> {
        private ListRealmsFixedSizeCollection(List<ListRealmsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListRealmsFixedSizeCollection createEmptyCollection() {
            return new ListRealmsFixedSizeCollection(null, 0);
        }

        protected ListRealmsFixedSizeCollection createCollection(List<ListRealmsPage> pages, int collectionSize) {
            return new ListRealmsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListRealmsPage
    extends AbstractPage<ListRealmsRequest, ListRealmsResponse, Realm, ListRealmsPage> {
        private ListRealmsPage(PageContext<ListRealmsRequest, ListRealmsResponse, Realm> context, ListRealmsResponse response) {
            super(context, (Object)response);
        }

        private static ListRealmsPage createEmptyPage() {
            return new ListRealmsPage(null, null);
        }

        protected ListRealmsPage createPage(PageContext<ListRealmsRequest, ListRealmsResponse, Realm> context, ListRealmsResponse response) {
            return new ListRealmsPage(context, response);
        }

        public ApiFuture<ListRealmsPage> createPageAsync(PageContext<ListRealmsRequest, ListRealmsResponse, Realm> context, ApiFuture<ListRealmsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListRealmsPagedResponse
    extends AbstractPagedListResponse<ListRealmsRequest, ListRealmsResponse, Realm, ListRealmsPage, ListRealmsFixedSizeCollection> {
        public static ApiFuture<ListRealmsPagedResponse> createAsync(PageContext<ListRealmsRequest, ListRealmsResponse, Realm> context, ApiFuture<ListRealmsResponse> futureResponse) {
            ApiFuture<ListRealmsPage> futurePage = ListRealmsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, (ApiFunction)new ApiFunction<ListRealmsPage, ListRealmsPagedResponse>(){

                public ListRealmsPagedResponse apply(ListRealmsPage input) {
                    return new ListRealmsPagedResponse(input);
                }
            }, (Executor)MoreExecutors.directExecutor());
        }

        private ListRealmsPagedResponse(ListRealmsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListRealmsFixedSizeCollection.createEmptyCollection());
        }
    }
}

