/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1.CreateGameServerClusterRequest;
import com.google.cloud.gaming.v1.DeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1.GameServerCluster;
import com.google.cloud.gaming.v1.GameServerClustersServiceClient;
import com.google.cloud.gaming.v1.GetGameServerClusterRequest;
import com.google.cloud.gaming.v1.ListGameServerClustersRequest;
import com.google.cloud.gaming.v1.ListGameServerClustersResponse;
import com.google.cloud.gaming.v1.OperationMetadata;
import com.google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewCreateGameServerClusterResponse;
import com.google.cloud.gaming.v1.PreviewDeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewDeleteGameServerClusterResponse;
import com.google.cloud.gaming.v1.PreviewUpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewUpdateGameServerClusterResponse;
import com.google.cloud.gaming.v1.UpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1.stub.GameServerClustersServiceStub;
import com.google.cloud.gaming.v1.stub.GrpcGameServerClustersServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GameServerClustersServiceStubSettings
extends StubSettings<GameServerClustersServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> listGameServerClustersSettings;
    private final UnaryCallSettings<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterSettings;
    private final UnaryCallSettings<CreateGameServerClusterRequest, Operation> createGameServerClusterSettings;
    private final OperationCallSettings<CreateGameServerClusterRequest, GameServerCluster, OperationMetadata> createGameServerClusterOperationSettings;
    private final UnaryCallSettings<PreviewCreateGameServerClusterRequest, PreviewCreateGameServerClusterResponse> previewCreateGameServerClusterSettings;
    private final UnaryCallSettings<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterSettings;
    private final OperationCallSettings<DeleteGameServerClusterRequest, Empty, OperationMetadata> deleteGameServerClusterOperationSettings;
    private final UnaryCallSettings<PreviewDeleteGameServerClusterRequest, PreviewDeleteGameServerClusterResponse> previewDeleteGameServerClusterSettings;
    private final UnaryCallSettings<UpdateGameServerClusterRequest, Operation> updateGameServerClusterSettings;
    private final OperationCallSettings<UpdateGameServerClusterRequest, GameServerCluster, OperationMetadata> updateGameServerClusterOperationSettings;
    private final UnaryCallSettings<PreviewUpdateGameServerClusterRequest, PreviewUpdateGameServerClusterResponse> previewUpdateGameServerClusterSettings;
    private static final PagedListDescriptor<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster> LIST_GAME_SERVER_CLUSTERS_PAGE_STR_DESC = new PagedListDescriptor<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster>(){

        public String emptyToken() {
            return "";
        }

        public ListGameServerClustersRequest injectToken(ListGameServerClustersRequest payload, String token) {
            return ListGameServerClustersRequest.newBuilder((ListGameServerClustersRequest)payload).setPageToken(token).build();
        }

        public ListGameServerClustersRequest injectPageSize(ListGameServerClustersRequest payload, int pageSize) {
            return ListGameServerClustersRequest.newBuilder((ListGameServerClustersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGameServerClustersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGameServerClustersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GameServerCluster> extractResources(ListGameServerClustersResponse payload) {
            return payload.getGameServerClustersList() != null ? payload.getGameServerClustersList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> LIST_GAME_SERVER_CLUSTERS_PAGE_STR_FACT = new PagedListResponseFactory<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse>(){

        public ApiFuture<GameServerClustersServiceClient.ListGameServerClustersPagedResponse> getFuturePagedResponse(UnaryCallable<ListGameServerClustersRequest, ListGameServerClustersResponse> callable, ListGameServerClustersRequest request, ApiCallContext context, ApiFuture<ListGameServerClustersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GAME_SERVER_CLUSTERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GameServerClustersServiceClient.ListGameServerClustersPagedResponse.createAsync((PageContext<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerCluster>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> listGameServerClustersSettings() {
        return this.listGameServerClustersSettings;
    }

    public UnaryCallSettings<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterSettings() {
        return this.getGameServerClusterSettings;
    }

    public UnaryCallSettings<CreateGameServerClusterRequest, Operation> createGameServerClusterSettings() {
        return this.createGameServerClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateGameServerClusterRequest, GameServerCluster, OperationMetadata> createGameServerClusterOperationSettings() {
        return this.createGameServerClusterOperationSettings;
    }

    public UnaryCallSettings<PreviewCreateGameServerClusterRequest, PreviewCreateGameServerClusterResponse> previewCreateGameServerClusterSettings() {
        return this.previewCreateGameServerClusterSettings;
    }

    public UnaryCallSettings<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterSettings() {
        return this.deleteGameServerClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DeleteGameServerClusterRequest, Empty, OperationMetadata> deleteGameServerClusterOperationSettings() {
        return this.deleteGameServerClusterOperationSettings;
    }

    public UnaryCallSettings<PreviewDeleteGameServerClusterRequest, PreviewDeleteGameServerClusterResponse> previewDeleteGameServerClusterSettings() {
        return this.previewDeleteGameServerClusterSettings;
    }

    public UnaryCallSettings<UpdateGameServerClusterRequest, Operation> updateGameServerClusterSettings() {
        return this.updateGameServerClusterSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<UpdateGameServerClusterRequest, GameServerCluster, OperationMetadata> updateGameServerClusterOperationSettings() {
        return this.updateGameServerClusterOperationSettings;
    }

    public UnaryCallSettings<PreviewUpdateGameServerClusterRequest, PreviewUpdateGameServerClusterResponse> previewUpdateGameServerClusterSettings() {
        return this.previewUpdateGameServerClusterSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GameServerClustersServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGameServerClustersServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gameservices.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GameServerClustersServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GameServerClustersServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GameServerClustersServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listGameServerClustersSettings = settingsBuilder.listGameServerClustersSettings().build();
        this.getGameServerClusterSettings = settingsBuilder.getGameServerClusterSettings().build();
        this.createGameServerClusterSettings = settingsBuilder.createGameServerClusterSettings().build();
        this.createGameServerClusterOperationSettings = settingsBuilder.createGameServerClusterOperationSettings().build();
        this.previewCreateGameServerClusterSettings = settingsBuilder.previewCreateGameServerClusterSettings().build();
        this.deleteGameServerClusterSettings = settingsBuilder.deleteGameServerClusterSettings().build();
        this.deleteGameServerClusterOperationSettings = settingsBuilder.deleteGameServerClusterOperationSettings().build();
        this.previewDeleteGameServerClusterSettings = settingsBuilder.previewDeleteGameServerClusterSettings().build();
        this.updateGameServerClusterSettings = settingsBuilder.updateGameServerClusterSettings().build();
        this.updateGameServerClusterOperationSettings = settingsBuilder.updateGameServerClusterOperationSettings().build();
        this.previewUpdateGameServerClusterSettings = settingsBuilder.previewUpdateGameServerClusterSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GameServerClustersServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> listGameServerClustersSettings;
        private final UnaryCallSettings.Builder<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterSettings;
        private final UnaryCallSettings.Builder<CreateGameServerClusterRequest, Operation> createGameServerClusterSettings;
        private final OperationCallSettings.Builder<CreateGameServerClusterRequest, GameServerCluster, OperationMetadata> createGameServerClusterOperationSettings;
        private final UnaryCallSettings.Builder<PreviewCreateGameServerClusterRequest, PreviewCreateGameServerClusterResponse> previewCreateGameServerClusterSettings;
        private final UnaryCallSettings.Builder<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterSettings;
        private final OperationCallSettings.Builder<DeleteGameServerClusterRequest, Empty, OperationMetadata> deleteGameServerClusterOperationSettings;
        private final UnaryCallSettings.Builder<PreviewDeleteGameServerClusterRequest, PreviewDeleteGameServerClusterResponse> previewDeleteGameServerClusterSettings;
        private final UnaryCallSettings.Builder<UpdateGameServerClusterRequest, Operation> updateGameServerClusterSettings;
        private final OperationCallSettings.Builder<UpdateGameServerClusterRequest, GameServerCluster, OperationMetadata> updateGameServerClusterOperationSettings;
        private final UnaryCallSettings.Builder<PreviewUpdateGameServerClusterRequest, PreviewUpdateGameServerClusterResponse> previewUpdateGameServerClusterSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGameServerClustersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GAME_SERVER_CLUSTERS_PAGE_STR_FACT);
            this.getGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGameServerClusterOperationSettings = OperationCallSettings.newBuilder();
            this.previewCreateGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGameServerClusterOperationSettings = OperationCallSettings.newBuilder();
            this.previewDeleteGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateGameServerClusterOperationSettings = OperationCallSettings.newBuilder();
            this.previewUpdateGameServerClusterSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGameServerClustersSettings, this.getGameServerClusterSettings, this.createGameServerClusterSettings, this.previewCreateGameServerClusterSettings, this.deleteGameServerClusterSettings, this.previewDeleteGameServerClusterSettings, this.updateGameServerClusterSettings, this.previewUpdateGameServerClusterSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GameServerClustersServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GameServerClustersServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GameServerClustersServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GameServerClustersServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listGameServerClustersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.previewCreateGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.deleteGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.previewDeleteGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.previewUpdateGameServerClusterSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createGameServerClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GameServerCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGameServerClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateGameServerClusterOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GameServerCluster.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(GameServerClustersServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listGameServerClustersSettings = settings.listGameServerClustersSettings.toBuilder();
            this.getGameServerClusterSettings = settings.getGameServerClusterSettings.toBuilder();
            this.createGameServerClusterSettings = settings.createGameServerClusterSettings.toBuilder();
            this.createGameServerClusterOperationSettings = settings.createGameServerClusterOperationSettings.toBuilder();
            this.previewCreateGameServerClusterSettings = settings.previewCreateGameServerClusterSettings.toBuilder();
            this.deleteGameServerClusterSettings = settings.deleteGameServerClusterSettings.toBuilder();
            this.deleteGameServerClusterOperationSettings = settings.deleteGameServerClusterOperationSettings.toBuilder();
            this.previewDeleteGameServerClusterSettings = settings.previewDeleteGameServerClusterSettings.toBuilder();
            this.updateGameServerClusterSettings = settings.updateGameServerClusterSettings.toBuilder();
            this.updateGameServerClusterOperationSettings = settings.updateGameServerClusterOperationSettings.toBuilder();
            this.previewUpdateGameServerClusterSettings = settings.previewUpdateGameServerClusterSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGameServerClustersSettings, this.getGameServerClusterSettings, this.createGameServerClusterSettings, this.previewCreateGameServerClusterSettings, this.deleteGameServerClusterSettings, this.previewDeleteGameServerClusterSettings, this.updateGameServerClusterSettings, this.previewUpdateGameServerClusterSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListGameServerClustersRequest, ListGameServerClustersResponse, GameServerClustersServiceClient.ListGameServerClustersPagedResponse> listGameServerClustersSettings() {
            return this.listGameServerClustersSettings;
        }

        public UnaryCallSettings.Builder<GetGameServerClusterRequest, GameServerCluster> getGameServerClusterSettings() {
            return this.getGameServerClusterSettings;
        }

        public UnaryCallSettings.Builder<CreateGameServerClusterRequest, Operation> createGameServerClusterSettings() {
            return this.createGameServerClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateGameServerClusterRequest, GameServerCluster, OperationMetadata> createGameServerClusterOperationSettings() {
            return this.createGameServerClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<PreviewCreateGameServerClusterRequest, PreviewCreateGameServerClusterResponse> previewCreateGameServerClusterSettings() {
            return this.previewCreateGameServerClusterSettings;
        }

        public UnaryCallSettings.Builder<DeleteGameServerClusterRequest, Operation> deleteGameServerClusterSettings() {
            return this.deleteGameServerClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteGameServerClusterRequest, Empty, OperationMetadata> deleteGameServerClusterOperationSettings() {
            return this.deleteGameServerClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<PreviewDeleteGameServerClusterRequest, PreviewDeleteGameServerClusterResponse> previewDeleteGameServerClusterSettings() {
            return this.previewDeleteGameServerClusterSettings;
        }

        public UnaryCallSettings.Builder<UpdateGameServerClusterRequest, Operation> updateGameServerClusterSettings() {
            return this.updateGameServerClusterSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateGameServerClusterRequest, GameServerCluster, OperationMetadata> updateGameServerClusterOperationSettings() {
            return this.updateGameServerClusterOperationSettings;
        }

        public UnaryCallSettings.Builder<PreviewUpdateGameServerClusterRequest, PreviewUpdateGameServerClusterResponse> previewUpdateGameServerClusterSettings() {
            return this.previewUpdateGameServerClusterSettings;
        }

        public GameServerClustersServiceStubSettings build() throws IOException {
            return new GameServerClustersServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

