/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1.CreateGameServerConfigRequest;
import com.google.cloud.gaming.v1.DeleteGameServerConfigRequest;
import com.google.cloud.gaming.v1.GameServerConfig;
import com.google.cloud.gaming.v1.GameServerConfigsServiceClient;
import com.google.cloud.gaming.v1.GetGameServerConfigRequest;
import com.google.cloud.gaming.v1.ListGameServerConfigsRequest;
import com.google.cloud.gaming.v1.ListGameServerConfigsResponse;
import com.google.cloud.gaming.v1.OperationMetadata;
import com.google.cloud.gaming.v1.stub.GameServerConfigsServiceStub;
import com.google.cloud.gaming.v1.stub.GrpcGameServerConfigsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GameServerConfigsServiceStubSettings
extends StubSettings<GameServerConfigsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> listGameServerConfigsSettings;
    private final UnaryCallSettings<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigSettings;
    private final UnaryCallSettings<CreateGameServerConfigRequest, Operation> createGameServerConfigSettings;
    private final OperationCallSettings<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationSettings;
    private final UnaryCallSettings<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigSettings;
    private final OperationCallSettings<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationSettings;
    private static final PagedListDescriptor<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig> LIST_GAME_SERVER_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListGameServerConfigsRequest injectToken(ListGameServerConfigsRequest payload, String token) {
            return ListGameServerConfigsRequest.newBuilder((ListGameServerConfigsRequest)payload).setPageToken(token).build();
        }

        public ListGameServerConfigsRequest injectPageSize(ListGameServerConfigsRequest payload, int pageSize) {
            return ListGameServerConfigsRequest.newBuilder((ListGameServerConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListGameServerConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListGameServerConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<GameServerConfig> extractResources(ListGameServerConfigsResponse payload) {
            return payload.getGameServerConfigsList() != null ? payload.getGameServerConfigsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> LIST_GAME_SERVER_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse>(){

        public ApiFuture<GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGameServerConfigsRequest, ListGameServerConfigsResponse> callable, ListGameServerConfigsRequest request, ApiCallContext context, ApiFuture<ListGameServerConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GAME_SERVER_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse.createAsync((PageContext<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfig>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> listGameServerConfigsSettings() {
        return this.listGameServerConfigsSettings;
    }

    public UnaryCallSettings<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigSettings() {
        return this.getGameServerConfigSettings;
    }

    public UnaryCallSettings<CreateGameServerConfigRequest, Operation> createGameServerConfigSettings() {
        return this.createGameServerConfigSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationSettings() {
        return this.createGameServerConfigOperationSettings;
    }

    public UnaryCallSettings<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigSettings() {
        return this.deleteGameServerConfigSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationSettings() {
        return this.deleteGameServerConfigOperationSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GameServerConfigsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcGameServerConfigsServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gameservices.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GameServerConfigsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GameServerConfigsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GameServerConfigsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listGameServerConfigsSettings = settingsBuilder.listGameServerConfigsSettings().build();
        this.getGameServerConfigSettings = settingsBuilder.getGameServerConfigSettings().build();
        this.createGameServerConfigSettings = settingsBuilder.createGameServerConfigSettings().build();
        this.createGameServerConfigOperationSettings = settingsBuilder.createGameServerConfigOperationSettings().build();
        this.deleteGameServerConfigSettings = settingsBuilder.deleteGameServerConfigSettings().build();
        this.deleteGameServerConfigOperationSettings = settingsBuilder.deleteGameServerConfigOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GameServerConfigsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> listGameServerConfigsSettings;
        private final UnaryCallSettings.Builder<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigSettings;
        private final UnaryCallSettings.Builder<CreateGameServerConfigRequest, Operation> createGameServerConfigSettings;
        private final OperationCallSettings.Builder<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationSettings;
        private final UnaryCallSettings.Builder<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigSettings;
        private final OperationCallSettings.Builder<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listGameServerConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GAME_SERVER_CONFIGS_PAGE_STR_FACT);
            this.getGameServerConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGameServerConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createGameServerConfigOperationSettings = OperationCallSettings.newBuilder();
            this.deleteGameServerConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteGameServerConfigOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGameServerConfigsSettings, this.getGameServerConfigSettings, this.createGameServerConfigSettings, this.deleteGameServerConfigSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GameServerConfigsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GameServerConfigsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GameServerConfigsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GameServerConfigsServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listGameServerConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getGameServerConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createGameServerConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteGameServerConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createGameServerConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(GameServerConfig.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteGameServerConfigOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(GameServerConfigsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listGameServerConfigsSettings = settings.listGameServerConfigsSettings.toBuilder();
            this.getGameServerConfigSettings = settings.getGameServerConfigSettings.toBuilder();
            this.createGameServerConfigSettings = settings.createGameServerConfigSettings.toBuilder();
            this.createGameServerConfigOperationSettings = settings.createGameServerConfigOperationSettings.toBuilder();
            this.deleteGameServerConfigSettings = settings.deleteGameServerConfigSettings.toBuilder();
            this.deleteGameServerConfigOperationSettings = settings.deleteGameServerConfigOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listGameServerConfigsSettings, this.getGameServerConfigSettings, this.createGameServerConfigSettings, this.deleteGameServerConfigSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListGameServerConfigsRequest, ListGameServerConfigsResponse, GameServerConfigsServiceClient.ListGameServerConfigsPagedResponse> listGameServerConfigsSettings() {
            return this.listGameServerConfigsSettings;
        }

        public UnaryCallSettings.Builder<GetGameServerConfigRequest, GameServerConfig> getGameServerConfigSettings() {
            return this.getGameServerConfigSettings;
        }

        public UnaryCallSettings.Builder<CreateGameServerConfigRequest, Operation> createGameServerConfigSettings() {
            return this.createGameServerConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateGameServerConfigRequest, GameServerConfig, OperationMetadata> createGameServerConfigOperationSettings() {
            return this.createGameServerConfigOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteGameServerConfigRequest, Operation> deleteGameServerConfigSettings() {
            return this.deleteGameServerConfigSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteGameServerConfigRequest, Empty, OperationMetadata> deleteGameServerConfigOperationSettings() {
            return this.deleteGameServerConfigOperationSettings;
        }

        public GameServerConfigsServiceStubSettings build() throws IOException {
            return new GameServerConfigsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

