/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.gaming.v1.CreateRealmRequest;
import com.google.cloud.gaming.v1.DeleteRealmRequest;
import com.google.cloud.gaming.v1.GetRealmRequest;
import com.google.cloud.gaming.v1.ListRealmsRequest;
import com.google.cloud.gaming.v1.ListRealmsResponse;
import com.google.cloud.gaming.v1.OperationMetadata;
import com.google.cloud.gaming.v1.PreviewRealmUpdateRequest;
import com.google.cloud.gaming.v1.PreviewRealmUpdateResponse;
import com.google.cloud.gaming.v1.Realm;
import com.google.cloud.gaming.v1.RealmsServiceClient;
import com.google.cloud.gaming.v1.UpdateRealmRequest;
import com.google.cloud.gaming.v1.stub.GrpcRealmsServiceStub;
import com.google.cloud.gaming.v1.stub.RealmsServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class RealmsServiceStubSettings
extends StubSettings<RealmsServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListRealmsRequest, ListRealmsResponse, RealmsServiceClient.ListRealmsPagedResponse> listRealmsSettings;
    private final UnaryCallSettings<GetRealmRequest, Realm> getRealmSettings;
    private final UnaryCallSettings<CreateRealmRequest, Operation> createRealmSettings;
    private final OperationCallSettings<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationSettings;
    private final UnaryCallSettings<DeleteRealmRequest, Operation> deleteRealmSettings;
    private final OperationCallSettings<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationSettings;
    private final UnaryCallSettings<UpdateRealmRequest, Operation> updateRealmSettings;
    private final OperationCallSettings<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationSettings;
    private final UnaryCallSettings<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateSettings;
    private static final PagedListDescriptor<ListRealmsRequest, ListRealmsResponse, Realm> LIST_REALMS_PAGE_STR_DESC = new PagedListDescriptor<ListRealmsRequest, ListRealmsResponse, Realm>(){

        public String emptyToken() {
            return "";
        }

        public ListRealmsRequest injectToken(ListRealmsRequest payload, String token) {
            return ListRealmsRequest.newBuilder((ListRealmsRequest)payload).setPageToken(token).build();
        }

        public ListRealmsRequest injectPageSize(ListRealmsRequest payload, int pageSize) {
            return ListRealmsRequest.newBuilder((ListRealmsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRealmsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRealmsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Realm> extractResources(ListRealmsResponse payload) {
            return payload.getRealmsList() != null ? payload.getRealmsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<ListRealmsRequest, ListRealmsResponse, RealmsServiceClient.ListRealmsPagedResponse> LIST_REALMS_PAGE_STR_FACT = new PagedListResponseFactory<ListRealmsRequest, ListRealmsResponse, RealmsServiceClient.ListRealmsPagedResponse>(){

        public ApiFuture<RealmsServiceClient.ListRealmsPagedResponse> getFuturePagedResponse(UnaryCallable<ListRealmsRequest, ListRealmsResponse> callable, ListRealmsRequest request, ApiCallContext context, ApiFuture<ListRealmsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REALMS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RealmsServiceClient.ListRealmsPagedResponse.createAsync((PageContext<ListRealmsRequest, ListRealmsResponse, Realm>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListRealmsRequest, ListRealmsResponse, RealmsServiceClient.ListRealmsPagedResponse> listRealmsSettings() {
        return this.listRealmsSettings;
    }

    public UnaryCallSettings<GetRealmRequest, Realm> getRealmSettings() {
        return this.getRealmSettings;
    }

    public UnaryCallSettings<CreateRealmRequest, Operation> createRealmSettings() {
        return this.createRealmSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationSettings() {
        return this.createRealmOperationSettings;
    }

    public UnaryCallSettings<DeleteRealmRequest, Operation> deleteRealmSettings() {
        return this.deleteRealmSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationSettings() {
        return this.deleteRealmOperationSettings;
    }

    public UnaryCallSettings<UpdateRealmRequest, Operation> updateRealmSettings() {
        return this.updateRealmSettings;
    }

    @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
    public OperationCallSettings<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationSettings() {
        return this.updateRealmOperationSettings;
    }

    public UnaryCallSettings<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateSettings() {
        return this.previewRealmUpdateSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public RealmsServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRealmsServiceStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "gameservices.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RealmsServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RealmsServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RealmsServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listRealmsSettings = settingsBuilder.listRealmsSettings().build();
        this.getRealmSettings = settingsBuilder.getRealmSettings().build();
        this.createRealmSettings = settingsBuilder.createRealmSettings().build();
        this.createRealmOperationSettings = settingsBuilder.createRealmOperationSettings().build();
        this.deleteRealmSettings = settingsBuilder.deleteRealmSettings().build();
        this.deleteRealmOperationSettings = settingsBuilder.deleteRealmOperationSettings().build();
        this.updateRealmSettings = settingsBuilder.updateRealmSettings().build();
        this.updateRealmOperationSettings = settingsBuilder.updateRealmOperationSettings().build();
        this.previewRealmUpdateSettings = settingsBuilder.previewRealmUpdateSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RealmsServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListRealmsRequest, ListRealmsResponse, RealmsServiceClient.ListRealmsPagedResponse> listRealmsSettings;
        private final UnaryCallSettings.Builder<GetRealmRequest, Realm> getRealmSettings;
        private final UnaryCallSettings.Builder<CreateRealmRequest, Operation> createRealmSettings;
        private final OperationCallSettings.Builder<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationSettings;
        private final UnaryCallSettings.Builder<DeleteRealmRequest, Operation> deleteRealmSettings;
        private final OperationCallSettings.Builder<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationSettings;
        private final UnaryCallSettings.Builder<UpdateRealmRequest, Operation> updateRealmSettings;
        private final OperationCallSettings.Builder<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationSettings;
        private final UnaryCallSettings.Builder<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listRealmsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REALMS_PAGE_STR_FACT);
            this.getRealmSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRealmSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRealmOperationSettings = OperationCallSettings.newBuilder();
            this.deleteRealmSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRealmOperationSettings = OperationCallSettings.newBuilder();
            this.updateRealmSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateRealmOperationSettings = OperationCallSettings.newBuilder();
            this.previewRealmUpdateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listRealmsSettings, this.getRealmSettings, this.createRealmSettings, this.deleteRealmSettings, this.updateRealmSettings, this.previewRealmUpdateSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RealmsServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RealmsServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RealmsServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(RealmsServiceStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listRealmsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getRealmSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createRealmSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteRealmSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateRealmSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.previewRealmUpdateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.createRealmOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Realm.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRealmOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateRealmOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Realm.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)500L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)5000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        protected Builder(RealmsServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listRealmsSettings = settings.listRealmsSettings.toBuilder();
            this.getRealmSettings = settings.getRealmSettings.toBuilder();
            this.createRealmSettings = settings.createRealmSettings.toBuilder();
            this.createRealmOperationSettings = settings.createRealmOperationSettings.toBuilder();
            this.deleteRealmSettings = settings.deleteRealmSettings.toBuilder();
            this.deleteRealmOperationSettings = settings.deleteRealmOperationSettings.toBuilder();
            this.updateRealmSettings = settings.updateRealmSettings.toBuilder();
            this.updateRealmOperationSettings = settings.updateRealmOperationSettings.toBuilder();
            this.previewRealmUpdateSettings = settings.previewRealmUpdateSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listRealmsSettings, this.getRealmSettings, this.createRealmSettings, this.deleteRealmSettings, this.updateRealmSettings, this.previewRealmUpdateSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListRealmsRequest, ListRealmsResponse, RealmsServiceClient.ListRealmsPagedResponse> listRealmsSettings() {
            return this.listRealmsSettings;
        }

        public UnaryCallSettings.Builder<GetRealmRequest, Realm> getRealmSettings() {
            return this.getRealmSettings;
        }

        public UnaryCallSettings.Builder<CreateRealmRequest, Operation> createRealmSettings() {
            return this.createRealmSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateRealmRequest, Realm, OperationMetadata> createRealmOperationSettings() {
            return this.createRealmOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteRealmRequest, Operation> deleteRealmSettings() {
            return this.deleteRealmSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteRealmRequest, Empty, OperationMetadata> deleteRealmOperationSettings() {
            return this.deleteRealmOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateRealmRequest, Operation> updateRealmSettings() {
            return this.updateRealmSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateRealmRequest, Realm, OperationMetadata> updateRealmOperationSettings() {
            return this.updateRealmOperationSettings;
        }

        public UnaryCallSettings.Builder<PreviewRealmUpdateRequest, PreviewRealmUpdateResponse> previewRealmUpdateSettings() {
            return this.previewRealmUpdateSettings;
        }

        public RealmsServiceStubSettings build() throws IOException {
            return new RealmsServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)120000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)120000L)).setTotalTimeout(Duration.ofMillis((long)120000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

