/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.gaming.v1.CreateGameServerClusterRequest;
import com.google.cloud.gaming.v1.DeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1.GameServerCluster;
import com.google.cloud.gaming.v1.GameServerClusterConnectionInfo;
import com.google.cloud.gaming.v1.GameServerClusterName;
import com.google.cloud.gaming.v1.GameServerClustersServiceClient;
import com.google.cloud.gaming.v1.GameServerClustersServiceSettings;
import com.google.cloud.gaming.v1.GetGameServerClusterRequest;
import com.google.cloud.gaming.v1.ListGameServerClustersRequest;
import com.google.cloud.gaming.v1.ListGameServerClustersResponse;
import com.google.cloud.gaming.v1.MockGameServerClustersService;
import com.google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewCreateGameServerClusterResponse;
import com.google.cloud.gaming.v1.PreviewDeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewDeleteGameServerClusterResponse;
import com.google.cloud.gaming.v1.PreviewUpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewUpdateGameServerClusterResponse;
import com.google.cloud.gaming.v1.RealmName;
import com.google.cloud.gaming.v1.TargetState;
import com.google.cloud.gaming.v1.UpdateGameServerClusterRequest;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerClustersServiceClientTest {
    private static MockServiceHelper mockServiceHelper;
    private GameServerClustersServiceClient client;
    private static MockGameServerClustersService mockGameServerClustersService;
    private LocalChannelProvider channelProvider;

    @BeforeClass
    public static void startStaticServer() {
        mockGameServerClustersService = new MockGameServerClustersService();
        mockServiceHelper = new MockServiceHelper(UUID.randomUUID().toString(), Arrays.asList(mockGameServerClustersService));
        mockServiceHelper.start();
    }

    @AfterClass
    public static void stopServer() {
        mockServiceHelper.stop();
    }

    @Before
    public void setUp() throws IOException {
        mockServiceHelper.reset();
        this.channelProvider = mockServiceHelper.createChannelProvider();
        GameServerClustersServiceSettings settings = ((GameServerClustersServiceSettings.Builder)((GameServerClustersServiceSettings.Builder)GameServerClustersServiceSettings.newBuilder().setTransportChannelProvider((TransportChannelProvider)this.channelProvider)).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        this.client = GameServerClustersServiceClient.create((GameServerClustersServiceSettings)settings);
    }

    @After
    public void tearDown() throws Exception {
        this.client.close();
    }

    @Test
    public void listGameServerClustersTest() throws Exception {
        GameServerCluster responsesElement = GameServerCluster.newBuilder().build();
        ListGameServerClustersResponse expectedResponse = ListGameServerClustersResponse.newBuilder().setNextPageToken("").addAllGameServerClusters(Arrays.asList(responsesElement)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        GameServerClustersServiceClient.ListGameServerClustersPagedResponse pagedListResponse = this.client.listGameServerClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerClustersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerClustersRequest actualRequest = (ListGameServerClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerClustersExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            this.client.listGameServerClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGameServerClustersTest2() throws Exception {
        GameServerCluster responsesElement = GameServerCluster.newBuilder().build();
        ListGameServerClustersResponse expectedResponse = ListGameServerClustersResponse.newBuilder().setNextPageToken("").addAllGameServerClusters(Arrays.asList(responsesElement)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        String parent = "parent-995424086";
        GameServerClustersServiceClient.ListGameServerClustersPagedResponse pagedListResponse = this.client.listGameServerClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerClustersList().get(0), resources.get(0));
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        ListGameServerClustersRequest actualRequest = (ListGameServerClustersRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void listGameServerClustersExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            this.client.listGameServerClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerClusterTest() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        GameServerCluster actualResponse = this.client.getGameServerCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerClusterRequest actualRequest = (GetGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
            this.client.getGameServerCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerClusterTest2() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        String name = "name3373707";
        GameServerCluster actualResponse = this.client.getGameServerCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        GetGameServerClusterRequest actualRequest = (GetGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void getGameServerClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.getGameServerCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerClusterTest() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        String gameServerClusterId = "gameServerClusterId-1301104032";
        GameServerCluster actualResponse = (GameServerCluster)this.client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerClusterRequest actualRequest = (CreateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent.toString(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)gameServerClusterId, (Object)actualRequest.getGameServerClusterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            String gameServerClusterId = "gameServerClusterId-1301104032";
            this.client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void createGameServerClusterTest2() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        String parent = "parent-995424086";
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        String gameServerClusterId = "gameServerClusterId-1301104032";
        GameServerCluster actualResponse = (GameServerCluster)this.client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        CreateGameServerClusterRequest actualRequest = (CreateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)parent, (Object)actualRequest.getParent());
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)gameServerClusterId, (Object)actualRequest.getGameServerClusterId());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void createGameServerClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            String parent = "parent-995424086";
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            String gameServerClusterId = "gameServerClusterId-1301104032";
            this.client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewCreateGameServerClusterTest() throws Exception {
        PreviewCreateGameServerClusterResponse expectedResponse = PreviewCreateGameServerClusterResponse.newBuilder().setEtag("etag3123477").setTargetState(TargetState.newBuilder().build()).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        PreviewCreateGameServerClusterRequest request = PreviewCreateGameServerClusterRequest.newBuilder().setParent(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setGameServerClusterId("gameServerClusterId-1301104032").setGameServerCluster(GameServerCluster.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
        PreviewCreateGameServerClusterResponse actualResponse = this.client.previewCreateGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewCreateGameServerClusterRequest actualRequest = (PreviewCreateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getParent(), (Object)actualRequest.getParent());
        Assert.assertEquals((Object)request.getGameServerClusterId(), (Object)actualRequest.getGameServerClusterId());
        Assert.assertEquals((Object)request.getGameServerCluster(), (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)request.getPreviewTime(), (Object)actualRequest.getPreviewTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewCreateGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            PreviewCreateGameServerClusterRequest request = PreviewCreateGameServerClusterRequest.newBuilder().setParent(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setGameServerClusterId("gameServerClusterId-1301104032").setGameServerCluster(GameServerCluster.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
            this.client.previewCreateGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGameServerClusterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        this.client.deleteGameServerClusterAsync(name).get();
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerClusterRequest actualRequest = (DeleteGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name.toString(), (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
            this.client.deleteGameServerClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void deleteGameServerClusterTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        String name = "name3373707";
        this.client.deleteGameServerClusterAsync(name).get();
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        DeleteGameServerClusterRequest actualRequest = (DeleteGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)name, (Object)actualRequest.getName());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void deleteGameServerClusterExceptionTest2() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            String name = "name3373707";
            this.client.deleteGameServerClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewDeleteGameServerClusterTest() throws Exception {
        PreviewDeleteGameServerClusterResponse expectedResponse = PreviewDeleteGameServerClusterResponse.newBuilder().setEtag("etag3123477").setTargetState(TargetState.newBuilder().build()).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        PreviewDeleteGameServerClusterRequest request = PreviewDeleteGameServerClusterRequest.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setPreviewTime(Timestamp.newBuilder().build()).build();
        PreviewDeleteGameServerClusterResponse actualResponse = this.client.previewDeleteGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewDeleteGameServerClusterRequest actualRequest = (PreviewDeleteGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getName(), (Object)actualRequest.getName());
        Assert.assertEquals((Object)request.getPreviewTime(), (Object)actualRequest.getPreviewTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewDeleteGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            PreviewDeleteGameServerClusterRequest request = PreviewDeleteGameServerClusterRequest.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setPreviewTime(Timestamp.newBuilder().build()).build();
            this.client.previewDeleteGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateGameServerClusterTest() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockGameServerClustersService.addResponse((AbstractMessage)resultOperation);
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerCluster actualResponse = (GameServerCluster)this.client.updateGameServerClusterAsync(gameServerCluster, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        UpdateGameServerClusterRequest actualRequest = (UpdateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)gameServerCluster, (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)updateMask, (Object)actualRequest.getUpdateMask());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void updateGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            this.client.updateGameServerClusterAsync(gameServerCluster, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException e) {
            Assert.assertEquals(InvalidArgumentException.class, e.getCause().getClass());
            InvalidArgumentException apiException = (InvalidArgumentException)e.getCause();
            Assert.assertEquals((Object)StatusCode.Code.INVALID_ARGUMENT, (Object)apiException.getStatusCode().getCode());
        }
    }

    @Test
    public void previewUpdateGameServerClusterTest() throws Exception {
        PreviewUpdateGameServerClusterResponse expectedResponse = PreviewUpdateGameServerClusterResponse.newBuilder().setEtag("etag3123477").setTargetState(TargetState.newBuilder().build()).build();
        mockGameServerClustersService.addResponse((AbstractMessage)expectedResponse);
        PreviewUpdateGameServerClusterRequest request = PreviewUpdateGameServerClusterRequest.newBuilder().setGameServerCluster(GameServerCluster.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
        PreviewUpdateGameServerClusterResponse actualResponse = this.client.previewUpdateGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List<AbstractMessage> actualRequests = mockGameServerClustersService.getRequests();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        PreviewUpdateGameServerClusterRequest actualRequest = (PreviewUpdateGameServerClusterRequest)actualRequests.get(0);
        Assert.assertEquals((Object)request.getGameServerCluster(), (Object)actualRequest.getGameServerCluster());
        Assert.assertEquals((Object)request.getUpdateMask(), (Object)actualRequest.getUpdateMask());
        Assert.assertEquals((Object)request.getPreviewTime(), (Object)actualRequest.getPreviewTime());
        Assert.assertTrue((boolean)this.channelProvider.isHeaderSent(ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), GaxGrpcProperties.getDefaultApiClientHeaderPattern()));
    }

    @Test
    public void previewUpdateGameServerClusterExceptionTest() throws Exception {
        StatusRuntimeException exception = new StatusRuntimeException(Status.INVALID_ARGUMENT);
        mockGameServerClustersService.addException((Exception)exception);
        try {
            PreviewUpdateGameServerClusterRequest request = PreviewUpdateGameServerClusterRequest.newBuilder().setGameServerCluster(GameServerCluster.newBuilder().build()).setUpdateMask(FieldMask.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
            this.client.previewUpdateGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

