/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1.it;

import com.google.cloud.ServiceOptions;
import com.google.cloud.gaming.v1.CreateGameServerConfigRequest;
import com.google.cloud.gaming.v1.CreateGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.DeleteGameServerConfigRequest;
import com.google.cloud.gaming.v1.DeleteGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.FetchDeploymentStateRequest;
import com.google.cloud.gaming.v1.FetchDeploymentStateResponse;
import com.google.cloud.gaming.v1.GameServerConfig;
import com.google.cloud.gaming.v1.GameServerConfigName;
import com.google.cloud.gaming.v1.GameServerConfigsServiceClient;
import com.google.cloud.gaming.v1.GameServerDeployment;
import com.google.cloud.gaming.v1.GameServerDeploymentName;
import com.google.cloud.gaming.v1.GameServerDeploymentRollout;
import com.google.cloud.gaming.v1.GameServerDeploymentsServiceClient;
import com.google.cloud.gaming.v1.GetGameServerConfigRequest;
import com.google.cloud.gaming.v1.GetGameServerDeploymentRequest;
import com.google.cloud.gaming.v1.GetGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.ListGameServerConfigsRequest;
import com.google.cloud.gaming.v1.ListGameServerDeploymentsRequest;
import com.google.cloud.gaming.v1.LocationName;
import com.google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutRequest;
import com.google.cloud.gaming.v1.PreviewGameServerDeploymentRolloutResponse;
import com.google.cloud.gaming.v1.Realm;
import com.google.cloud.gaming.v1.RealmName;
import com.google.cloud.gaming.v1.RealmsServiceClient;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ITSystemTest {
    private static RealmsServiceClient realmsServiceClient;
    private static GameServerDeploymentsServiceClient deploymentsServiceClient;
    private static GameServerConfigsServiceClient configsServiceClient;
    private static final String PROJECT;
    private static final String ID;
    private static final String LOCATION = "us-central1";
    private static final String REALM_ID;
    private static final String TIME_ZONE = "US/Central";
    private static final String DESCRIPTION = "description";
    private static final LocationName PARENT;
    private static final RealmName REALM_NAME;
    private static final String GLOBAL_LOCATION = "global";
    private static final String DEPLOYMENT_ID;
    private static final GameServerDeploymentName GAME_SERVER_DEPLOYMENT_NAME;
    private static final LocationName GAME_SERVER_DEPLOYMENT_PARENT;
    private static final String GAME_SERVER_NAME;
    private static final String CONFIG_ID;
    private static final GameServerConfigName GAME_SERVER_CONFIG_NAME;

    @BeforeClass
    public static void setUp() throws IOException, ExecutionException, InterruptedException {
        realmsServiceClient = RealmsServiceClient.create();
        Realm realm = Realm.newBuilder().setName(REALM_NAME.toString()).setTimeZone(TIME_ZONE).setDescription(DESCRIPTION).build();
        realmsServiceClient.createRealmAsync(PARENT, realm, REALM_ID).get();
        deploymentsServiceClient = GameServerDeploymentsServiceClient.create();
        GameServerDeployment gameServerDeployment = GameServerDeployment.newBuilder().setName(GAME_SERVER_DEPLOYMENT_NAME.toString()).setDescription(DESCRIPTION).build();
        CreateGameServerDeploymentRequest request = CreateGameServerDeploymentRequest.newBuilder().setParent(GAME_SERVER_DEPLOYMENT_PARENT.toString()).setDeploymentId(DEPLOYMENT_ID).setGameServerDeployment(gameServerDeployment).build();
        deploymentsServiceClient.createGameServerDeploymentAsync(request).get();
        configsServiceClient = GameServerConfigsServiceClient.create();
        GameServerConfig gameServerConfig = GameServerConfig.newBuilder().setName(GAME_SERVER_NAME).setDescription(DESCRIPTION).build();
        CreateGameServerConfigRequest configRequest = CreateGameServerConfigRequest.newBuilder().setParent(GAME_SERVER_DEPLOYMENT_NAME.toString()).setConfigId(CONFIG_ID).setGameServerConfig(gameServerConfig).build();
        configsServiceClient.createGameServerConfigAsync(configRequest).get();
    }

    @AfterClass
    public static void tearDown() throws ExecutionException, InterruptedException {
        realmsServiceClient.deleteRealmAsync(REALM_NAME).get();
        realmsServiceClient.close();
        DeleteGameServerConfigRequest deleteGameServerConfigRequest = DeleteGameServerConfigRequest.newBuilder().setName(GAME_SERVER_CONFIG_NAME.toString()).build();
        configsServiceClient.deleteGameServerConfigAsync(deleteGameServerConfigRequest).get();
        configsServiceClient.close();
        DeleteGameServerDeploymentRequest request = DeleteGameServerDeploymentRequest.newBuilder().setName(GAME_SERVER_DEPLOYMENT_NAME.toString()).build();
        deploymentsServiceClient.deleteGameServerDeploymentAsync(request).get();
        deploymentsServiceClient.close();
    }

    @Test
    public void getRealmTest() {
        Realm realm = realmsServiceClient.getRealm(REALM_NAME);
        Assert.assertNotNull((Object)realm);
        Assert.assertNotNull((Object)realm.getCreateTime());
        Assert.assertNotNull((Object)realm.getEtag());
        Assert.assertEquals((Object)REALM_NAME.toString(), (Object)realm.getName());
        Assert.assertEquals((Object)TIME_ZONE, (Object)realm.getTimeZone());
        Assert.assertEquals((Object)DESCRIPTION, (Object)realm.getDescription());
    }

    @Test
    public void listRealmsTest() {
        ArrayList realms = Lists.newArrayList((Iterable)realmsServiceClient.listRealms(PARENT).iterateAll());
        Assert.assertTrue((realms.size() > 0 ? 1 : 0) != 0);
        boolean found = false;
        for (Realm realm : realms) {
            if (!REALM_NAME.toString().equals(realm.getName())) continue;
            found = true;
            Assert.assertEquals((Object)TIME_ZONE, (Object)realm.getTimeZone());
            Assert.assertEquals((Object)DESCRIPTION, (Object)realm.getDescription());
            Assert.assertNotNull((Object)realm.getCreateTime());
            Assert.assertNotNull((Object)realm.getEtag());
        }
        Assert.assertTrue((String)"expected to find realm by resource name", (boolean)found);
    }

    @Test
    public void getGameServerDeploymentTest() {
        GetGameServerDeploymentRequest request = GetGameServerDeploymentRequest.newBuilder().setName(GAME_SERVER_DEPLOYMENT_NAME.toString()).build();
        GameServerDeployment gameServerDeployment = deploymentsServiceClient.getGameServerDeployment(request);
        Assert.assertNotNull((Object)gameServerDeployment);
        Assert.assertNotNull((Object)gameServerDeployment.getCreateTime());
        Assert.assertNotNull((Object)gameServerDeployment.getEtag());
        Assert.assertEquals((Object)GAME_SERVER_DEPLOYMENT_NAME.toString(), (Object)gameServerDeployment.getName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)gameServerDeployment.getDescription());
    }

    @Test
    public void listGameServerDeploymentsTest() {
        ListGameServerDeploymentsRequest request = ListGameServerDeploymentsRequest.newBuilder().setParent(GAME_SERVER_DEPLOYMENT_PARENT.toString()).build();
        ArrayList gameServerDeployments = Lists.newArrayList((Iterable)deploymentsServiceClient.listGameServerDeployments(request).iterateAll());
        Assert.assertEquals((long)1L, (long)gameServerDeployments.size());
        Assert.assertNotNull((Object)((GameServerDeployment)gameServerDeployments.get(0)).getCreateTime());
        Assert.assertNotNull((Object)((GameServerDeployment)gameServerDeployments.get(0)).getEtag());
        Assert.assertEquals((Object)GAME_SERVER_DEPLOYMENT_NAME.toString(), (Object)((GameServerDeployment)gameServerDeployments.get(0)).getName());
    }

    @Test
    public void fetchDeploymentStateTest() {
        FetchDeploymentStateResponse expectedResponse = FetchDeploymentStateResponse.newBuilder().build();
        FetchDeploymentStateRequest request = FetchDeploymentStateRequest.newBuilder().setName(GAME_SERVER_DEPLOYMENT_NAME.toString()).build();
        FetchDeploymentStateResponse stateResponse = deploymentsServiceClient.fetchDeploymentState(request);
        Assert.assertEquals((Object)expectedResponse, (Object)stateResponse);
    }

    @Test
    public void getGameServerDeploymentRolloutTest() {
        GetGameServerDeploymentRolloutRequest rolloutRequest = GetGameServerDeploymentRolloutRequest.newBuilder().setName(GAME_SERVER_DEPLOYMENT_NAME.toString()).build();
        GameServerDeploymentRollout response = deploymentsServiceClient.getGameServerDeploymentRollout(rolloutRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getCreateTime());
        Assert.assertNotNull((Object)response.getEtag());
        Assert.assertEquals((Object)(GAME_SERVER_DEPLOYMENT_NAME.toString() + "/rollout"), (Object)response.getName());
    }

    @Test
    public void previewGameServerDeploymentRolloutTest() {
        GameServerDeploymentRollout rollout = GameServerDeploymentRollout.newBuilder().setName(GAME_SERVER_DEPLOYMENT_NAME.toString()).build();
        PreviewGameServerDeploymentRolloutRequest request = PreviewGameServerDeploymentRolloutRequest.newBuilder().setRollout(rollout).build();
        PreviewGameServerDeploymentRolloutResponse response = deploymentsServiceClient.previewGameServerDeploymentRollout(request);
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getTargetState());
        Assert.assertNotNull((Object)response.getEtag());
    }

    @Test
    public void getGameServerConfigTest() {
        GetGameServerConfigRequest request = GetGameServerConfigRequest.newBuilder().setName(GAME_SERVER_CONFIG_NAME.toString()).build();
        GameServerConfig gameServerConfig = configsServiceClient.getGameServerConfig(request);
        Assert.assertNotNull((Object)gameServerConfig);
        Assert.assertNotNull((Object)gameServerConfig.getCreateTime());
        Assert.assertEquals((Object)GAME_SERVER_CONFIG_NAME.toString(), (Object)gameServerConfig.getName());
        Assert.assertEquals((Object)DESCRIPTION, (Object)gameServerConfig.getDescription());
    }

    @Test
    public void listGameServerConfigsTest() {
        ListGameServerConfigsRequest request = ListGameServerConfigsRequest.newBuilder().setParent(GAME_SERVER_DEPLOYMENT_NAME.toString()).build();
        ArrayList gameServerConfigs = Lists.newArrayList((Iterable)configsServiceClient.listGameServerConfigs(request).iterateAll());
        boolean found = false;
        for (GameServerConfig gameServerConfig : gameServerConfigs) {
            Assert.assertNotNull((Object)gameServerConfig.getCreateTime());
            if (!GAME_SERVER_CONFIG_NAME.toString().equals(gameServerConfig.getName())) continue;
            found = true;
            Assert.assertEquals((Object)DESCRIPTION, (Object)gameServerConfig.getDescription());
        }
        Assert.assertTrue((String)"expected to find game servcer config by resource name", (boolean)found);
    }

    static {
        PROJECT = ServiceOptions.getDefaultProjectId();
        ID = UUID.randomUUID().toString();
        REALM_ID = "realm-" + ID;
        PARENT = LocationName.of((String)PROJECT, (String)LOCATION);
        REALM_NAME = RealmName.of((String)PROJECT, (String)LOCATION, (String)REALM_ID);
        DEPLOYMENT_ID = "test-deployment-" + ID;
        GAME_SERVER_DEPLOYMENT_NAME = GameServerDeploymentName.of((String)PROJECT, (String)GLOBAL_LOCATION, (String)DEPLOYMENT_ID);
        GAME_SERVER_DEPLOYMENT_PARENT = LocationName.of((String)PROJECT, (String)GLOBAL_LOCATION);
        GAME_SERVER_NAME = "game-server-" + ID;
        CONFIG_ID = "test-config-" + ID;
        GAME_SERVER_CONFIG_NAME = GameServerConfigName.of((String)PROJECT, (String)GLOBAL_LOCATION, (String)DEPLOYMENT_ID, (String)CONFIG_ID);
    }
}

