/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.gaming.v1;

import com.google.api.client.http.HttpTransport;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.testing.MockHttpService;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.testing.FakeStatusCode;
import com.google.cloud.gaming.v1.GameServerCluster;
import com.google.cloud.gaming.v1.GameServerClusterConnectionInfo;
import com.google.cloud.gaming.v1.GameServerClusterName;
import com.google.cloud.gaming.v1.GameServerClusterView;
import com.google.cloud.gaming.v1.GameServerClustersServiceClient;
import com.google.cloud.gaming.v1.GameServerClustersServiceSettings;
import com.google.cloud.gaming.v1.KubernetesClusterState;
import com.google.cloud.gaming.v1.ListGameServerClustersResponse;
import com.google.cloud.gaming.v1.PreviewCreateGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewCreateGameServerClusterResponse;
import com.google.cloud.gaming.v1.PreviewDeleteGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewDeleteGameServerClusterResponse;
import com.google.cloud.gaming.v1.PreviewUpdateGameServerClusterRequest;
import com.google.cloud.gaming.v1.PreviewUpdateGameServerClusterResponse;
import com.google.cloud.gaming.v1.RealmName;
import com.google.cloud.gaming.v1.TargetState;
import com.google.cloud.gaming.v1.stub.HttpJsonGameServerClustersServiceStub;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Any;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class GameServerClustersServiceClientHttpJsonTest {
    private static MockHttpService mockService;
    private static GameServerClustersServiceClient client;

    @BeforeClass
    public static void startStaticServer() throws IOException {
        mockService = new MockHttpService(HttpJsonGameServerClustersServiceStub.getMethodDescriptors(), GameServerClustersServiceSettings.getDefaultEndpoint());
        GameServerClustersServiceSettings settings = ((GameServerClustersServiceSettings.Builder)((GameServerClustersServiceSettings.Builder)GameServerClustersServiceSettings.newHttpJsonBuilder().setTransportChannelProvider((TransportChannelProvider)GameServerClustersServiceSettings.defaultHttpJsonTransportProviderBuilder().setHttpTransport((HttpTransport)mockService).build())).setCredentialsProvider((CredentialsProvider)NoCredentialsProvider.create())).build();
        client = GameServerClustersServiceClient.create((GameServerClustersServiceSettings)settings);
    }

    @AfterClass
    public static void stopServer() {
        client.close();
    }

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
        mockService.reset();
    }

    @Test
    public void listGameServerClustersTest() throws Exception {
        GameServerCluster responsesElement = GameServerCluster.newBuilder().build();
        ListGameServerClustersResponse expectedResponse = ListGameServerClustersResponse.newBuilder().setNextPageToken("").addAllGameServerClusters(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        GameServerClustersServiceClient.ListGameServerClustersPagedResponse pagedListResponse = client.listGameServerClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerClustersList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listGameServerClustersExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            client.listGameServerClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void listGameServerClustersTest2() throws Exception {
        GameServerCluster responsesElement = GameServerCluster.newBuilder().build();
        ListGameServerClustersResponse expectedResponse = ListGameServerClustersResponse.newBuilder().setNextPageToken("").addAllGameServerClusters(Arrays.asList(responsesElement)).build();
        mockService.addResponse((Object)expectedResponse);
        String parent = "projects/project-3755/locations/location-3755/realms/realm-3755";
        GameServerClustersServiceClient.ListGameServerClustersPagedResponse pagedListResponse = client.listGameServerClusters(parent);
        ArrayList resources = Lists.newArrayList((Iterable)pagedListResponse.iterateAll());
        Assert.assertEquals((long)1L, (long)resources.size());
        Assert.assertEquals(expectedResponse.getGameServerClustersList().get(0), resources.get(0));
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void listGameServerClustersExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-3755/locations/location-3755/realms/realm-3755";
            client.listGameServerClusters(parent);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerClusterTest() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        GameServerCluster actualResponse = client.getGameServerCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGameServerClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
            client.getGameServerCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void getGameServerClusterTest2() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        String name = "projects/project-4532/locations/location-4532/realms/realm-4532/gameServerClusters/gameServerCluster-4532";
        GameServerCluster actualResponse = client.getGameServerCluster(name);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void getGameServerClusterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4532/locations/location-4532/realms/realm-4532/gameServerClusters/gameServerCluster-4532";
            client.getGameServerCluster(name);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerClusterTest() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        String gameServerClusterId = "gameServerClusterId-1301104032";
        GameServerCluster actualResponse = (GameServerCluster)client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createGameServerClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            RealmName parent = RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]");
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            String gameServerClusterId = "gameServerClusterId-1301104032";
            client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void createGameServerClusterTest2() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("createGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String parent = "projects/project-3755/locations/location-3755/realms/realm-3755";
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
        String gameServerClusterId = "gameServerClusterId-1301104032";
        GameServerCluster actualResponse = (GameServerCluster)client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void createGameServerClusterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String parent = "projects/project-3755/locations/location-3755/realms/realm-3755";
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().build();
            String gameServerClusterId = "gameServerClusterId-1301104032";
            client.createGameServerClusterAsync(parent, gameServerCluster, gameServerClusterId).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void previewCreateGameServerClusterTest() throws Exception {
        PreviewCreateGameServerClusterResponse expectedResponse = PreviewCreateGameServerClusterResponse.newBuilder().setEtag("etag3123477").setTargetState(TargetState.newBuilder().build()).setClusterState(KubernetesClusterState.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        PreviewCreateGameServerClusterRequest request = PreviewCreateGameServerClusterRequest.newBuilder().setParent(RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]").toString()).setGameServerClusterId("gameServerClusterId-1301104032").setGameServerCluster(GameServerCluster.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).setView(GameServerClusterView.forNumber((int)0)).build();
        PreviewCreateGameServerClusterResponse actualResponse = client.previewCreateGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void previewCreateGameServerClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PreviewCreateGameServerClusterRequest request = PreviewCreateGameServerClusterRequest.newBuilder().setParent(RealmName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]").toString()).setGameServerClusterId("gameServerClusterId-1301104032").setGameServerCluster(GameServerCluster.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).setView(GameServerClusterView.forNumber((int)0)).build();
            client.previewCreateGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGameServerClusterTest() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
        client.deleteGameServerClusterAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteGameServerClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerClusterName name = GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]");
            client.deleteGameServerClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void deleteGameServerClusterTest2() throws Exception {
        Empty expectedResponse = Empty.newBuilder().build();
        Operation resultOperation = Operation.newBuilder().setName("deleteGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        String name = "projects/project-4532/locations/location-4532/realms/realm-4532/gameServerClusters/gameServerCluster-4532";
        client.deleteGameServerClusterAsync(name).get();
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void deleteGameServerClusterExceptionTest2() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            String name = "projects/project-4532/locations/location-4532/realms/realm-4532/gameServerClusters/gameServerCluster-4532";
            client.deleteGameServerClusterAsync(name).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void previewDeleteGameServerClusterTest() throws Exception {
        PreviewDeleteGameServerClusterResponse expectedResponse = PreviewDeleteGameServerClusterResponse.newBuilder().setEtag("etag3123477").setTargetState(TargetState.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        PreviewDeleteGameServerClusterRequest request = PreviewDeleteGameServerClusterRequest.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setPreviewTime(Timestamp.newBuilder().build()).build();
        PreviewDeleteGameServerClusterResponse actualResponse = client.previewDeleteGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void previewDeleteGameServerClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PreviewDeleteGameServerClusterRequest request = PreviewDeleteGameServerClusterRequest.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setPreviewTime(Timestamp.newBuilder().build()).build();
            client.previewDeleteGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void updateGameServerClusterTest() throws Exception {
        GameServerCluster expectedResponse = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build();
        Operation resultOperation = Operation.newBuilder().setName("updateGameServerClusterTest").setDone(true).setResponse(Any.pack((Message)expectedResponse)).build();
        mockService.addResponse((Object)resultOperation);
        GameServerCluster gameServerCluster = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build();
        FieldMask updateMask = FieldMask.newBuilder().build();
        GameServerCluster actualResponse = (GameServerCluster)client.updateGameServerClusterAsync(gameServerCluster, updateMask).get();
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void updateGameServerClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            GameServerCluster gameServerCluster = GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build();
            FieldMask updateMask = FieldMask.newBuilder().build();
            client.updateGameServerClusterAsync(gameServerCluster, updateMask).get();
            Assert.fail((String)"No exception raised");
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
    }

    @Test
    public void previewUpdateGameServerClusterTest() throws Exception {
        PreviewUpdateGameServerClusterResponse expectedResponse = PreviewUpdateGameServerClusterResponse.newBuilder().setEtag("etag3123477").setTargetState(TargetState.newBuilder().build()).build();
        mockService.addResponse((Object)expectedResponse);
        PreviewUpdateGameServerClusterRequest request = PreviewUpdateGameServerClusterRequest.newBuilder().setGameServerCluster(GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build()).setUpdateMask(FieldMask.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
        PreviewUpdateGameServerClusterResponse actualResponse = client.previewUpdateGameServerCluster(request);
        Assert.assertEquals((Object)expectedResponse, (Object)actualResponse);
        List actualRequests = mockService.getRequestPaths();
        Assert.assertEquals((long)1L, (long)actualRequests.size());
        String apiClientHeaderKey = (String)mockService.getRequestHeaders().get((Object)ApiClientHeaderProvider.getDefaultApiClientHeaderKey()).iterator().next();
        Assert.assertTrue((boolean)GaxHttpJsonProperties.getDefaultApiClientHeaderPattern().matcher(apiClientHeaderKey).matches());
    }

    @Test
    public void previewUpdateGameServerClusterExceptionTest() throws Exception {
        ApiException exception = ApiExceptionFactory.createException((Throwable)new Exception(), (StatusCode)FakeStatusCode.of((StatusCode.Code)StatusCode.Code.INVALID_ARGUMENT), (boolean)false);
        mockService.addException((Exception)exception);
        try {
            PreviewUpdateGameServerClusterRequest request = PreviewUpdateGameServerClusterRequest.newBuilder().setGameServerCluster(GameServerCluster.newBuilder().setName(GameServerClusterName.of((String)"[PROJECT]", (String)"[LOCATION]", (String)"[REALM]", (String)"[CLUSTER]").toString()).setCreateTime(Timestamp.newBuilder().build()).setUpdateTime(Timestamp.newBuilder().build()).putAllLabels(new HashMap()).setConnectionInfo(GameServerClusterConnectionInfo.newBuilder().build()).setEtag("etag3123477").setDescription("description-1724546052").setClusterState(KubernetesClusterState.newBuilder().build()).build()).setUpdateMask(FieldMask.newBuilder().build()).setPreviewTime(Timestamp.newBuilder().build()).build();
            client.previewUpdateGameServerCluster(request);
            Assert.fail((String)"No exception raised");
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }
}

